/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.gcf;

import com.nokia.mj.impl.comms.CommsEndpoint;
import com.nokia.mj.impl.comms.CommsMessage;
import com.nokia.mj.impl.utils.Logger;
import com.nokia.mj.impl.utils.Uid;
import java.io.IOException;

public abstract class PushValidator {
    private static final int MSG_ID = 315;
    private static final int MOD_ID = 3;
    public static final String INSTALLER_COMMS = "InstallerJavaCaptain";
    public static final String RUNTIME_COMMS = "javacaptain";

    public abstract void validate(String var1, String var2, Uid var3, String var4, boolean var5) throws IOException;

    public static boolean isRegisteredPushUriStartingWith(String aBaseUri, Uid aIgnoreThis, String aCommsName) throws IOException {
        Logger.LOG(8, 4, "+ PushValidator.isRegisteredPushUriStartingWith()");
        if (null == aBaseUri) {
            throw new NullPointerException("null pointer was passed as an argument to PushValidator.isRegisteredPushUriStartingWith() operation");
        }
        aBaseUri = aBaseUri.trim();
        CommsEndpoint commsObj = CommsEndpoint.find(aCommsName);
        if (null == commsObj) {
            throw new IOException("Comms endpoint not initialized");
        }
        CommsMessage msg = new CommsMessage();
        msg.setMessageId(315);
        msg.setModuleId(3);
        msg.write(aBaseUri);
        CommsMessage retMsg = commsObj.sendReceive(msg, 15);
        return PushValidator.handleReplyMsg(retMsg, aIgnoreThis);
    }

    private static boolean handleReplyMsg(CommsMessage aMsg, Uid aIgnoreThis) throws IOException {
        Logger.LOG(8, 4, "+ PushValidator.handleReplyMsg()");
        int status = aMsg.readInt();
        if (-1 != status && 0 != status) {
            throw new IOException("Incorrect status value in IPC_PR_PUSH_URI_STARTS_WITH_QUERY_REPLY comms msg");
        }
        if (-1 == status) {
            return false;
        }
        String uidAsStr = aMsg.readString();
        Uid suiteUid = Uid.createUid(uidAsStr);
        if (null == suiteUid) {
            throw new IOException("Incorrect suite uid value in IPC_PR_PUSH_URI_STARTS_WITH_QUERY_REPLY comms msg");
        }
        return null == aIgnoreThis || true != aIgnoreThis.equals(suiteUid);
    }
}

