/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.gcf.protocol.mms;

import com.nokia.mj.impl.gcf.PushValidator;
import com.nokia.mj.impl.mms.MMSPermissionImpl;
import com.nokia.mj.impl.rt.support.ApplicationUtils;
import com.nokia.mj.impl.utils.Uid;

public class PushValidatorImpl
extends PushValidator {
    private static final String MMS_PREFIX = "mms://:";
    private final String INVALID_URI = "Invalid MMS URI";

    public void validate(String aUri, String aFilter, Uid aSuiteUid, String aMidletName, boolean aIsStaticRegistration) {
        if (!aUri.startsWith(MMS_PREFIX)) {
            throw new IllegalArgumentException("Invalid MMS URI");
        }
        String appId = aUri.substring(MMS_PREFIX.length());
        for (int i = 0; i < appId.length(); ++i) {
            char ch = appId.charAt(i);
            if (Character.isDigit(ch) || Character.isLowerCase(ch) || Character.isUpperCase(ch) || ch == '.' || ch == '_') continue;
            throw new IllegalArgumentException("Invalid MMS URI");
        }
        if (!this.isValidPhoneNumber(aFilter)) {
            throw new IllegalArgumentException("Invalid Filter");
        }
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        MMSPermissionImpl permission = new MMSPermissionImpl("mms://*", "open");
        appUtils.checkPermission(permission);
    }

    private boolean isValidPhoneNumber(String aFilter) {
        for (int i = 0; i < aFilter.length(); ++i) {
            char ch = aFilter.charAt(i);
            if (i == 0 && ch == '+' || Character.isDigit(ch) || ch == '*' || ch == '?') continue;
            return false;
        }
        return true;
    }
}

