/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.gcf.utils;

import com.nokia.mj.impl.gcf.utils.StreamsLogger;
import com.nokia.mj.impl.rt.support.Jvm;
import java.io.IOException;

public final class NativeError {
    public static final String NATIVE_ERROR_MESSAGE = "SymbianOS error = ";
    private static final int BUFFER_SIZE = 256;
    public static final int KErrNone = 0;
    public static final int KErrNotFound = -1;
    public static final int KErrGeneral = -2;
    public static final int KErrCancel = -3;
    public static final int KErrNoMemory = -4;
    public static final int KErrNotSupported = -5;
    public static final int KErrArgument = -6;
    public static final int KErrOverflow = -9;
    public static final int KErrAlreadyExists = -11;
    public static final int KErrPathNotFound = -12;
    public static final int KErrDied = -13;
    public static final int KErrNotReady = -18;
    public static final int KErrCorrupt = -20;
    public static final int KErrAccessDenied = -21;
    public static final int KErrWrite = -23;
    public static final int KErrEof = -25;
    public static final int KErrDiskFull = -26;
    public static final int KErrBadName = -28;
    public static final int KErrCommsLineFail = -29;
    public static final int KErrTimedOut = -33;
    public static final int KErrDisconnected = -36;
    public static final int KErrTooBig = -40;
    public static final int KErrDivideByZero = -41;
    public static final int KErrHardwareNotAvailable = -44;

    private NativeError() {
    }

    public static int checkExplicitOnly(int aError) {
        if (aError < 0) {
            switch (aError) {
                case -4: {
                    throw new OutOfMemoryError();
                }
                case -6: {
                    throw new IllegalArgumentException();
                }
                case -41: {
                    throw new ArithmeticException();
                }
            }
        }
        return aError;
    }

    public static int check(int aError) {
        if (aError < 0) {
            NativeError.checkExplicitOnly(aError);
            throw new Error(NativeError.errorMessage(aError));
        }
        return aError;
    }

    public static long check(long aError) {
        NativeError.check((int)aError);
        return aError;
    }

    public static int checkIO(int aError) throws IOException {
        if (aError < 0) {
            NativeError.checkExplicitOnly(aError);
            throw new IOException(NativeError.errorMessage(aError));
        }
        return aError;
    }

    public static int checkOOM(int aError) {
        if (aError < 0) {
            if (aError == -4) {
                throw new OutOfMemoryError();
            }
            throw new Error(NativeError.errorMessage(aError));
        }
        return aError;
    }

    public static Object checkOOM(Object aObject) {
        if (aObject == null) {
            throw new OutOfMemoryError();
        }
        return aObject;
    }

    public static int checkOOMOnly(int aError) {
        if (aError == -4) {
            throw new OutOfMemoryError();
        }
        return aError;
    }

    public static String errorMessage(int aError) {
        String message = NativeError._getNativeErrorMessage(aError);
        String result = NATIVE_ERROR_MESSAGE.concat(Integer.toString(aError));
        if (message != null && message.length() > 0) {
            result = result.concat(" : ").concat(message);
        }
        return result;
    }

    public static String errorMessage(int aError, String aExtraText) {
        StringBuffer messageBuf = new StringBuffer(256);
        messageBuf.append(aExtraText);
        messageBuf.append(", ");
        messageBuf.append(NativeError.errorMessage(aError));
        return messageBuf.toString();
    }

    private static native String _getNativeErrorMessage(int var0);

    static {
        try {
            Jvm.loadSystemLibrary("javagcf");
        }
        catch (Exception e) {
            StreamsLogger.ELog("Unable to load native libraries!");
        }
    }
}

