/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.gcf.utils;

import com.nokia.mj.impl.gcf.utils.InputStreamBase;
import com.nokia.mj.impl.gcf.utils.OutputStreamBase;
import com.nokia.mj.impl.gcf.utils.Prefetch;
import com.nokia.mj.impl.gcf.utils.StreamsLogger;
import com.nokia.mj.impl.rt.support.Jvm;
import com.nokia.mj.impl.utils.OsErrorMessage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;

public abstract class StreamConnectionBase {
    public static final int EOF = -1;
    protected static final int INITIAL = 0;
    protected static final int OPEN = 1;
    protected static final int CLOSED = 2;
    protected static final int ERROR = 3;
    protected static final int PENDING_CLOSED = 4;
    protected int iState;
    protected boolean iSupportMarkAndReset;
    protected int iMode;
    protected InputStreamBase iInputStream;
    protected OutputStreamBase iOutputStream;
    protected DataInputStream iDataInputStream;
    protected DataOutputStream iDataOutputStream;
    protected Object iWriteOperation;
    protected Object iCloseOperation;
    protected Object iReadOperation;
    protected boolean iDoPrefetch;
    protected Prefetch iPrefetch;
    protected int iNativePeerHandle;
    protected int iBufferSize = 512;

    public StreamConnectionBase(String aUri, int aMode, boolean aTimeouts) {
        this(aUri, aMode, aTimeouts, true, 512, true);
    }

    public StreamConnectionBase(String aUri, int aMode, boolean aTimeouts, boolean aDoPrefetch) {
        this(aUri, aMode, aTimeouts, aDoPrefetch, 512, true);
    }

    public StreamConnectionBase(String aUri, int aMode, boolean aTimeouts, boolean aDoPrefetch, int aReadBufferSize) {
        this(aUri, aMode, aTimeouts, aDoPrefetch, aReadBufferSize, true);
    }

    public StreamConnectionBase(String aUri, int aMode, boolean aTimeouts, boolean aDoPrefetch, int aReadBufferSize, boolean aMarkSupported) {
        StreamsLogger.Log(2, " +  StreamConnectionBase: Constructor");
        this.iCloseOperation = new Object();
        this.iWriteOperation = new Object();
        this.iReadOperation = new Object();
        this.iPrefetch = null;
        this.iState = 0;
        this.iMode = aMode;
        this.iSupportMarkAndReset = aMarkSupported;
        this.iDoPrefetch = aDoPrefetch;
        this.iNativePeerHandle = 0;
        this.iBufferSize = aReadBufferSize;
        StreamsLogger.Log(3, "    StreamConnectionBase: Creating Native Peer");
        this.iNativePeerHandle = this.createNativePeer(aUri, aMode, aTimeouts);
        if (this.iNativePeerHandle != 0) {
            StreamsLogger.Log(3, "    StreamConnectionBase: Setting native buffer size to " + this.iBufferSize);
            this._setNativeBufferSize(this.iNativePeerHandle, this.iBufferSize);
        }
        StreamsLogger.Log(2, " -  StreamConnectionBase: Constructor");
    }

    protected abstract int createNativePeer(String var1, int var2, boolean var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream openInputStream() throws IOException {
        StreamsLogger.Log(2, " +  StreamConnectionBase: openInputStream()");
        this.checkMode(1);
        Object object = this.iReadOperation;
        synchronized (object) {
            Object object2 = this.iCloseOperation;
            synchronized (object2) {
                this.ensureOpen();
                if (this.iInputStream != null) {
                    StreamsLogger.WLog("    StreamConnectionBase: openInputStream() Attempt to open second InputStream. IOException");
                    throw new IOException("InputStream already open");
                }
                this.iInputStream = new InputStreamBase(this, this.iCloseOperation, this.iSupportMarkAndReset);
                if (this.iDoPrefetch) {
                    StreamsLogger.Log(2, "    StreamConnectionBase: openInputStream(): Starting Prefetch");
                    this.startPrefetch();
                }
            }
        }
        StreamsLogger.Log(2, " -  StreamConnectionBase: openInputStream()");
        return this.iInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataInputStream openDataInputStream() throws IOException {
        this.checkMode(1);
        Object object = this.iCloseOperation;
        synchronized (object) {
            this.ensureOpen();
            if (this.iDataInputStream != null) {
                throw new IOException("InputStream already open");
            }
            this.iDataInputStream = new DataInputStream(this.openInputStream());
        }
        return this.iDataInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream openOutputStream() throws IOException {
        StreamsLogger.Log(2, " +  StreamConnectionBase: openOutputStream()");
        this.checkMode(2);
        Object object = this.iCloseOperation;
        synchronized (object) {
            this.ensureOpen();
            if (this.iOutputStream != null) {
                StreamsLogger.WLog("    StreamConnectionBase: openOutputStream() Attempt to open second OutputStream. IOException");
                throw new IOException("OutputStream already open");
            }
            this.iOutputStream = new OutputStreamBase(this, this.iCloseOperation, true);
        }
        StreamsLogger.Log(2, " -  StreamConnectionBase: openOutputStream()");
        return this.iOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataOutputStream openDataOutputStream() throws IOException {
        this.checkMode(2);
        Object object = this.iCloseOperation;
        synchronized (object) {
            this.ensureOpen();
            if (this.iDataOutputStream != null) {
                throw new IOException("OutputStream already open");
            }
            this.iDataOutputStream = new DataOutputStream(this.openOutputStream());
        }
        return this.iDataOutputStream;
    }

    protected final void checkMode(int aAction) throws IOException {
        if ((this.iMode & aAction) == 0) {
            throw new IOException("Bad action for access mode");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void ensureOpen() throws IOException {
        Object object = this.iCloseOperation;
        synchronized (object) {
            if (this.iState == 2) {
                throw new IOException("Connection Closed");
            }
        }
    }

    protected void closeInputStreams() {
        StreamsLogger.Log(2, " +  StreamConnectionBase: closeInputStreams()");
        try {
            if (this.iInputStream != null) {
                this.iInputStream.close();
                this.iInputStream = null;
            }
            if (this.iDataInputStream != null) {
                this.iDataInputStream.close();
                this.iDataInputStream = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        StreamsLogger.Log(2, " -  StreamConnectionBase: closeInputStreams()");
    }

    protected void closeOutputStreams() {
        StreamsLogger.Log(2, " +  StreamConnectionBase: closeOutputStreams()");
        try {
            if (this.iOutputStream != null) {
                this.iOutputStream.close();
                this.iOutputStream = null;
            }
            if (this.iDataOutputStream != null) {
                this.iDataOutputStream.close();
                this.iDataOutputStream = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        StreamsLogger.Log(2, " -  StreamConnectionBase: closeOutputStreams()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBytes(byte[] aBuffer) throws InterruptedIOException, IOException {
        StreamsLogger.Log(2, " +  StreamConnectionBase: readBytes()");
        int result = 1;
        Object object = this.iReadOperation;
        synchronized (object) {
            if (this.iDoPrefetch) {
                StreamsLogger.Log(3, "    StreamConnectionBase: readBytes(): Getting Prefetched Data");
                result = this.iPrefetch.getPrefetched(aBuffer);
            } else {
                StreamsLogger.Log(3, "    StreamConnectionBase: readBytes(): Getting data directly from native");
                result = this.readData(aBuffer);
            }
            if (result == 0) {
                StreamsLogger.Log(3, "    StreamConnectionBase: readBytes(): Read result = EOF");
                return -1;
            }
            if (result < 0) {
                throw new IOException(OsErrorMessage.getErrorMessage(result));
            }
        }
        StreamsLogger.Log(2, " -  StreamConnectionBase: readBytes()");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBytes(byte[] aBytes, int aOffset, int aLength) throws IOException {
        StreamsLogger.Log(2, " +  StreamConnectionBase: writeBytes()");
        Object object = this.iWriteOperation;
        synchronized (object) {
            int nLeftToWrite = aLength;
            int written = 0;
            int totalWritten = 0;
            while (nLeftToWrite > 0) {
                StreamsLogger.Log(3, "   StreamConnectionBase: writeBytes():  Calling writeData():  DataLength: " + aBytes.length + " Offset: " + aOffset + totalWritten + " Length: " + nLeftToWrite);
                written = this.writeData(aBytes, aOffset + totalWritten, nLeftToWrite);
                if (written < 0) {
                    throw new IOException(OsErrorMessage.getErrorMessage(written));
                }
                nLeftToWrite -= written;
                totalWritten += written;
            }
        }
        StreamsLogger.Log(2, " -  StreamConnectionBase: writeBytes()");
    }

    public int writeData(byte[] aBytes, int aOffset, int aLength) {
        int err = this._writebytes(this.iNativePeerHandle, aBytes, aOffset, aLength);
        return err;
    }

    public int readData(byte[] aBytes) {
        int err = this._readbytes(this.iNativePeerHandle, aBytes);
        return err;
    }

    public void cancelRead() {
        StreamsLogger.Log(2, " +  StreamConnectionBase: cancelRead()");
        if (this.iDoPrefetch) {
            this.iPrefetch.close();
            this.iPrefetch = null;
        }
        this.stopReading();
        this.closeInputStreams();
        StreamsLogger.Log(2, " -  StreamConnectionBase: cancelRead()");
    }

    public void cancelWrite() {
        StreamsLogger.Log(2, " +  StreamConnectionBase: cancelWrite()");
        this.stopWriting();
        this.closeOutputStreams();
        StreamsLogger.Log(2, " -  StreamConnectionBase: cancelWrite()");
    }

    public void stopWriting() {
        this._stopwriting(this.iNativePeerHandle);
    }

    public void stopReading() {
        this._stopreading(this.iNativePeerHandle);
    }

    protected boolean isStreamsClosed() {
        return this.iInputStream == null && this.iOutputStream == null;
    }

    static void checkIOParams(byte[] aBytes, int aOffset, int aLength) {
        if (aOffset < 0 || aLength < 0 || aOffset + aLength > aBytes.length) {
            throw new IndexOutOfBoundsException();
        }
    }

    final int available() throws IOException {
        StreamsLogger.Log(2, " +  StreamConnectionBase: available()");
        int readOperationResult = 0;
        if (this.iDoPrefetch) {
            readOperationResult = this.iPrefetch.getResult();
            if (readOperationResult < 0) {
                throw new IOException(OsErrorMessage.getErrorMessage(readOperationResult));
            }
        } else {
            StreamsLogger.Log(2, " StreamConnectionBase: callling _available()");
            readOperationResult = this._available(this.iNativePeerHandle);
        }
        StreamsLogger.Log(2, " -  StreamConnectionBase: available()");
        return readOperationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        StreamsLogger.Log(2, " +  StreamConnectionBase: close()");
        Object object = this.iCloseOperation;
        synchronized (object) {
            if (this.iState != 2) {
                this.iState = 2;
            }
        }
        StreamsLogger.Log(2, " -  StreamConnectionBase: close()");
    }

    public void startPrefetch() {
        if (this.iPrefetch == null) {
            this.iPrefetch = new Prefetch(this);
        }
    }

    protected native int _readbytes(int var1, byte[] var2);

    protected native int _writebytes(int var1, byte[] var2, int var3, int var4);

    protected native void _stopreading(int var1);

    protected native void _stopwriting(int var1);

    protected native void _setNativeBufferSize(int var1, int var2);

    protected native int _available(int var1);

    static {
        try {
            Jvm.loadSystemLibrary("javagcf");
        }
        catch (Exception e) {
            StreamsLogger.ELog("Unable to load native libraries!");
        }
    }
}

