/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.gcf.utils;

import com.nokia.mj.impl.gcf.utils.StreamsLogger;
import com.nokia.mj.impl.rt.support.Jvm;

public final class URI {
    private static final int PROTOCOL = 1;
    private static final int TARGET = 2;
    private static final int HOST = 3;
    private static final int PORT = 4;
    private static final int PATH = 5;
    private static final int PARAMETER = 6;
    private static final int QUERY = 7;
    private static final String EMPTY_STRING = "";
    private final String iFullURI;
    private final int[] iErrorCache = new int[1];

    public URI(String aURIString) {
        this.iFullURI = aURIString;
    }

    private String parse(int aUriPortion) {
        return this.parse(aUriPortion, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String parse(int aUriPortion, String aParameterName) {
        int error = 0;
        String value = null;
        URI uRI = this;
        synchronized (uRI) {
            value = this._parse(this.iFullURI, aUriPortion, aParameterName, this.iErrorCache);
            error = this.iErrorCache[0];
        }
        if (value == null) {
            if (error == -1) {
                return EMPTY_STRING;
            }
            if (error != 0) {
                throw new IllegalArgumentException();
            }
        }
        return value;
    }

    private native String _parse(String var1, int var2, String var3, int[] var4);

    public String getProtocol() {
        return this.parse(1);
    }

    public String getHost() {
        return this.parse(3);
    }

    public String getPort() {
        return this.parse(4);
    }

    public String getPath() {
        return this.parse(5);
    }

    public String getParameter(String aParameterName) {
        return this.parse(6, aParameterName);
    }

    public String getQuery() {
        return this.parse(7);
    }

    public String toString() {
        return this.iFullURI;
    }

    static {
        try {
            Jvm.loadSystemLibrary("javagcf");
        }
        catch (Exception e) {
            StreamsLogger.ELog("Unable to load native libraries!");
        }
    }
}

