/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.installer.pushregistrator;

import com.nokia.mj.impl.utils.JavaLanguageSyntaxChecker;
import com.nokia.mj.impl.utils.Logger;
import com.nokia.mj.impl.utils.Tokenizer;
import com.nokia.mj.impl.utils.Uid;
import com.nokia.mj.impl.utils.exception.InvalidAttributeException;

public class PushInfo {
    public static final String PUSH_REGISTRATOR_CLASS = "com.nokia.mj.impl.push.PushRegistratorImpl";
    public static final int REG_DYNAMIC = 0;
    public static final int REG_STATIC = 1;
    private Uid iUid = null;
    private String iName = null;
    private String iConnectionUrl = null;
    private String iClassName = null;
    private String iFilter = null;
    private int iRegType = 1;

    public PushInfo(Uid aUid, String aPushAttribute) {
        String[] tokens = Tokenizer.split(aPushAttribute, ",");
        if (tokens == null || tokens.length != 3) {
            Logger.LOG(12, 1, "Invalid number of tokens in push attribute: " + aPushAttribute);
            throw new InvalidAttributeException(3, null, 7, new String[]{aPushAttribute}, 906);
        }
        this.iUid = aUid;
        this.iConnectionUrl = tokens[0].trim();
        this.iClassName = tokens[1].trim();
        this.iFilter = tokens[2].trim();
        if (!JavaLanguageSyntaxChecker.checkClassName(this.iClassName)) {
            Logger.LOG(12, 1, "Invalid class name in push attribute: " + aPushAttribute);
            throw new InvalidAttributeException(3, null, 3, new String[]{aPushAttribute}, 906);
        }
    }

    public PushInfo(Uid aUid, String aConnectionUrl, String aClassName, String aFilter, int aRegType) {
        this.iUid = aUid;
        this.iConnectionUrl = aConnectionUrl;
        this.iClassName = aClassName;
        this.iFilter = aFilter;
        this.iRegType = aRegType;
    }

    public void setName(String aName) {
        this.iName = aName;
    }

    public String getName() {
        return this.iName;
    }

    public void setUid(Uid aUid) {
        this.iUid = aUid;
    }

    public Uid getUid() {
        return this.iUid;
    }

    public String getConnectionUrl() {
        return this.iConnectionUrl;
    }

    public String getClassName() {
        return this.iClassName;
    }

    public String getFilter() {
        return this.iFilter;
    }

    public String getPushAttribute() {
        return this.getConnectionUrl() + ", " + this.getClassName() + ", " + this.getFilter();
    }

    public int getRegType() {
        return this.iRegType;
    }

    public String toString() {
        String regType = this.getRegType() == 1 ? "static" : "dynamic";
        return this.getName() + ", " + this.getUid() + ", " + regType + ": " + this.getPushAttribute();
    }
}

