/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.installer.ui;

import com.nokia.mj.impl.installer.ui.DownloadInfo;
import com.nokia.mj.impl.installer.ui.InstallInfo;
import com.nokia.mj.impl.installer.ui.InstallerUiListener;
import com.nokia.mj.impl.installer.ui.InstallerUiTexts;
import com.nokia.mj.impl.installer.ui.LaunchAppInfo;
import com.nokia.mj.impl.installer.ui.PermissionInfo;
import com.nokia.mj.impl.installer.ui.UninstallInfo;
import com.nokia.mj.impl.utils.Logger;
import com.nokia.mj.impl.utils.exception.InstallerExceptionBase;

public class InstallerUi {
    public static final int MODE_INSTALL = 1;
    public static final int MODE_UNINSTALL = 2;
    public static final int MODE_APP_CONVERSION = 3;
    protected int iMode = 0;
    protected InstallerUiListener iListener = null;
    protected InstallInfo iInstallInfo = null;
    protected UninstallInfo iUninstallInfo = null;
    protected int iAppConversionCurrent = 0;
    protected int iAppConversionTotal = 0;
    protected boolean iConfirmationsCanceled = false;
    private boolean iOcspIndicator = false;
    private static String iThisClassName = null;

    public void init(int aMode, InstallerUiListener aListener) {
        this.iMode = aMode;
        this.iListener = aListener;
        iThisClassName = InstallerUi.getClassName(this);
    }

    public void cancel() {
        if (this.iListener != null) {
            new Thread(new Runnable(){

                public void run() {
                    InstallerUi.this.iListener.cancel();
                }
            }, "InstallerUiCancelThread").start();
        }
    }

    public void cancelConfirmations() {
        this.iConfirmationsCanceled = true;
    }

    public boolean confirm(InstallInfo aInstallInfo) {
        this.iInstallInfo = aInstallInfo;
        InstallerUi.log("Confirm installation: " + this.iInstallInfo);
        return true;
    }

    public boolean confirmPermissions(PermissionInfo aPermissionInfo) {
        InstallerUi.log("Confirm permissions: " + aPermissionInfo);
        return true;
    }

    public boolean confirm(UninstallInfo aUninstallInfo) {
        this.iUninstallInfo = aUninstallInfo;
        InstallerUi.log("Confirm uninstallation: " + this.iUninstallInfo);
        return true;
    }

    public void started() {
        InstallerUi.log("Started " + this.getTitle());
    }

    public void updateProgress(int aProgress) {
        InstallerUi.log("Progress: " + aProgress + "%");
    }

    public void ended() {
        InstallerUi.log("Ended " + this.getTitle());
    }

    public void started(DownloadInfo aDownloadInfo) {
        InstallerUi.log("Download started: " + aDownloadInfo);
    }

    public void updateProgress(DownloadInfo aDownloadInfo) {
        InstallerUi.log("Download progress: " + aDownloadInfo.getCurrentSize() + " bytes");
    }

    public void ended(DownloadInfo aDownloadInfo) {
        InstallerUi.log("Download ended: " + aDownloadInfo);
    }

    public void setOcspIndicator(boolean aOn) {
        InstallerUi.log("setOcspIndicator: " + aOn);
        this.iOcspIndicator = aOn;
    }

    public boolean getOcspIndicator() {
        return this.iOcspIndicator;
    }

    public void updateAppConversionIndicator(int aCurrent, int aTotal) {
        InstallerUi.log("updateAppConversionIndicator: " + aCurrent + "/" + aTotal);
        this.iAppConversionCurrent = aCurrent;
        this.iAppConversionTotal = aTotal;
    }

    public void error(InstallerExceptionBase aInstallerException) {
        String appName = this.getAppName();
        if (appName != null) {
            InstallerUi.log("Error during " + this.getTitle() + " of " + appName + ": " + aInstallerException.toString());
        } else {
            InstallerUi.log("Error: " + aInstallerException.toString());
        }
    }

    public String[] getUsernamePassword(String aUrl) {
        InstallerUi.log("Get username and password returns empty strings");
        return new String[]{"", ""};
    }

    public boolean launchAppQuery(LaunchAppInfo aLaunchAppInfo) {
        InstallerUi.log("Launch app query: " + aLaunchAppInfo);
        return false;
    }

    public static void log(String aMsg) {
        if (Logger.Activated[12]) {
            String msg = iThisClassName + ": " + aMsg;
            Logger.LOG(12, 4, msg);
        }
    }

    public static void logError(String aMsg, Throwable aThrowable) {
        if (Logger.Activated[12]) {
            String msg = iThisClassName + ": " + aMsg;
            Logger.LOG(12, 1, msg, aThrowable);
        }
    }

    protected String getAppName() {
        String appName = null;
        if (this.iInstallInfo != null) {
            appName = this.iInstallInfo.getName();
        } else if (this.iUninstallInfo != null) {
            appName = this.iUninstallInfo.getName();
        }
        return appName;
    }

    protected String getTitle() {
        String result = null;
        if (this.iMode == 1) {
            result = InstallerUiTexts.get("progress");
        } else if (this.iMode == 2) {
            result = InstallerUiTexts.get("uninstalling_progress");
        } else if (this.iMode == 3) {
            result = InstallerUiTexts.get("app_conversion_progress", new Object[]{new Integer(this.iAppConversionCurrent), new Integer(this.iAppConversionTotal)});
        }
        return result;
    }

    protected static String getClassName(Object aObject) {
        String result = aObject.getClass().getName();
        int dotIndex = result.lastIndexOf(46);
        if (dotIndex > 0) {
            result = result.substring(dotIndex + 1);
        }
        return result;
    }
}

