/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.installer.ui.eswt;

import com.nokia.mj.impl.installer.ui.InstallInfo;
import com.nokia.mj.impl.installer.ui.InstallerUiTexts;
import com.nokia.mj.impl.installer.ui.PermissionInfo;
import com.nokia.mj.impl.installer.ui.eswt.CertificateDetailsView;
import com.nokia.mj.impl.installer.ui.eswt.ConfirmationViewBase;
import com.nokia.mj.impl.installer.ui.eswt.InstallerUiEswt;
import com.nokia.mj.impl.installer.ui.eswt.PermissionDetailsView;
import com.nokia.mj.impl.security.midp.common.SigningCertificate;
import java.io.InputStream;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class PermissionConfirmationView
extends ConfirmationViewBase {
    private PermissionDetailsView iPermissionDetailsView = null;
    private CertificateDetailsView iCertificateDetailsView = null;
    private InstallInfo iInstallInfo = null;
    private PermissionInfo iPermissionInfo = null;
    private Image iSuiteIcon = null;

    protected PermissionConfirmationView() {
    }

    protected PermissionConfirmationView(Composite aParent) {
        super(aParent, 8);
        this.setTitle(InstallerUiTexts.get("progress"));
        this.setCommands(InstallerUiTexts.get("ok"), InstallerUiTexts.get("cancel"));
    }

    public boolean confirm(InstallInfo aInstallInfo, PermissionInfo aPermissionInfo) {
        this.iInstallInfo = aInstallInfo;
        this.iPermissionInfo = aPermissionInfo;
        boolean result = this.confirm();
        if (result) {
            this.log("permissionConfirmationView confirmed");
        } else {
            this.log("permissionConfirmationView cancelled");
        }
        return result;
    }

    protected void createView() {
        SigningCertificate[] certs;
        GridData gridData = null;
        int horizontalSpan = this.getColumns() - 1;
        int labelStyle = 64;
        InputStream iconInputStream = this.iInstallInfo.getIconInputStream();
        if (iconInputStream != null) {
            this.iSuiteIcon = InstallerUiEswt.loadImage(this.getComposite().getDisplay(), iconInputStream, this.iInstallInfo.getIconPath());
            if (this.iSuiteIcon != null) {
                Label iconLabel = this.createLabel(this.iSuiteIcon, 2, 0);
                horizontalSpan = this.getColumns() - 3;
            } else {
                horizontalSpan = this.getColumns() - 1;
            }
        }
        String title = InstallerUiTexts.get("query", new String[]{this.iInstallInfo.getName()});
        if (this.iInstallInfo.getOldVersion() != null) {
            title = InstallerUiTexts.get("update_query", new String[]{this.iInstallInfo.getName(), this.iInstallInfo.getOldVersion(), this.iInstallInfo.getVersion()});
        }
        Label titleLabel = this.createLabel(title, horizontalSpan, labelStyle);
        titleLabel.setFont(this.getBoldFont());
        boolean identified = this.iInstallInfo.getCertificates() != null;
        Label securityIconLabel = this.createSecurityLabel(identified);
        horizontalSpan = this.getColumns();
        Label domainLabel = this.createLabel(InstallerUiTexts.get("perm_query"), horizontalSpan, labelStyle);
        if (this.iPermissionInfo != null && this.iPermissionInfo.getPermissionNames() != null && this.iPermissionInfo.getPermissionNames().length > 0) {
            Link detailsLink = new Link(this.getComposite(), 0);
            detailsLink.setText("<a>" + InstallerUiTexts.get("perm_view_details") + "</a>");
            detailsLink.addListener(13, new Listener(){

                public void handleEvent(Event aEvent) {
                    PermissionConfirmationView.this.openDetailsView();
                }
            });
            gridData = new GridData(768);
            gridData.horizontalSpan = horizontalSpan;
            detailsLink.setLayoutData((Object)gridData);
        }
        if ((certs = this.iInstallInfo.getCertificates()) != null) {
            int i = 0;
            while (i < 1) {
                Link certLink = new Link(this.getComposite(), 0);
                certLink.setText("<a>" + InstallerUiTexts.get("view_cert_details") + "</a>");
                final int certIndex = i++;
                certLink.addListener(13, new Listener(){

                    public void handleEvent(Event aEvent) {
                        PermissionConfirmationView.this.openCertsView(certIndex);
                    }
                });
                gridData = new GridData(768);
                gridData.horizontalSpan = horizontalSpan;
                certLink.setLayoutData((Object)gridData);
            }
        }
        Button allowButton = new Button(this.getComposite(), 0);
        allowButton.setText(InstallerUiTexts.get("perm_allow_always"));
        allowButton.addListener(13, new Listener(){

            public void handleEvent(Event aEvent) {
                PermissionConfirmationView.this.iPermissionInfo.setPermissionAllowed(true);
                PermissionConfirmationView.this.confirmOk();
            }
        });
        allowButton.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent aEvent) {
                if (!PermissionConfirmationView.this.userHasAnswered()) {
                    PermissionConfirmationView.this.iPermissionInfo.setPermissionAllowed(true);
                }
            }

            public void focusLost(FocusEvent aEvent) {
            }
        });
        gridData = new GridData(768);
        gridData.horizontalSpan = horizontalSpan;
        allowButton.setLayoutData((Object)gridData);
        allowButton.setFocus();
        Button denyButton = new Button(this.getComposite(), 0);
        denyButton.setText(InstallerUiTexts.get("perm_ask_me_later"));
        denyButton.addListener(13, new Listener(){

            public void handleEvent(Event aEvent) {
                PermissionConfirmationView.this.iPermissionInfo.setPermissionAllowed(false);
                PermissionConfirmationView.this.confirmOk();
            }
        });
        denyButton.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent aEvent) {
                if (!PermissionConfirmationView.this.userHasAnswered()) {
                    PermissionConfirmationView.this.iPermissionInfo.setPermissionAllowed(false);
                }
            }

            public void focusLost(FocusEvent aEvent) {
            }
        });
        gridData = new GridData(768);
        gridData.horizontalSpan = horizontalSpan;
        denyButton.setLayoutData((Object)gridData);
    }

    protected void getDataFromView() {
    }

    protected int getStyle() {
        return 512;
    }

    protected void screenOrientationChanged() {
        super.screenOrientationChanged();
        if (this.iPermissionDetailsView != null) {
            this.iPermissionDetailsView.screenOrientationChanged();
        }
        if (this.iCertificateDetailsView != null) {
            this.iCertificateDetailsView.screenOrientationChanged();
        }
    }

    private void openDetailsView() {
        if (this.iPermissionDetailsView != null) {
            return;
        }
        this.iPermissionDetailsView = new PermissionDetailsView((Composite)new Shell(this.getShell(), this.getShell().getStyle()), this.getTitle(), this.iPermissionInfo);
        this.iPermissionDetailsView.setInstallerUi(this.getInstallerUi());
        new Thread(new Runnable(){

            public void run() {
                if (PermissionConfirmationView.this.iPermissionDetailsView.confirm()) {
                    PermissionConfirmationView.this.log("permissionDetailsView confirmed");
                    PermissionConfirmationView.this.confirmOk();
                } else {
                    PermissionConfirmationView.this.log("permissionDetailsView cancelled");
                }
                PermissionConfirmationView.this.iPermissionDetailsView.dispose();
                PermissionConfirmationView.this.iPermissionDetailsView = null;
            }
        }, "InstallerUiPermDetailsViewThread").start();
    }

    private void openCertsView(int aCertIndex) {
        this.iCertificateDetailsView = new CertificateDetailsView((Composite)new Shell(this.getShell(), this.getShell().getStyle()), this.getTitle(), this.iInstallInfo, aCertIndex);
        this.iCertificateDetailsView.setInstallerUi(this.getInstallerUi());
        new Thread(new Runnable(){

            public void run() {
                if (PermissionConfirmationView.this.iCertificateDetailsView.confirm()) {
                    PermissionConfirmationView.this.log("certificateDetailsView confirmed");
                    PermissionConfirmationView.this.confirmOk();
                } else {
                    PermissionConfirmationView.this.log("certificateDetailsView cancelled");
                }
                PermissionConfirmationView.this.iCertificateDetailsView.dispose();
                PermissionConfirmationView.this.iCertificateDetailsView = null;
            }
        }, "InstallerUiCertViewThread").start();
    }
}

