/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.installer.ui.eswt;

import com.nokia.mj.impl.installer.ui.ApplicationInfo;
import com.nokia.mj.impl.installer.ui.InstallerUiTexts;
import com.nokia.mj.impl.installer.ui.UninstallInfo;
import com.nokia.mj.impl.installer.ui.eswt.ConfirmationViewBase;
import com.nokia.mj.impl.installer.ui.eswt.InstallerUiEswt;
import java.io.InputStream;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class UninstallConfirmationView
extends ConfirmationViewBase {
    private UninstallInfo iUninstallInfo = null;

    protected UninstallConfirmationView() {
    }

    protected UninstallConfirmationView(Composite aParent) {
        super(aParent, 8);
        this.setTitle(InstallerUiTexts.get("uninstalling_progress"));
        this.setCommands(InstallerUiTexts.get("ok"), InstallerUiTexts.get("cancel"));
    }

    public boolean confirm(UninstallInfo aUninstallInfo) {
        this.iUninstallInfo = aUninstallInfo;
        boolean result = this.confirm();
        if (result) {
            this.log("uninstallConfirmationView confirmed");
        } else {
            this.log("uninstallConfirmationView cancelled");
        }
        return result;
    }

    protected void createView() {
        String deleteConfirm;
        Object gridData = null;
        int horizontalSpan = this.getColumns() - 1;
        int labelStyle = 64;
        InputStream iconInputStream = this.iUninstallInfo.getIconInputStream();
        if (iconInputStream != null) {
            Image image = InstallerUiEswt.loadImage(this.getComposite().getDisplay(), iconInputStream, this.iUninstallInfo.getIconPath());
            if (image != null) {
                Label iconLabel = this.createLabel(image, 2, 0);
                horizontalSpan = this.getColumns() - 3;
            } else {
                horizontalSpan = this.getColumns() - 1;
            }
        }
        Label titleLabel = this.createLabel(InstallerUiTexts.get("uninstall_query", new String[]{this.iUninstallInfo.getName()}), horizontalSpan, labelStyle);
        titleLabel.setFont(this.getBoldFont());
        boolean identified = this.iUninstallInfo.getCertificates() != null;
        Label securityIconLabel = this.createSecurityLabel(identified);
        horizontalSpan = this.getColumns();
        Label nameLabel = this.createLabel(InstallerUiTexts.get("app_details_name", new String[]{this.iUninstallInfo.getName()}), horizontalSpan, labelStyle);
        if (identified) {
            Label vendorLabel = this.createLabel(InstallerUiTexts.get("app_details_vendor", new String[]{this.iUninstallInfo.getVendor()}), horizontalSpan, labelStyle);
        }
        Label versionLabel = this.createLabel(InstallerUiTexts.get("app_details_version", new String[]{this.iUninstallInfo.getVersion()}), horizontalSpan, labelStyle);
        ApplicationInfo[] apps = this.iUninstallInfo.getApplications();
        if (!(apps == null || apps.length <= 0 || apps.length <= 1 && this.iUninstallInfo.getName().equals(apps[0].getName()))) {
            Label appsLabel = this.createLabel(InstallerUiTexts.get("app_details_apps_list"), horizontalSpan, labelStyle);
            for (int i = 0; i < apps.length; ++i) {
                Label appLabel = this.createLabel(InstallerUiTexts.get("application_name", new String[]{apps[i].getName()}), horizontalSpan, labelStyle);
            }
        }
        if ((deleteConfirm = this.iUninstallInfo.getDeleteConfirm()) != null) {
            Label deleteConfirmLabel = this.createLabel(deleteConfirm, horizontalSpan, labelStyle);
        }
    }

    protected void getDataFromView() {
    }

    protected int getStyle() {
        return 512;
    }
}

