/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.installer.ui.eswt;

import com.nokia.mj.impl.installer.ui.InstallerUiTexts;
import com.nokia.mj.impl.installer.ui.eswt.ConfirmationViewBase;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class UsernamePasswordView
extends ConfirmationViewBase {
    private Text iUsernameText = null;
    private Text iPasswordText = null;
    private String iUrl = null;
    private String iUsername = null;
    private String iPassword = null;
    private String iAppName = null;
    private Object iAppNameWaitObject = new Object();

    protected UsernamePasswordView() {
    }

    protected UsernamePasswordView(Composite aParent) {
        super(aParent, 1);
        this.setTitle(InstallerUiTexts.get("auth_query"));
        this.setCommands(InstallerUiTexts.get("ok"), InstallerUiTexts.get("cancel"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAppName(String aAppName) {
        Object object = this.iAppNameWaitObject;
        synchronized (object) {
            this.iAppName = aAppName;
            this.iAppNameWaitObject.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getUsernamePassword(String aUrl) {
        if (this.isDisposed()) {
            return null;
        }
        Object object = this.iAppNameWaitObject;
        synchronized (object) {
            if (this.iAppName == null) {
                try {
                    this.iAppNameWaitObject.wait();
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
        }
        this.iUrl = aUrl;
        boolean confirmation = this.confirm();
        String[] result = null;
        if (confirmation && this.iUsername != null && this.iPassword != null) {
            result = new String[]{this.iUsername, this.iPassword};
        }
        return result;
    }

    protected void createView() {
        int labelStyle = 64;
        Label titleLabel = this.createLabel(InstallerUiTexts.get("auth_query"), labelStyle);
        titleLabel.setFont(this.getBoldFont());
        Label urlLabel = this.createLabel(this.iUrl, labelStyle);
        Label authLabel = this.createLabel(InstallerUiTexts.get("auth_yourself", new String[]{this.iAppName}), labelStyle);
        Label usernameLabel = this.createLabel(InstallerUiTexts.get("auth_username"), labelStyle);
        this.iUsernameText = new Text(this.getComposite(), 0);
        this.iUsernameText.setLayoutData((Object)new GridData(768));
        Label passwordLabel = this.createLabel(InstallerUiTexts.get("auth_password"), labelStyle);
        this.iPasswordText = new Text(this.getComposite(), 0x400000);
        this.iPasswordText.setLayoutData((Object)new GridData(768));
    }

    protected void getDataFromView() {
        this.iUsername = this.iUsernameText.getText();
        this.iPassword = this.iPasswordText.getText();
    }

    protected int getStyle() {
        return 512;
    }
}

