/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.installer.ui.eswt;

import com.nokia.mj.impl.installer.ui.InstallerUi;
import com.nokia.mj.impl.installer.ui.eswt.InstallerUiEswt;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class ViewBase {
    protected static final int MAX_VIEW_HEIGHT = 80;
    protected static final int SCROLLBAR_WIDTH = 8;
    private Shell iParent = null;
    private ScrolledComposite iScrolledComposite = null;
    private Composite iComposite = null;
    private InstallerUi iInstallerUi = null;
    private Font iBoldFont = null;
    private boolean iOpened = false;
    private boolean iVisible = false;
    private int iColumns = 1;
    private Rectangle iDefaultShellBounds;
    private Point iDefaultContentSize;

    protected ViewBase() {
    }

    protected ViewBase(Composite aParent, int aColumns) {
        this.iParent = (Shell)aParent;
        this.iColumns = aColumns;
        this.iBoldFont = this.getBoldFont();
        this.iDefaultShellBounds = this.iParent.internal_getDefaultBounds();
        this.iParent.setLayout((Layout)new FillLayout(512));
        this.iScrolledComposite = new ScrolledComposite((Composite)this.iParent, this.getStyle());
        this.iScrolledComposite.setAlwaysShowScrollBars(true);
        this.iParent.layout(true);
        Rectangle rect = this.iScrolledComposite.getClientArea();
        this.iDefaultContentSize = new Point(rect.width, rect.height);
        this.iComposite = new Composite((Composite)this.iScrolledComposite, 0);
        this.iComposite.setLayout((Layout)new GridLayout(this.getColumns(), true));
        this.iScrolledComposite.setContent((Control)this.iComposite);
    }

    public InstallerUi getInstallerUi() {
        return this.iInstallerUi;
    }

    public void setInstallerUi(InstallerUi aInstallerUi) {
        this.iInstallerUi = aInstallerUi;
    }

    public Composite getComposite() {
        return this.iComposite;
    }

    public ScrolledComposite getScrolledComposite() {
        return this.iScrolledComposite;
    }

    public Shell getShell() {
        return this.iParent;
    }

    public Display getDisplay() {
        return this.getShell().getDisplay();
    }

    public String getTitle() {
        return this.iParent.getText();
    }

    public void setTitle(String aTitle) {
        this.iParent.setText(aTitle);
    }

    public void open() {
        this.iParent.getDisplay().asyncExec(new Runnable(){

            public void run() {
                ViewBase.this.updateSize();
                ViewBase.this.iParent.open();
                if (ViewBase.this.forceFocusToShell()) {
                    ViewBase.this.iParent.forceFocus();
                }
                ViewBase.this.iOpened = true;
                ViewBase.this.iVisible = true;
            }
        });
    }

    public boolean isOpened() {
        return this.iOpened;
    }

    public void dispose() {
        final String className = this.getClass().getName();
        this.log(className + ": disposing");
        this.iParent.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (ViewBase.this.iBoldFont != null && !ViewBase.this.iBoldFont.isDisposed()) {
                    ViewBase.this.log(className + ": disposing font");
                    ViewBase.this.iBoldFont.dispose();
                }
                ViewBase.this.log(className + ": disposing parent");
                ViewBase.this.iParent.dispose();
            }
        });
    }

    public boolean isDisposed() {
        return this.iParent.isDisposed();
    }

    public void setVisible(boolean aVisible) {
        this.iVisible = aVisible;
        this.iParent.getDisplay().asyncExec(new Runnable(){

            public void run() {
                ViewBase.this.getComposite().setVisible(ViewBase.this.iVisible);
                ViewBase.this.iParent.setVisible(ViewBase.this.iVisible);
            }
        });
    }

    public boolean isVisible() {
        return this.iVisible;
    }

    protected void updateSize() {
        Shell shell = this.getShell();
        Composite comp = this.getComposite();
        Point contentSize = comp.computeSize(this.iDefaultContentSize.x, -1);
        comp.setSize(contentSize);
        Rectangle dispRect = shell.getDisplay().getClientArea();
        int offset = this.iDefaultContentSize.y - contentSize.y;
        int newHeight = this.iDefaultShellBounds.height - offset;
        int maxHeight = dispRect.height * 80 / 100;
        if (newHeight > maxHeight) {
            offset -= maxHeight - newHeight;
            newHeight = maxHeight;
        }
        if (dispRect.width > dispRect.height) {
            offset /= 2;
        }
        shell.setBounds(this.iDefaultShellBounds.x, this.iDefaultShellBounds.y + offset, this.iDefaultShellBounds.width, newHeight);
        shell.layout(true);
    }

    protected void screenOrientationChanged() {
        this.iDefaultShellBounds = this.iParent.internal_getDefaultBounds();
        this.updateSize();
    }

    protected boolean forceFocusToShell() {
        return false;
    }

    protected Font getBoldFont() {
        if (this.iBoldFont == null) {
            FontData[] fontDatas = this.iParent.getFont().getFontData();
            FontData[] boldFontDatas = new FontData[fontDatas.length];
            for (int i = 0; i < boldFontDatas.length; ++i) {
                boldFontDatas[i] = new FontData(fontDatas[i].getName(), fontDatas[i].getHeight(), 1);
            }
            this.iBoldFont = new Font((Device)this.iParent.getDisplay(), boldFontDatas);
        }
        return this.iBoldFont;
    }

    protected int getStyle() {
        return 0;
    }

    protected int getColumns() {
        return this.iColumns;
    }

    protected Label createLabel(String aText, int aStyle) {
        return this.createLabel(aText, this.getColumns(), aStyle);
    }

    protected Label createLabel(String aText, int aColumns, int aStyle) {
        Label label = new Label(this.getComposite(), aStyle);
        label.setText(aText);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = aColumns;
        label.setLayoutData((Object)gridData);
        return label;
    }

    protected Label createLabel(Image aImage, int aStyle) {
        return this.createLabel(aImage, this.getColumns(), aStyle);
    }

    protected Label createLabel(Image aImage, int aColumns, int aStyle) {
        Label label = new Label(this.getComposite(), aStyle);
        label.setImage(aImage);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = aColumns;
        gridData.horizontalAlignment = 0x1000000;
        gridData.verticalAlignment = 128;
        label.setLayoutData((Object)gridData);
        return label;
    }

    protected Label createSecurityLabel(boolean aIdentified) {
        Label label = this.createLabel((Image)null, 1, 0);
        Image securityIcon = null;
        if (this.iInstallerUi instanceof InstallerUiEswt) {
            securityIcon = ((InstallerUiEswt)this.iInstallerUi).getSecurityIcon(this.getDisplay(), aIdentified);
        }
        if (securityIcon != null) {
            label.setImage(securityIcon);
        } else {
            label.setText(aIdentified ? "I" : "U");
        }
        return label;
    }

    protected void log(String aMsg) {
        if (this.iInstallerUi != null) {
            InstallerUi.log(aMsg);
        }
    }

    protected void logError(String aMsg, Throwable aThrowable) {
        if (this.iInstallerUi != null) {
            InstallerUi.logError(aMsg, aThrowable);
        }
    }
}

