/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.location;

import com.nokia.mj.impl.location.Blocker;
import com.nokia.mj.impl.location.LocationProviderImpl;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.location.LocationException;

public final class Positioner {
    boolean iCancelled = false;
    int iPositionerHandle = 0;
    private static final String GETLOCATION_ERROR_STRING = "Unable to obtain location";
    private static final Blocker iLock = new Blocker();
    private static final Vector iPositioners = new Vector();
    private final LocationProviderImpl iLocationProvider;

    private Positioner(LocationProviderImpl aLocationProvider) {
        this.iLocationProvider = aLocationProvider;
    }

    static Positioner getPositioner(LocationProviderImpl aLocationProvider) {
        Positioner pos = new Positioner(aLocationProvider);
        iPositioners.addElement(pos);
        return pos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void resetAll() {
        Vector vector = iPositioners;
        synchronized (vector) {
            Enumeration e = iPositioners.elements();
            while (e.hasMoreElements()) {
                Positioner p = (Positioner)e.nextElement();
                p.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getLocation(int aTimeoutSeconds) throws LocationException {
        if (this.iCancelled) {
            return -3;
        }
        int ret = 0;
        Blocker blocker = iLock;
        synchronized (blocker) {
            int functionSourceHandle = this.iLocationProvider.getFunctionSourceHandle();
            int providerHandle = this.iLocationProvider.getProviderHandle();
            if (this.iPositionerHandle == 0) {
                int handle = this._createPositioner(functionSourceHandle, providerHandle);
                if (handle < 0) {
                    throw new LocationException(GETLOCATION_ERROR_STRING);
                }
                this.iPositionerHandle = handle;
            }
            if ((ret = this._getLocation(functionSourceHandle, this.iPositionerHandle, aTimeoutSeconds)) == 0) {
                try {
                    iLock.wait();
                    ret = iLock.getresult();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        if (ret < 0) {
            this.release();
        }
        return ret;
    }

    private void cancel() {
        this.iCancelled = true;
        this._cancel(this.iLocationProvider.getFunctionSourceHandle(), this.iPositionerHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncComplete(int aError) {
        Blocker blocker = iLock;
        synchronized (blocker) {
            iLock.setresult(aError);
            iLock.notify();
        }
    }

    void release() {
        if (iPositioners.removeElement(this) && this.iPositionerHandle > 0) {
            this._dispose(this.iLocationProvider.getFunctionSourceHandle(), this.iPositionerHandle);
            this.iPositionerHandle = 0;
        }
    }

    private native int _getLocation(int var1, int var2, int var3);

    private native int _createPositioner(int var1, int var2);

    private native void _cancel(int var1, int var2);

    private native void _dispose(int var1, int var2);
}

