/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.mms;

import com.nokia.mj.impl.utils.Logger;

public class MMSAddress {
    private static final char COLON = ':';
    private static final int MAX_MSISDN_LENGTH = 256;
    public static final boolean SERVER = true;
    public static final boolean CLIENT = false;
    public static final String MMS_PREFIX = "mms://";
    public static final int MAX_APP_ID_LENGTH = 32;

    public static void validateUrl(String url) throws IllegalArgumentException {
        String address;
        Logger.LOG(15, 4, "+ MMSAddress::validateUrl()");
        if (url != null && url.startsWith(MMS_PREFIX) && (address = url.substring(MMS_PREFIX.length())).length() > 0 && MMSAddress.validateAddress(address)) {
            int at;
            String deviceAddress;
            if (MMSAddress.validateIPv4(address)) {
                throw new IllegalArgumentException("Address typeIPv4 Not supported");
            }
            if (MMSAddress.validateIPv6(address)) {
                throw new IllegalArgumentException("Address typeIPv6 Not supported");
            }
            if (MMSAddress.validateShortcode(address)) {
                // empty if block
            }
            if ((deviceAddress = MMSAddress.getDeviceAddress(url)) != null && (at = MMSAddress.indexOfClear(deviceAddress, '@')) == -1 && deviceAddress.length() > 256) {
                throw new IllegalArgumentException("The device address's length exceeds the  maximum supported size ");
            }
            Logger.LOG(15, 4, "- MMSAddress::validateUrl()");
            return;
        }
        throw new IllegalArgumentException("Invalid URL: " + url);
    }

    private static boolean validateAppIdSegment(String appIdSeg) {
        Logger.LOG(15, 4, "+ MMSAddress::validateAppIdSegment()");
        boolean res = true;
        for (int a = 0; a < appIdSeg.length(); ++a) {
            char c = appIdSeg.charAt(a);
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '.' || c == '_') continue;
            res = false;
            break;
        }
        Logger.LOG(15, 4, "- MMSAddress::validateAppIdSegment()");
        return res;
    }

    public static boolean validateAppId(String appId) {
        boolean res = true;
        if (appId == null || appId.length() > 31) {
            return false;
        }
        if (!MMSAddress.validateAppIdSegment(appId)) {
            res = false;
        }
        return res;
    }

    private static boolean validateQuotedStr(String quotedStr) {
        Logger.LOG(15, 4, "+ MMSAddress::validateQuotedStr()");
        boolean res = true;
        for (int a = 0; a < quotedStr.length(); ++a) {
            char ch = quotedStr.charAt(a);
            if (ch > '\u00b1' || ch == '\"' || ch < '\u0000' || ch == '\r') {
                res = false;
                break;
            }
            if (ch != '\\') continue;
            try {
                char next = quotedStr.charAt(a + 1);
                if (next > 'A' && next < 'Z' && (next <= 'a' || next >= 'z')) continue;
                res = false;
                break;
            }
            catch (IndexOutOfBoundsException e) {
                res = false;
            }
        }
        Logger.LOG(15, 4, "- MMSAddress::validateQuotedStr()");
        return res;
    }

    private static boolean validateAtom(String atom) {
        Logger.LOG(15, 4, "+ MMSAddress::validateAtom()");
        boolean res = true;
        for (int a = 0; a < atom.length(); ++a) {
            char ch = atom.charAt(a);
            if (ch != '(' && ch != ')' && ch != '<' && ch != '>' && ch != '@' && ch != ',' && ch != ';' && ch != ':' && ch != '\\' && ch != '\"' && ch != '.' && ch != '[' && ch != ']' && ch != ' ') continue;
            res = false;
            break;
        }
        Logger.LOG(15, 4, "- MMSAddress::validateAtom()");
        return res;
    }

    private static boolean validateWord(String word) {
        boolean res = true;
        if (word.charAt(0) == '\"') {
            int nextQuote = word.indexOf(34, 1);
            if (nextQuote == -1 || nextQuote != word.length() - 1) {
                return false;
            }
            res = MMSAddress.validateQuotedStr(word.substring(1, nextQuote));
        } else {
            res = MMSAddress.validateAtom(word);
        }
        return res;
    }

    private static boolean validateLocalPart(String localPart) {
        Logger.LOG(15, 4, "+ MMSAddress::validateLocalPart()");
        boolean res = true;
        int dot = MMSAddress.indexOfClear(localPart, '.');
        int pos = 0;
        boolean finished = false;
        while (!finished) {
            if (dot == -1) {
                res = MMSAddress.validateWord(localPart.substring(pos));
                finished = true;
                continue;
            }
            String word = localPart.substring(pos, dot);
            if (!MMSAddress.validateWord(word)) {
                res = false;
                break;
            }
            dot = MMSAddress.indexOfClear(localPart.substring(pos += word.length() + 1), '.');
        }
        Logger.LOG(15, 4, "- MMSAddress::validateLocalPart()");
        return res;
    }

    private static boolean validateSubdomain(String subdomain) {
        boolean res = true;
        if (subdomain.length() == 0) {
            res = false;
        } else if (subdomain.charAt(0) == '[') {
            if (subdomain.charAt(subdomain.length() - 1) != ']') {
                return false;
            }
            String inner = subdomain.substring(1, subdomain.length() - 1);
            for (int a = 0; a < inner.length(); ++a) {
                char ch = inner.charAt(a);
                if (ch != '[' && ch != ']' && ch != '\\' && ch != '\"' && ch != '\r') continue;
                return false;
            }
        } else {
            res = MMSAddress.validateAtom(subdomain);
        }
        return res;
    }

    private static int indexOfClear(String str, char ch) {
        Logger.LOG(15, 4, "+ MMSAddress::indexOfClear()");
        int res = -1;
        boolean finished = false;
        boolean inQuotes = false;
        boolean inSquareBrackets = false;
        boolean inAngleBrackets = false;
        int squareBracketsLevel = 0;
        int angleBracketsLevel = 0;
        int pos = 0;
        if (str.length() == 0) {
            return res;
        }
        while (!finished) {
            char current = str.charAt(pos);
            if (!(current != ch || inQuotes || inSquareBrackets || inAngleBrackets)) {
                res = pos;
                finished = true;
            } else if (current == '[') {
                if (!inQuotes && !inAngleBrackets) {
                    inSquareBrackets = true;
                    ++squareBracketsLevel;
                }
            } else if (current == ']') {
                if (!inQuotes && !inAngleBrackets && inSquareBrackets && --squareBracketsLevel == 0) {
                    inSquareBrackets = false;
                }
            } else if (current == '<') {
                if (!inQuotes && !inSquareBrackets) {
                    inAngleBrackets = true;
                    ++angleBracketsLevel;
                }
            } else if (current == '>') {
                if (!inQuotes && !inSquareBrackets && inAngleBrackets && --angleBracketsLevel == 0) {
                    inAngleBrackets = false;
                }
            } else if (current == '\"' && !inSquareBrackets && !inAngleBrackets) {
                boolean bl = inQuotes = !inQuotes;
            }
            if (++pos != str.length()) continue;
            finished = true;
        }
        Logger.LOG(15, 4, "- MMSAddress::indexOfClear()");
        return res;
    }

    private static boolean validateDomain(String domain) {
        String subdomain;
        Logger.LOG(15, 4, "+ MMSAddress::validateDomain()");
        boolean res = true;
        int dot = domain.indexOf(46);
        int pos = 0;
        while ((dot = MMSAddress.indexOfClear(domain.substring(pos), '.')) != -1) {
            subdomain = domain.substring(pos, dot + pos);
            res = MMSAddress.validateSubdomain(subdomain);
            if (!res) {
                return false;
            }
            pos += subdomain.length() + 1;
        }
        subdomain = domain.substring(pos);
        res = MMSAddress.validateSubdomain(subdomain);
        Logger.LOG(15, 4, "- MMSAddress::validateDomain()");
        return res;
    }

    private static boolean validateAddrSpec(String addrSpec) {
        Logger.LOG(15, 4, "+ MMSAddress::validateAddrSpec()");
        boolean res = true;
        int at = addrSpec.indexOf(64);
        res = MMSAddress.validateLocalPart(addrSpec.substring(0, at));
        if (res) {
            res = MMSAddress.validateDomain(addrSpec.substring(at + 1));
        }
        Logger.LOG(15, 4, "- MMSAddress::validateAddrSpec()");
        return res;
    }

    private static boolean validateRoute(String route) {
        String domain;
        int comma;
        boolean res = true;
        int pos = 0;
        while ((comma = MMSAddress.indexOfClear(route.substring(pos), ',')) != -1) {
            if (route.charAt(comma + 1) != '@') {
                return false;
            }
            domain = route.substring(pos, pos + comma);
            if (!MMSAddress.validateDomain(domain)) {
                return false;
            }
            pos += domain.length() + 1;
        }
        if (route.charAt(pos) != '@') {
            return false;
        }
        domain = route.substring(pos + 1, route.length() - 1);
        res = MMSAddress.validateDomain(domain);
        return res;
    }

    private static boolean validateMailbox(String mailbox) {
        Logger.LOG(15, 4, "+ MMSAddress::validateMailbox()");
        boolean res = true;
        int pos = 0;
        int lt = MMSAddress.indexOfClear(mailbox, '<');
        if (lt != -1) {
            if (mailbox.charAt(mailbox.length() - 1) != '>') {
                return false;
            }
            if (lt > 0) {
                res = MMSAddress.validateWord(mailbox.substring(0, lt));
            }
            if (res) {
                String routeAddr = mailbox.substring(lt + 1, mailbox.length() - 1);
                if (routeAddr.charAt(0) == '@') {
                    int colonIx = MMSAddress.indexOfClear(routeAddr, ':');
                    String route = routeAddr.substring(1, colonIx + 1);
                    res = MMSAddress.validateRoute(route);
                    pos += route.length() + 1;
                }
                if (res) {
                    res = MMSAddress.validateAddrSpec(routeAddr.substring(pos));
                }
            }
        } else {
            res = MMSAddress.validateAddrSpec(mailbox);
        }
        Logger.LOG(15, 4, "- MMSAddress::validateMailbox()");
        return res;
    }

    private static boolean validateEmail(String email) {
        Logger.LOG(15, 4, "+ MMSAddress::validateEmail()");
        boolean res = true;
        if (email.charAt(email.length() - 1) == ';') {
            int colonIx = MMSAddress.indexOfClear(email, ':');
            if (colonIx != -1) {
                res = MMSAddress.validateWord(email.substring(0, colonIx));
                if (res && email.charAt(colonIx + 1) != ';') {
                    String mailbox;
                    int comma;
                    int pos = colonIx + 1;
                    while ((comma = MMSAddress.indexOfClear(email.substring(pos), ',')) != -1) {
                        mailbox = email.substring(pos, pos + comma);
                        if (!MMSAddress.validateMailbox(mailbox)) {
                            return false;
                        }
                        pos += mailbox.length() + 1;
                    }
                    mailbox = email.substring(pos, email.length() - 1);
                    res = MMSAddress.validateMailbox(mailbox);
                    if (email.charAt(pos += mailbox.length()) != ';') {
                        res = false;
                    }
                }
            } else {
                res = false;
            }
        } else {
            res = MMSAddress.validateMailbox(email);
        }
        Logger.LOG(15, 4, "- MMSAddress::validateEmail()");
        return res;
    }

    private static boolean validateIPv4(String ipv4) {
        String num;
        Logger.LOG(15, 4, "+ MMSAddress::validateIPv4()");
        boolean res = true;
        int pos = 0;
        int val = 0;
        for (int a = 0; a < 3; ++a) {
            block9: {
                int dot = ipv4.indexOf(46, pos);
                if (dot == -1) {
                    res = false;
                    break;
                }
                num = ipv4.substring(pos, dot);
                try {
                    val = Integer.parseInt(num);
                    if (val < 0 || val > 999) {
                        res = false;
                    }
                    break block9;
                }
                catch (NumberFormatException nfe) {
                    res = false;
                }
                break;
            }
            pos += num.length() + 1;
        }
        if (res) {
            num = ipv4.substring(pos);
            try {
                val = Integer.parseInt(num);
                if (val < 0 || val > 999) {
                    res = false;
                }
            }
            catch (NumberFormatException nfe) {
                res = false;
            }
        }
        Logger.LOG(15, 4, "- MMSAddress::validateIPv4()");
        return res;
    }

    private static boolean validateIPv6Atom(String ipv6Atom) {
        Logger.LOG(15, 4, "+ MMSAddress::validateIPv6Atom()");
        boolean res = true;
        int len = ipv6Atom.length();
        if (len >= 1 && len <= 4) {
            for (int a = 0; a < len; ++a) {
                char ch = ipv6Atom.charAt(a);
                if (ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'F') continue;
                res = false;
                break;
            }
        } else {
            res = false;
        }
        Logger.LOG(15, 4, "- MMSAddress::validateIPv6Atom()");
        return res;
    }

    private static boolean validateIPv6(String ipv6) {
        String ipv6Atom;
        Logger.LOG(15, 4, "+ MMSAddress::validateIPv6()");
        boolean res = true;
        int pos = 0;
        int colonIx = 0;
        for (int a = 0; a < 7; ++a) {
            colonIx = ipv6.indexOf(58, pos);
            if (colonIx == -1) {
                res = false;
                break;
            }
            ipv6Atom = ipv6.substring(pos, colonIx);
            if (!MMSAddress.validateIPv6Atom(ipv6Atom)) {
                res = false;
                break;
            }
            pos += ipv6Atom.length() + 1;
        }
        if (res && !MMSAddress.validateIPv6Atom(ipv6Atom = ipv6.substring(pos))) {
            res = false;
        }
        Logger.LOG(15, 4, "- MMSAddress::validateIPv6()");
        return res;
    }

    private static boolean validateShortcode(String shortcode) {
        Logger.LOG(15, 4, "+ MMSAddress::validateShortcode()");
        boolean res = true;
        for (int a = 0; a < shortcode.length(); ++a) {
            char ch = shortcode.charAt(a);
            if (ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9') continue;
            res = false;
            break;
        }
        Logger.LOG(15, 4, "- MMSAddress::validateShortcode()");
        return res;
    }

    private static int countChar(String str, char ch) {
        int count = 0;
        for (int a = 0; a < str.length(); ++a) {
            if (str.charAt(a) != ch) continue;
            ++count;
        }
        return count;
    }

    private static boolean validateAddress(String addr) {
        Logger.LOG(15, 4, "+ MMSAddress::validateAddress()");
        boolean res = true;
        boolean appIdPresent = false;
        int colonIx = addr.lastIndexOf(58);
        if (colonIx != -1) {
            appIdPresent = MMSAddress.validateAppId(addr.substring(colonIx + 1));
            if (MMSAddress.countChar(addr, ':') == 7 && MMSAddress.validateIPv6(addr)) {
                return true;
            }
        }
        if (colonIx == 0) {
            return appIdPresent;
        }
        String theAddr = appIdPresent ? addr.substring(0, colonIx) : addr;
        int at = MMSAddress.indexOfClear(addr, '@');
        if (addr.charAt(0) == '+') {
            try {
                long num = Long.parseLong(theAddr.substring(1));
                if (num >= 0L) {
                    return true;
                }
            }
            catch (NumberFormatException nfe) {}
        } else {
            try {
                long num = Long.parseLong(theAddr);
                if (num >= 0L) {
                    return true;
                }
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if (at != -1) {
            if (!appIdPresent || at <= colonIx) {
                res = MMSAddress.validateEmail(theAddr);
                if (res && appIdPresent) {
                    res = false;
                }
            } else {
                res = false;
            }
        } else {
            int colons = MMSAddress.countChar(theAddr, ':');
            int dots = MMSAddress.countChar(theAddr, '.');
            if (dots == 3) {
                res = MMSAddress.validateIPv4(theAddr);
                if (res && appIdPresent) {
                    res = false;
                }
            } else if (colons == 7) {
                res = MMSAddress.validateIPv6(theAddr);
                if (res && appIdPresent) {
                    res = false;
                }
            } else {
                res = MMSAddress.validateShortcode(theAddr);
                if (res && appIdPresent) {
                    res = false;
                }
            }
        }
        Logger.LOG(15, 4, "- MMSAddress::validateAddress()");
        return res;
    }

    public static boolean validateUrl(String url, boolean checkProtocol) {
        Logger.LOG(15, 4, "+ MMSAddress::validateUrl()");
        boolean res = true;
        if (url == null) {
            return false;
        }
        String str = checkProtocol ? MMS_PREFIX : "//";
        res = url.startsWith(str) ? MMSAddress.validateAddress(url.substring(str.length())) : false;
        Logger.LOG(15, 4, "- MMSAddress::validateUrl()");
        return res;
    }

    public static String getAppIdFromAddress(String address) {
        int colonIx;
        Logger.LOG(15, 4, "+ MMSAddress::getAppIdFromAddress()");
        String tmpAppID = null;
        if (address != null && !MMSAddress.validateIPv6(address) && (colonIx = address.lastIndexOf(58)) != -1 && colonIx != address.length() - 1 && !MMSAddress.validateAppId(tmpAppID = address.substring(colonIx + 1))) {
            tmpAppID = null;
        }
        Logger.LOG(15, 4, "- MMSAddress::getAppIdFromAddress()");
        return tmpAppID;
    }

    public static String getAppIdFromUrl(String url) {
        return MMSAddress.getAppIdFromAddress(url);
    }

    public static String getAddressFromUrl(String url) {
        String res = null;
        if (url != null && url.startsWith("//")) {
            res = url.substring(2);
        }
        return res;
    }

    public static boolean getConnectionMode(String url) {
        boolean res = false;
        if (url != null && url.startsWith("//:")) {
            res = true;
        }
        return res;
    }

    public static String getDeviceAddress(String address) {
        Logger.LOG(15, 4, "+ MMSAddress::getDeviceAddress()");
        String devAddr = null;
        String tmpAddress = address;
        if (address != null) {
            String tmpAppId;
            if (!tmpAddress.startsWith(MMS_PREFIX)) {
                return null;
            }
            tmpAddress = tmpAddress.substring(MMS_PREFIX.length());
            if (MMSAddress.getConnectionMode(address)) {
                return null;
            }
            if (MMSAddress.validateIPv6(tmpAddress)) {
                return tmpAddress;
            }
            int colonIx = tmpAddress.lastIndexOf(58);
            devAddr = colonIx != -1 && colonIx != tmpAddress.length() - 1 ? (MMSAddress.validateAppId(tmpAppId = tmpAddress.substring(colonIx + 1)) ? tmpAddress.substring(0, colonIx) : tmpAddress) : tmpAddress;
        }
        Logger.LOG(15, 4, "- MMSAddress::getDeviceAddress()");
        return devAddr;
    }

    public static boolean isPhoneNumber(String addr) {
        long phone = -1L;
        try {
            phone = addr.startsWith("+") ? Long.parseLong(addr.substring(1)) : Long.parseLong(addr);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        catch (NullPointerException npe) {
            return false;
        }
        return phone >= 0L;
    }
}

