/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.mms;

import com.nokia.mj.impl.mms.MessagePartImpl;
import com.nokia.mj.impl.utils.Logger;
import java.util.Vector;
import javax.wireless.messaging.MessagePart;
import javax.wireless.messaging.SizeExceededException;

final class MultipartMessageBody {
    Vector iMessageParts = new Vector();
    boolean iStartContentId = false;
    boolean iValidationOn = true;
    int iMessageLength = 0;
    private int iMaxMMSSize;

    MultipartMessageBody(int aMaxMMSSize, boolean aValidationOn) {
        this.iMaxMMSSize = aMaxMMSSize;
        this.iValidationOn = aValidationOn;
    }

    void addMessagePart(MessagePart aPart) throws SizeExceededException {
        Logger.LOG(15, 4, "+ MultipartMessageBody::addMessagePart()");
        if (aPart == null) {
            throw new NullPointerException("Trying to add a message part that is null");
        }
        if (this.iMessageParts.contains(aPart)) {
            throw new IllegalArgumentException("Message already contains MessagePart with same ID: " + aPart.getContentID());
        }
        if (this.iMessageLength + aPart.getLength() > this.iMaxMMSSize) {
            throw new SizeExceededException("Cannot add message: maximum size exceeded");
        }
        this.iMessageParts.addElement(aPart);
        this.iMessageLength += aPart.getLength();
        Logger.LOG(15, 4, "- MultipartMessageBody::addMessagePart()");
    }

    boolean removeMessagePartId(String aContentID) {
        Logger.LOG(15, 4, "+ MultipartMessageBody::removeMessagePartId()");
        if (aContentID == null) {
            throw new NullPointerException("Content-id is null");
        }
        int index = this.iMessageParts.indexOf(MessagePartImpl.getInstance(aContentID));
        if (index >= 0) {
            if (index == 0) {
                this.iStartContentId = false;
            }
            MessagePart part = (MessagePart)this.iMessageParts.elementAt(index);
            this.iMessageParts.removeElementAt(index);
            this.iMessageLength -= part.getLength();
            Logger.LOG(15, 4, "- MultipartMessageBody::removeMessagePartId()");
            return true;
        }
        Logger.LOG(15, 4, "- MultipartMessageBody::removeMessagePartId()");
        return false;
    }

    boolean removeMessagePart(MessagePart aPart) {
        if (aPart == null) {
            throw new NullPointerException("Null message part");
        }
        return this.removeMessagePartId(aPart.getContentID());
    }

    boolean removeMessagePartLocation(String aContentLocation) {
        Logger.LOG(15, 4, "+ MultipartMessageBody::removeMessagePartLocation()");
        boolean ret = false;
        if (aContentLocation == null) {
            throw new NullPointerException("Content location is null");
        }
        int counter = 0;
        while (counter < this.iMessageParts.size()) {
            MessagePart msgPart = (MessagePart)this.iMessageParts.elementAt(counter);
            if (msgPart.getContentLocation().equals(aContentLocation)) {
                if (counter == 0) {
                    this.iStartContentId = false;
                }
                this.iMessageParts.removeElement(msgPart);
                this.iMessageLength -= msgPart.getLength();
                ret = true;
                continue;
            }
            ++counter;
        }
        Logger.LOG(15, 4, "- MultipartMessageBody::removeMessagePartLocation()");
        return ret;
    }

    MessagePart getMessagePart(String aContentId) {
        Logger.LOG(15, 4, "+ MultipartMessageBody::getMessagePart()");
        if (aContentId == null) {
            throw new NullPointerException("Content-id is null");
        }
        int index = this.iMessageParts.indexOf(MessagePartImpl.getInstance(aContentId));
        if (index >= 0) {
            Logger.LOG(15, 4, "- MultipartMessageBody::getMessagePart()");
            return (MessagePart)this.iMessageParts.elementAt(index);
        }
        Logger.LOG(15, 4, "- MultipartMessageBody::getMessagePart()");
        return null;
    }

    String getStartContentId() {
        MessagePart first;
        Logger.LOG(15, 4, "+ MultipartMessageBody::getStartContentId()");
        if (this.iStartContentId && this.iMessageParts.size() > 0 && (first = (MessagePart)this.iMessageParts.elementAt(0)) != null) {
            Logger.LOG(15, 4, "- MultipartMessageBody::getStartContentId()");
            return first.getContentID();
        }
        Logger.LOG(15, 4, "- MultipartMessageBody::getStartContentId()");
        return null;
    }

    void setStartContentId(String aContentId) {
        Logger.LOG(15, 4, "+ MultipartMessageBody::setStartContentId()");
        if (aContentId == null) {
            this.iStartContentId = false;
            return;
        }
        int index = this.iMessageParts.indexOf(MessagePartImpl.getInstance(aContentId));
        if (index >= 0) {
            this.iStartContentId = true;
            if (index == 0) {
                return;
            }
            MessagePart first = (MessagePart)this.iMessageParts.elementAt(index);
            this.iMessageParts.removeElementAt(index);
            this.iMessageParts.insertElementAt(first, 0);
            return;
        }
        if (this.iValidationOn) {
            throw new IllegalArgumentException("No MessagePart with the content identifier  " + aContentId + " has been found");
        }
        Logger.LOG(15, 4, "- MultipartMessageBody::setStartContentId()");
    }

    MessagePart[] getMessageParts() {
        Logger.LOG(15, 4, "+ MultipartMessageBody::getMessageParts()");
        int size = this.iMessageParts.size();
        if (size == 0) {
            return null;
        }
        MessagePart[] messagePartArray = new MessagePart[size];
        for (int i = 0; i < size; ++i) {
            messagePartArray[i] = (MessagePart)this.iMessageParts.elementAt(i);
        }
        Logger.LOG(15, 4, "- MultipartMessageBody::getMessageParts()");
        return messagePartArray;
    }

    public String toString() {
        return "MessageParts: " + this.iMessageParts.toString();
    }
}

