/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.mms;

import com.nokia.mj.impl.mms.MessagePartImpl;
import com.nokia.mj.impl.mms.MultipartMessageBody;
import com.nokia.mj.impl.mms.MultipartMessageHeader;
import com.nokia.mj.impl.utils.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Vector;
import javax.wireless.messaging.MessagePart;
import javax.wireless.messaging.MultipartMessage;
import javax.wireless.messaging.SizeExceededException;

final class MultipartMessageImpl
implements MultipartMessage {
    private MultipartMessageHeader iMessageHeader = null;
    private MultipartMessageBody iMessageBody = null;
    private static final int REPLY_TO_APPLICATION_ID = 0;
    private static final int APPLICATION_ID = 1;
    private static final int SUBJECT = 2;
    private static final int FROM = 3;
    private static final int TO = 4;
    private static final int BCC = 5;
    private static final int CC = 6;
    private long iTimestamp;
    boolean iReply = false;
    boolean iValidationDone = false;

    MultipartMessageImpl(String aAddress, long aTimestamp, int aMaxMMSSize) {
        this(aAddress, aTimestamp, aMaxMMSSize, true);
    }

    private MultipartMessageImpl(String aAddress, long aTimestamp, int aMaxMMSSize, boolean aValidationOn) {
        this.iTimestamp = aTimestamp;
        this.iMessageBody = new MultipartMessageBody(aMaxMMSSize, aValidationOn);
        this.iMessageHeader = new MultipartMessageHeader(aValidationOn);
        if (aAddress != null) {
            this.iMessageHeader.setAddress(aAddress);
        }
        this.iValidationDone = aValidationOn;
    }

    public void addMessagePart(MessagePart aPart) throws SizeExceededException {
        this.iMessageBody.addMessagePart(aPart);
    }

    public boolean removeMessagePartId(String aContentID) {
        return this.iMessageBody.removeMessagePartId(aContentID);
    }

    public boolean removeMessagePart(MessagePart aPart) {
        return this.iMessageBody.removeMessagePart(aPart);
    }

    public boolean removeMessagePartLocation(String aContentLocation) {
        return this.iMessageBody.removeMessagePartLocation(aContentLocation);
    }

    public MessagePart getMessagePart(String aContentID) {
        return this.iMessageBody.getMessagePart(aContentID);
    }

    public String getStartContentId() {
        return this.iMessageBody.getStartContentId();
    }

    public void setStartContentId(String aContentID) {
        this.iMessageBody.setStartContentId(aContentID);
    }

    public MessagePart[] getMessageParts() {
        return this.iMessageBody.getMessageParts();
    }

    public void setFrom(String afrom) {
        this.iMessageHeader.setFrom(afrom);
    }

    public String getSubject() {
        return this.iMessageHeader.iSubject;
    }

    public String getHeader(String aHeaderField) {
        return this.iMessageHeader.getHeader(aHeaderField);
    }

    public void setSubject(String aSubject) {
        this.iMessageHeader.iSubject = aSubject;
    }

    public void setHeader(String aHeaderField, String aHeaderValue) {
        this.iMessageHeader.setHeader(aHeaderField, aHeaderValue);
    }

    public boolean addAddress(String aType, String aAddress) {
        this.iReply = false;
        return this.iMessageHeader.addAddress(aType, aAddress);
    }

    public void removeAddresses() {
        this.iReply = false;
        this.iMessageHeader.removeAddresses();
    }

    public void removeAddresses(String aType) {
        this.iReply = false;
        this.iMessageHeader.removeAddresses(aType);
    }

    public boolean removeAddress(String aType, String aAddress) {
        this.iReply = false;
        return this.iMessageHeader.removeAddress(aType, aAddress);
    }

    public String[] getAddresses(String aType) {
        return this.iMessageHeader.getAddresses(aType);
    }

    public String getAddress() {
        return this.iMessageHeader.getAddress();
    }

    String getDestinationAddress() {
        return this.iMessageHeader.getDestinationAddress();
    }

    public void setAddress(String aAddress) {
        this.iReply = false;
        this.iMessageHeader.setAddress(aAddress);
    }

    public Date getTimestamp() {
        if (this.iTimestamp == 0L) {
            return null;
        }
        return new Date(this.iTimestamp);
    }

    void setTimestamp(long aTimestamp) {
        this.iTimestamp = aTimestamp;
    }

    String getAppID() {
        return this.iMessageHeader.iApplicationID;
    }

    String getReplyToAppID() {
        return this.iMessageHeader.iReplyToAppID;
    }

    void setReplyToAppID(String aReplyToAppID) {
        this.iMessageHeader.iReplyToAppID = aReplyToAppID;
    }

    byte[] serialize() throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream mmsMsg = new DataOutputStream(bout);
        int[] headersLengths = new int[7];
        Vector headers = new Vector();
        byte mmsMap = this.calculateMap(headersLengths, headers);
        if (mmsMap == 0) {
            throw new IllegalArgumentException("The message to be sent is null");
        }
        mmsMsg.writeByte(mmsMap);
        this.addHeaderLengths(mmsMsg, headersLengths);
        int parts = this.iMessageBody.iMessageParts.size();
        mmsMsg.writeByte(parts);
        this.addContentLengths(mmsMsg);
        if (parts > 0) {
            if (this.iMessageBody.iStartContentId) {
                mmsMsg.writeByte(1);
            } else {
                mmsMsg.writeByte(0);
            }
        }
        this.addHeaders(mmsMsg, headers);
        this.addContents(mmsMsg);
        mmsMsg.flush();
        return bout.toByteArray();
    }

    static MultipartMessageImpl deserialize(byte[] aMsg, int aMaxMMSSize) throws IOException {
        Logger.LOG(15, 4, "+ MultipartMessageImpl::deserialize()");
        ByteArrayInputStream bin = new ByteArrayInputStream(aMsg);
        DataInputStream msg = new DataInputStream(bin);
        MultipartMessageImpl mmsMsg = new MultipartMessageImpl(null, 0L, aMaxMMSSize, false);
        int[] headerLengths = new int[7];
        MultipartMessageImpl.resolveMap(msg, headerLengths);
        int contentsCount = msg.readByte();
        if (contentsCount < 0) {
            throw new IOException("Received message is invalid");
        }
        Vector MIMELengths = new Vector();
        Vector CIDLengths = new Vector();
        Vector LocationLengths = new Vector();
        Vector EncodingLengths = new Vector();
        Vector ContentLengths = new Vector();
        for (int k = 0; k < contentsCount; ++k) {
            MIMELengths.addElement(new Integer(msg.readInt()));
            CIDLengths.addElement(new Integer(msg.readInt()));
            LocationLengths.addElement(new Integer(msg.readInt()));
            EncodingLengths.addElement(new Integer(msg.readInt()));
            ContentLengths.addElement(new Integer(msg.readInt()));
        }
        byte sCID = 0;
        if (contentsCount > 0) {
            sCID = msg.readByte();
        }
        MultipartMessageImpl.resolveHeaders(msg, headerLengths, mmsMsg);
        for (int k = 0; k < contentsCount; ++k) {
            byte[] MIME = new byte[((Integer)MIMELengths.elementAt(k)).intValue()];
            msg.readFully(MIME);
            byte[] CID = new byte[((Integer)CIDLengths.elementAt(k)).intValue()];
            msg.readFully(CID);
            byte[] Location2 = new byte[((Integer)LocationLengths.elementAt(k)).intValue()];
            msg.readFully(Location2);
            byte[] Encoding = new byte[((Integer)EncodingLengths.elementAt(k)).intValue()];
            msg.readFully(Encoding);
            byte[] content = new byte[((Integer)ContentLengths.elementAt(k)).intValue()];
            msg.readFully(content);
            MessagePart part = MessagePartImpl.initializeMessagePart(content, MIME != null && MIME.length > 0 ? new String(MIME) : null, CID != null && CID.length > 0 ? new String(CID) : null, Location2 != null && Location2.length > 0 ? new String(Location2) : null, Encoding != null && Encoding.length > 0 ? new String(Encoding) : null);
            mmsMsg.iMessageBody.iMessageParts.addElement(part);
            mmsMsg.iMessageBody.iMessageLength += part.getLength();
            if (k != 0 || sCID != 1) continue;
            mmsMsg.setStartContentId(new String(CID));
        }
        mmsMsg.iReply = true;
        mmsMsg.iMessageHeader.iValidationOn = true;
        mmsMsg.iMessageBody.iValidationOn = true;
        mmsMsg.iValidationDone = false;
        Logger.LOG(15, 4, "- MultipartMessageImpl::deserialize()");
        return mmsMsg;
    }

    int getNumberOfRecipients() {
        return this.iMessageHeader.getNumberOfRecipients();
    }

    private byte calculateMap(int[] aHeadersLengths, Vector aHeaders) {
        String str;
        Logger.LOG(15, 4, "+ MultipartMessageImpl::calculateMap()");
        byte mmsMap = 0;
        if (this.validField(this.iMessageHeader.iReplyToAppID)) {
            aHeadersLengths[0] = this.iMessageHeader.iReplyToAppID.length();
            aHeaders.addElement(this.iMessageHeader.iReplyToAppID);
            mmsMap = (byte)(mmsMap + 64);
        }
        if (this.validField(this.iMessageHeader.iApplicationID)) {
            aHeadersLengths[1] = this.iMessageHeader.iApplicationID.length();
            aHeaders.addElement(this.iMessageHeader.iApplicationID);
            mmsMap = (byte)(mmsMap + 32);
        }
        if (this.validField(this.iMessageHeader.iSubject)) {
            aHeadersLengths[2] = this.iMessageHeader.iSubject.length();
            aHeaders.addElement(this.iMessageHeader.iSubject);
            mmsMap = (byte)(mmsMap + 16);
        }
        if (this.validField(this.iMessageHeader.iFrom)) {
            aHeadersLengths[3] = this.iMessageHeader.iFrom.length();
            aHeaders.addElement(this.iMessageHeader.iFrom);
            mmsMap = (byte)(mmsMap + 8);
        }
        if (this.validField(str = this.iMessageHeader.convertAddresses(0, this.iMessageHeader.iToAddresses))) {
            aHeadersLengths[4] = str.length();
            aHeaders.addElement(str);
            mmsMap = (byte)(mmsMap + 4);
        }
        if (this.validField(str = this.iMessageHeader.convertAddresses(1, this.iMessageHeader.iBccAddresses))) {
            aHeadersLengths[5] = str.length();
            aHeaders.addElement(str);
            mmsMap = (byte)(mmsMap + 2);
        }
        if (this.validField(str = this.iMessageHeader.convertAddresses(2, this.iMessageHeader.iCcAddresses))) {
            aHeadersLengths[6] = str.length();
            aHeaders.addElement(str);
            mmsMap = (byte)(mmsMap + 1);
        }
        Logger.LOG(15, 4, "- MultipartMessageImpl::calculateMap()");
        return mmsMap;
    }

    private void addHeaderLengths(DataOutputStream aMmsMsg, int[] aHeadersLengths) throws IOException {
        Logger.LOG(15, 4, "+ MultipartMessageImpl::addHeaderLengths()");
        for (int i = 0; i < aHeadersLengths.length; ++i) {
            if (aHeadersLengths[i] <= 0) continue;
            aMmsMsg.writeInt(aHeadersLengths[i]);
        }
        Logger.LOG(15, 4, "- MultipartMessageImpl::addHeaderLengths()");
    }

    private void addContentLengths(DataOutputStream aMmsMsg) throws IOException {
        Logger.LOG(15, 4, "+ MultipartMessageImpl::addContentLengths()");
        for (int j = 0; j < this.iMessageBody.iMessageParts.size(); ++j) {
            aMmsMsg.writeInt(((MessagePart)this.iMessageBody.iMessageParts.elementAt(j)).getMIMEType().length());
            aMmsMsg.writeInt(((MessagePart)this.iMessageBody.iMessageParts.elementAt(j)).getContentID().length());
            String aux = ((MessagePart)this.iMessageBody.iMessageParts.elementAt(j)).getContentLocation();
            if (aux != null) {
                aMmsMsg.writeInt(aux.length());
            } else {
                aMmsMsg.writeInt(0);
            }
            aux = ((MessagePart)this.iMessageBody.iMessageParts.elementAt(j)).getEncoding();
            if (aux != null) {
                aMmsMsg.writeInt(aux.length());
            } else {
                aMmsMsg.writeInt(0);
            }
            aMmsMsg.writeInt(((MessagePart)this.iMessageBody.iMessageParts.elementAt(j)).getLength());
        }
        Logger.LOG(15, 4, "- MultipartMessageImpl::addContentLengths()");
    }

    private void addHeaders(DataOutputStream aMmsMsg, Vector aHeaders) throws IOException {
        Logger.LOG(15, 4, "+ MultipartMessageImpl::addHeaders()");
        String priority = this.iMessageHeader.getHeader("x-mms-priority");
        if (priority == null) {
            aMmsMsg.writeByte(2);
        } else if (priority.equalsIgnoreCase("low")) {
            aMmsMsg.writeByte(1);
        } else if (priority.equalsIgnoreCase("high")) {
            aMmsMsg.writeByte(3);
        } else {
            aMmsMsg.writeByte(2);
        }
        long date = 0L;
        String dateString = this.iMessageHeader.getHeader("x-mms-delivery-time");
        if (dateString != null) {
            try {
                date = Long.parseLong(dateString);
            }
            catch (Exception e) {
                Logger.ELOG(15, "invalid date (" + dateString + "): " + e);
            }
        }
        aMmsMsg.writeLong(date);
        for (int j = 0; j < aHeaders.size(); ++j) {
            byte[] header = ((String)aHeaders.elementAt(j)).getBytes();
            aMmsMsg.write(header, 0, header.length);
        }
        Logger.LOG(15, 4, "- MultipartMessageImpl::addHeaders()");
    }

    private void addContents(DataOutputStream aMmsMsg) throws IOException {
        Logger.LOG(15, 4, "+ MultipartMessageImpl::addContents()");
        for (int j = 0; j < this.iMessageBody.iMessageParts.size(); ++j) {
            byte[] prop = ((MessagePart)this.iMessageBody.iMessageParts.elementAt(j)).getMIMEType().getBytes();
            aMmsMsg.write(prop, 0, prop.length);
            prop = ((MessagePart)this.iMessageBody.iMessageParts.elementAt(j)).getContentID().getBytes();
            aMmsMsg.write(prop, 0, prop.length);
            String aux = ((MessagePart)this.iMessageBody.iMessageParts.elementAt(j)).getContentLocation();
            if (aux != null) {
                prop = aux.getBytes();
                aMmsMsg.write(prop, 0, prop.length);
            }
            if ((aux = ((MessagePart)this.iMessageBody.iMessageParts.elementAt(j)).getEncoding()) != null) {
                prop = aux.getBytes();
                aMmsMsg.write(prop, 0, prop.length);
            }
            if ((prop = ((MessagePart)this.iMessageBody.iMessageParts.elementAt(j)).getContent()) == null) {
                prop = new byte[]{};
            }
            aMmsMsg.write(prop, 0, prop.length);
        }
        Logger.LOG(15, 4, "- MultipartMessageImpl::addContents()");
    }

    private static void resolveMap(DataInputStream aMsg, int[] aHeaderLengths) throws IOException {
        Logger.LOG(15, 4, "+ MultipartMessageImpl::resolveMap()");
        byte mmsMsg = aMsg.readByte();
        if (mmsMsg > 127 || mmsMsg <= 0) {
            throw new IOException("Received message is invalid");
        }
        byte div = MultipartMessageImpl.divide(mmsMsg, 64);
        if (div >= 0) {
            aHeaderLengths[0] = aMsg.readInt();
            if (div == 0) {
                return;
            }
            mmsMsg = div;
        }
        if ((div = MultipartMessageImpl.divide(mmsMsg, 32)) >= 0) {
            aHeaderLengths[1] = aMsg.readInt();
            if (div == 0) {
                return;
            }
            mmsMsg = div;
        }
        if ((div = MultipartMessageImpl.divide(mmsMsg, 16)) >= 0) {
            aHeaderLengths[2] = aMsg.readInt();
            if (div == 0) {
                return;
            }
            mmsMsg = div;
        }
        if ((div = MultipartMessageImpl.divide(mmsMsg, 8)) >= 0) {
            aHeaderLengths[3] = aMsg.readInt();
            if (div == 0) {
                return;
            }
            mmsMsg = div;
        }
        if ((div = MultipartMessageImpl.divide(mmsMsg, 4)) >= 0) {
            aHeaderLengths[4] = aMsg.readInt();
            if (div == 0) {
                return;
            }
            mmsMsg = div;
        }
        if ((div = MultipartMessageImpl.divide(mmsMsg, 2)) >= 0) {
            aHeaderLengths[5] = aMsg.readInt();
            if (div == 0) {
                return;
            }
            mmsMsg = div;
        }
        if (div == 1) {
            aHeaderLengths[6] = aMsg.readInt();
        }
        Logger.LOG(15, 4, "- MultipartMessageImpl::resolveMap()");
    }

    private static void resolveHeaders(DataInputStream aMsg, int[] aHeaderLengths, MultipartMessageImpl aMmsMsg) throws IOException {
        Logger.LOG(15, 4, "+ MultipartMessageImpl::resolveHeaders()");
        switch (aMsg.readByte()) {
            case 1: {
                aMmsMsg.setHeader("x-mms-priority", "low");
                break;
            }
            case 2: {
                aMmsMsg.setHeader("x-mms-priority", "normal");
                break;
            }
            case 3: {
                aMmsMsg.setHeader("x-mms-priority", "high");
            }
        }
        aMmsMsg.setTimestamp(aMsg.readLong());
        String applicationID = null;
        block14: for (int k = 0; k < aHeaderLengths.length; ++k) {
            if (aHeaderLengths[k] <= 0) continue;
            byte[] header = new byte[aHeaderLengths[k]];
            aMsg.readFully(header);
            String sHeader = new String(header);
            switch (k) {
                case 0: {
                    aMmsMsg.setReplyToAppID(sHeader);
                    continue block14;
                }
                case 1: {
                    aMmsMsg.iMessageHeader.iApplicationID = applicationID = sHeader;
                    continue block14;
                }
                case 2: {
                    aMmsMsg.setSubject(sHeader);
                    continue block14;
                }
                case 3: {
                    aMmsMsg.setFrom(sHeader);
                    continue block14;
                }
                case 4: {
                    MultipartMessageImpl.parseAndSetAddress("to", sHeader, applicationID, aMmsMsg);
                    continue block14;
                }
                case 5: {
                    MultipartMessageImpl.parseAndSetAddress("bcc", sHeader, applicationID, aMmsMsg);
                    continue block14;
                }
                case 6: {
                    MultipartMessageImpl.parseAndSetAddress("cc", sHeader, applicationID, aMmsMsg);
                }
            }
        }
        Logger.LOG(15, 4, "- MultipartMessageImpl::resolveHeaders()");
    }

    private static void parseAndSetAddress(String aAddressType, String aAddresses, String aApplicationID, MultipartMessageImpl aMmsMsg) {
        Logger.LOG(15, 4, "+ MultipartMessageImpl::parseAndSetAddress()");
        Vector vAddresses = MultipartMessageImpl.parseAddress(aAddresses);
        for (int j = 0; j < vAddresses.size(); ++j) {
            aMmsMsg.iMessageHeader.setAddress(aAddressType, "mms://" + (String)vAddresses.elementAt(j) + (aApplicationID != null ? ":" + aApplicationID : ""));
        }
        Logger.LOG(15, 4, "- MultipartMessageImpl::parseAndSetAddress()");
    }

    private static Vector parseAddress(String aAddresses) {
        Logger.LOG(15, 4, "+ MultipartMessageImpl::parseAddress()");
        Vector vAddresses = new Vector();
        int index = aAddresses.indexOf(";");
        while (index != -1) {
            vAddresses.addElement(aAddresses.substring(0, index));
            aAddresses = aAddresses.substring(index + 1);
            index = aAddresses.indexOf(";");
        }
        vAddresses.addElement(aAddresses);
        Logger.LOG(15, 4, "- MultipartMessageImpl::parseAddress()");
        return vAddresses;
    }

    private static byte divide(byte a, int b) {
        if (a / b > 0) {
            return (byte)(a - (byte)(b * (a / b)));
        }
        return -1;
    }

    private boolean validField(String aField) {
        return aField != null && aField.length() > 0;
    }

    public String toString() {
        return this.iMessageHeader.toString() + "\n" + this.iMessageBody.toString();
    }

    static {
        try {
            Class.forName("javax.wireless.messaging.MessagePart");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

