/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.pim;

import com.nokia.mj.impl.pim.EventListImpl;
import com.nokia.mj.impl.pim.GenericException;
import com.nokia.mj.impl.pim.PIMItemImpl;
import com.nokia.mj.impl.pim.PIMManager;
import com.nokia.mj.impl.pim.RepeatRuleInvoker;
import com.nokia.mj.impl.pim.utils.NativeError;
import java.util.Date;
import java.util.Enumeration;
import javax.microedition.pim.Event;
import javax.microedition.pim.RepeatRule;

public final class EventImpl
extends PIMItemImpl
implements Event {
    private RepeatRule iRepeatRule;

    EventImpl(int aItemHandle, RepeatRule aRepeatRule) {
        super(aItemHandle);
        this.iRepeatRule = aRepeatRule;
        this.iItemType = 2;
    }

    EventImpl(int aItemHandle, RepeatRule aRepeatRule, EventListImpl aEventList) {
        super(aItemHandle, aEventList);
        this.iItemType = 2;
        this.iRepeatRule = aRepeatRule;
    }

    EventImpl() {
        this.iItemType = 2;
        int[] repeatRuleHandle = new int[1];
        int[] err = new int[1];
        this.iItemHandle = this._createNativePeer(((PIMManager)PIMManager.getInstance()).managerHandle(), repeatRuleHandle, err);
        if (!NativeError.checkSuccess(err[0])) {
            throw new GenericException("General error:" + err[0]);
        }
        this.iRepeatRule = RepeatRuleInvoker.createRepeatRule(repeatRuleHandle[0]);
    }

    String getShortInfo() {
        String info = null;
        if (this.isFieldSupportedAndPresent(107)) {
            info = this.getString(107, 0);
        } else if (this.isFieldSupportedAndPresent(103)) {
            info = this.getString(103, 0);
        }
        return info;
    }

    public synchronized RepeatRule getRepeat() {
        boolean isRepeating = this._isRepeating(this.iItemHandle);
        RepeatRule duplicate = null;
        if (isRepeating) {
            duplicate = new RepeatRule();
            this.copyRepeatRule(duplicate, this.iRepeatRule);
        }
        return duplicate;
    }

    public synchronized void setRepeat(RepeatRule aValue) {
        if (aValue == null) {
            this._setRepeating(this.iItemHandle, false);
        } else {
            int repeatRuleHandle = RepeatRuleInvoker.getHandle(this.iRepeatRule);
            this._clearRepeatRule(repeatRuleHandle);
            this.copyRepeatRule(this.iRepeatRule, aValue);
            this._setRepeating(this.iItemHandle, true);
        }
    }

    protected void copyRepeatRule(RepeatRule aToRule, RepeatRule aFromRule) {
        int[] fields = aFromRule.getFields();
        for (int i = 0; i < fields.length; ++i) {
            int field = fields[i];
            if (field == 64) {
                long value = aFromRule.getDate(field);
                aToRule.setDate(field, value);
                continue;
            }
            int value = aFromRule.getInt(field);
            aToRule.setInt(field, value);
        }
        Enumeration exceptionDates = aFromRule.getExceptDates();
        while (exceptionDates.hasMoreElements()) {
            Date exceptionDate = (Date)exceptionDates.nextElement();
            aToRule.addExceptDate(exceptionDate.getTime());
        }
    }

    void copyFrom(Event aEvent) {
        this.baseCopyFrom(aEvent);
        this.setRepeat(aEvent.getRepeat());
    }

    private native int _createNativePeer(int var1, int[] var2, int[] var3);

    private native boolean _isRepeating(int var1);

    private native void _setRepeating(int var1, boolean var2);

    private native void _clearRepeatRule(int var1);
}

