/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.pim;

import com.nokia.mj.impl.pim.ContactImpl;
import com.nokia.mj.impl.pim.EventImpl;
import com.nokia.mj.impl.pim.GenericException;
import com.nokia.mj.impl.pim.PIMItemImpl;
import com.nokia.mj.impl.pim.RepeatRuleInvoker;
import com.nokia.mj.impl.pim.ToDoImpl;
import com.nokia.mj.impl.pim.utils.NativeError;
import com.nokia.mj.impl.rt.support.ApplicationUtils;
import com.nokia.mj.impl.rt.support.Finalizer;
import com.nokia.mj.impl.rt.support.ShutdownListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import javax.microedition.pim.Contact;
import javax.microedition.pim.Event;
import javax.microedition.pim.PIMException;
import javax.microedition.pim.PIMItem;
import javax.microedition.pim.RepeatRule;
import javax.microedition.pim.ToDo;

final class Serializer {
    private static final String[] PIM_SUPPORTED_ENCODINGS = new String[]{"UTF-8", "ISO-8859-1"};
    private static final String PIM_BEGIN = "BEGIN";
    private static final String PIM_END = "END";
    private static final byte PIM_COLON = 58;
    private static final byte PIM_SPACE = 32;
    private static final byte PIM_TAB = 9;
    private static final String PIM_VCARD = "VCARD";
    private static final String PIM_VCALENDARD = "VCALENDAR";
    private static final String PIM_EVENT = "EVENT";
    private static final String PIM_TODO = "TODO";
    private static final String PIM_BEGIN_VCARD = "BEGIN:VCARD";
    private static final String PIM_BEGIN_VCALENDAR = "BEGIN:VCALENDAR";
    private static final String PIM_END_VCARD = "END:VCARD";
    private static final String PIM_END_VCALENDAR = "END:VCALENDAR";
    private Finalizer iFinalizer;
    private int iSerializerHandle;

    Serializer(int aManagerHandle) {
        int[] err = new int[1];
        this.iSerializerHandle = this._createSerializer(aManagerHandle, err);
        if (!NativeError.checkSuccess(err[0])) {
            throw new GenericException("General error:" + err[0]);
        }
        this.iFinalizer = this.registerForFinalization();
        this.setShutdownListener();
    }

    public Finalizer registerForFinalization() {
        return new Finalizer(){

            public void finalizeImpl() {
                Serializer.this.doFinalize();
            }
        };
    }

    void doFinalize() {
        if (this.iFinalizer == null) {
            return;
        }
        this.iFinalizer = null;
        if (this.iSerializerHandle != 0) {
            this._dispose(this.iSerializerHandle);
            this.iSerializerHandle = 0;
        }
    }

    private void setShutdownListener() {
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        appUtils.addShutdownListener(new ShutdownListener(){

            public void shuttingDown() {
                if (Serializer.this.iSerializerHandle != 0) {
                    Serializer.this._dispose(Serializer.this.iSerializerHandle);
                    Serializer.this.iSerializerHandle = 0;
                }
            }
        });
    }

    PIMItem[] fromSerialFormat(InputStream aIs, String aEnc) throws PIMException, UnsupportedEncodingException {
        if (null == aIs) {
            throw new NullPointerException();
        }
        int encoding = this.checkEncoding(aEnc);
        byte[] buffer = null;
        try {
            buffer = this.readLine(aIs, null);
        }
        catch (IOException e) {
            throw new PIMException("Stream error: " + e.getMessage(), 1);
        }
        if (null == buffer) {
            throw new PIMException("Data serialization failed:Not a complete entry", 1);
        }
        String readString = new String(buffer);
        if (readString.regionMatches(true, 0, PIM_BEGIN_VCARD, 0, PIM_BEGIN_VCARD.length())) {
            return this.fromVCard(readString, aIs, encoding);
        }
        if (readString.regionMatches(true, 0, PIM_BEGIN_VCALENDAR, 0, PIM_BEGIN_VCALENDAR.length())) {
            return this.fromVCalendar(readString, aIs, encoding);
        }
        throw new PIMException("Data serialization failed:Data is not a vCard or a vCalendar");
    }

    void toSerialFormat(PIMItem aItem, OutputStream aOs, String aEnc, String aDataFormat) throws PIMException, UnsupportedEncodingException {
        if (aOs == null || aDataFormat == null || aItem == null) {
            throw new NullPointerException();
        }
        int encoding = this.checkEncoding(aEnc);
        byte[] buffer = null;
        int[] error = new int[1];
        PIMItemImpl item = this.createPIMItemImpl(aItem);
        this.testSupportedFormat(aDataFormat, item);
        buffer = this._toSerialFormat(this.iSerializerHandle, item.jniNativeHandle(), encoding, error);
        NativeError.handleToSerialFormatError(error[0]);
        try {
            aOs.write(buffer);
        }
        catch (IOException e) {
            throw new PIMException("Stream error: " + e.getMessage(), 1);
        }
    }

    String[] supportedSerialFormats(int aPimListType) {
        if (aPimListType < 1 || aPimListType > 3) {
            throw new IllegalArgumentException("Invalid list type: " + aPimListType);
        }
        int[] error = new int[1];
        String[] retVal = this._supportedSerialFormats(this.iSerializerHandle, aPimListType, error);
        if (!NativeError.checkSuccess(error[0])) {
            throw new OutOfMemoryError("General error:" + error[0]);
        }
        return retVal;
    }

    private PIMItemImpl createPIMItemImpl(PIMItem aItem) throws PIMException {
        PIMItemImpl retVal = null;
        if (aItem instanceof PIMItemImpl) {
            retVal = (PIMItemImpl)aItem;
        } else if (aItem instanceof Contact) {
            ContactImpl contact = new ContactImpl();
            contact.copyFrom((Contact)aItem);
            retVal = contact;
        } else if (aItem instanceof Event) {
            EventImpl event = new EventImpl();
            event.copyFrom((Event)aItem);
            retVal = event;
        } else if (aItem instanceof ToDo) {
            ToDoImpl todo = new ToDoImpl();
            todo.copyFrom((ToDo)aItem);
            retVal = todo;
        } else {
            throw new PIMException("Data serialization failed:Unsupported item type", 1);
        }
        return retVal;
    }

    private PIMItem[] fromVCard(String aFirstLine, InputStream aIs, int aEncoding) throws PIMException {
        boolean completeVCard = false;
        int sizeOfVCard = 0;
        String readString = aFirstLine;
        byte[] buffer = readString.getBytes();
        int[] error = new int[1];
        while (!completeVCard) {
            sizeOfVCard = this.lengthOfVCard(new String(buffer));
            if (sizeOfVCard == -1) {
                try {
                    byte[] newBuffer = this.readLine(aIs, buffer);
                    if (newBuffer == null) {
                        completeVCard = true;
                        sizeOfVCard = buffer.length;
                        continue;
                    }
                    buffer = newBuffer;
                    continue;
                }
                catch (IOException e) {
                    throw new PIMException("Stream error: " + e.getMessage(), 1);
                }
            }
            completeVCard = true;
        }
        int[] itemHandles = this._fromSerialFormat(this.iSerializerHandle, buffer, sizeOfVCard, aEncoding, error);
        NativeError.handleSerializationError(error[0]);
        int itemCount = itemHandles.length / 2;
        PIMItem[] itemArray = new PIMItem[itemCount];
        for (int i = 0; i < itemCount; ++i) {
            if (itemHandles[i * 2] != 1) {
                throw new OutOfMemoryError("Not a contact");
            }
            itemArray[i] = new ContactImpl(itemHandles[i * 2 + 1]);
        }
        return itemArray;
    }

    private PIMItem[] fromVCalendar(String aFirstLine, InputStream aIs, int aEncoding) throws PIMException {
        boolean endFound = false;
        String readString = aFirstLine;
        byte[] buffer = readString.getBytes();
        int[] error = new int[1];
        while (!endFound) {
            int indexOfEnd = readString.indexOf(PIM_END_VCALENDAR);
            if (indexOfEnd != -1) {
                endFound = true;
                continue;
            }
            try {
                byte[] newBuffer = this.readLine(aIs, buffer);
                if (newBuffer == null) {
                    throw new PIMException("Not a complete entry", 1);
                }
                buffer = newBuffer;
            }
            catch (IOException e) {
                throw new PIMException("Stream error: " + e.getMessage(), 1);
            }
            readString = new String(buffer);
        }
        int[] itemHandles = this._fromSerialFormat(this.iSerializerHandle, buffer, buffer.length, aEncoding, error);
        NativeError.handleSerializationError(error[0]);
        int handleCount = itemHandles.length / 2;
        Vector itemVector = new Vector(handleCount);
        block7: for (int i = 0; i < handleCount; ++i) {
            switch (itemHandles[i * 2]) {
                case 2: {
                    int repeatRuleHandle = itemHandles[i * 2 + 2];
                    RepeatRule repeatRule = RepeatRuleInvoker.createRepeatRule(repeatRuleHandle);
                    itemVector.addElement(new EventImpl(itemHandles[i * 2 + 1], repeatRule));
                    ++i;
                    continue block7;
                }
                case 3: {
                    itemVector.addElement(new ToDoImpl(itemHandles[i * 2 + 1]));
                    continue block7;
                }
                default: {
                    throw new PIMException();
                }
            }
        }
        int itemCount = itemVector.size();
        PIMItem[] itemArray = new PIMItem[itemCount];
        for (int i = 0; i < itemCount; ++i) {
            itemArray[i] = (PIMItem)itemVector.elementAt(i);
        }
        return itemArray;
    }

    private int lengthOfVCard(String aString) {
        int beginCount = 1;
        int indexOfBegin = 0;
        int indexOfEnd = 0;
        for (int endCount = 0; endCount < beginCount; ++endCount) {
            if ((indexOfEnd = aString.indexOf(PIM_END_VCARD, indexOfEnd + 1)) != -1) continue;
            return -1;
        }
        int vCardLength = indexOfEnd + PIM_END_VCARD.length();
        return vCardLength;
    }

    private byte[] readLine(InputStream aIs, byte[] aReadSoFar) throws IOException {
        ByteArrayOutputStream os = null;
        ByteArrayOutputStream lastLine = new ByteArrayOutputStream();
        if (aReadSoFar != null) {
            os = new ByteArrayOutputStream(aReadSoFar.length);
            os.write(aReadSoFar, 0, aReadSoFar.length);
        } else {
            os = new ByteArrayOutputStream();
        }
        int readByte = aIs.read();
        if (readByte == -1) {
            return null;
        }
        lastLine.write(readByte);
        byte[] lastLineBytes = null;
        while (readByte != 10) {
            readByte = aIs.read();
            if (readByte == -1) {
                lastLineBytes = this.stripWhiteSpaces(lastLine.toByteArray());
                break;
            }
            lastLine.write(readByte);
            lastLineBytes = this.stripWhiteSpaces(lastLine.toByteArray());
            String lastLineString = new String(this.stripWhiteSpaces(lastLineBytes));
            if (!lastLineString.equals(PIM_END_VCARD) && !lastLineString.equals(PIM_END_VCALENDAR)) continue;
            break;
        }
        os.write(lastLineBytes);
        return os.toByteArray();
    }

    private byte[] stripWhiteSpaces(byte[] aString) throws IOException {
        int pos;
        if (aString.length < 3) {
            return aString;
        }
        boolean isBegin = false;
        boolean isEnd = false;
        String beginning = new String(aString, 0, 3);
        if (beginning.equals(PIM_END)) {
            isEnd = true;
        } else {
            if (aString.length < 5) {
                return aString;
            }
            beginning = new String(aString, 0, 5);
            if (beginning.equals(PIM_BEGIN)) {
                isBegin = true;
            }
        }
        if (!isBegin && !isEnd) {
            return aString;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write(beginning.getBytes());
        for (pos = beginning.length(); pos < aString.length; ++pos) {
            if (aString[pos] == 32 || aString[pos] == 9) {
                continue;
            }
            if (aString[pos] == 58) break;
            return aString;
        }
        ++pos;
        os.write(58);
        while (pos < aString.length && (aString[pos] == 32 || aString[pos] == 9)) {
            ++pos;
        }
        if (pos >= aString.length) {
            return aString;
        }
        os.write(aString, pos, aString.length - pos);
        String end = new String(aString, pos, aString.length - pos);
        if (end.equals(PIM_VCARD)) {
            return os.toByteArray();
        }
        if (end.equals(PIM_VCALENDARD)) {
            return os.toByteArray();
        }
        if (end.equals(PIM_EVENT)) {
            return os.toByteArray();
        }
        if (end.equals(PIM_TODO)) {
            return os.toByteArray();
        }
        return aString;
    }

    private void testSupportedFormat(String aFormat, PIMItemImpl aItem) {
        int listType = aItem.getItemType();
        String[] supportedFormats = this.supportedSerialFormats(listType);
        for (int i = 0; i < supportedFormats.length; ++i) {
            if (!aFormat.equals(supportedFormats[i])) continue;
            return;
        }
        throw new IllegalArgumentException("Unsupported format: " + aFormat);
    }

    private int checkEncoding(String aEnc) throws UnsupportedEncodingException {
        int encoding = 0;
        if (null != aEnc) {
            boolean supportedEncoding = false;
            for (int i = 0; i < PIM_SUPPORTED_ENCODINGS.length; ++i) {
                if (!aEnc.equals(PIM_SUPPORTED_ENCODINGS[i])) continue;
                encoding = i;
                supportedEncoding = true;
            }
            if (!supportedEncoding) {
                throw new UnsupportedEncodingException();
            }
        }
        return encoding;
    }

    private native int _createSerializer(int var1, int[] var2);

    private native void _dispose(int var1);

    private native int[] _fromSerialFormat(int var1, byte[] var2, int var3, int var4, int[] var5);

    private native byte[] _toSerialFormat(int var1, int var2, int var3, int[] var4);

    private native String[] _supportedSerialFormats(int var1, int var2, int[] var3);
}

