/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.push;

import com.nokia.mj.impl.gcf.PushSecurityUtils;
import com.nokia.mj.impl.installer.pushregistrator.PushApplicationInfo;
import com.nokia.mj.impl.installer.pushregistrator.PushInfo;
import com.nokia.mj.impl.installer.pushregistrator.PushRegistrationException;
import com.nokia.mj.impl.installer.pushregistrator.PushRegistrator;
import com.nokia.mj.impl.push.PushDbHandler;
import com.nokia.mj.impl.push.PushValidatorLoader;
import com.nokia.mj.impl.storage.StorageException;
import com.nokia.mj.impl.storage.StorageFactory;
import com.nokia.mj.impl.storage.StorageSession;
import com.nokia.mj.impl.utils.Logger;
import com.nokia.mj.impl.utils.Uid;
import java.security.AccessControlException;
import javax.microedition.io.ConnectionNotFoundException;

public final class PushRegistratorImpl
implements PushRegistrator {
    private static final int DYN_PUSH_REG = 0;
    private static final int STATIC_PUSH_REG = 1;

    private boolean isUniqueConstraintErr(String aErrTxt) {
        if (-1 != aErrTxt.indexOf("-329")) {
            return true;
        }
        return -1 != aErrTxt.indexOf("-95");
    }

    public void registerPush(StorageSession aSession, Uid aSuiteUid, PushInfo[] aPushInfos) {
        int i;
        Logger.LOG(12, 4, "PushRegistratorImpl.registerPush() #1");
        if (null == aSession || null == aSuiteUid) {
            throw new PushRegistrationException(8, null, 12, new String[]{"null passed as argument to registerPush()"}, 902, null);
        }
        if (null == aPushInfos) {
            return;
        }
        if (0 == aPushInfos.length) {
            return;
        }
        try {
            for (i = 0; i < aPushInfos.length; ++i) {
                PushSecurityUtils.ensurePermission(aPushInfos[i].getUid(), "staticregistration");
            }
            for (i = 0; i < aPushInfos.length; ++i) {
                Logger.LOG(12, 4, "Calling PushValidatorLoader.validatePushArguments() operation");
                PushValidatorLoader.getInstance().validatePushArguments(aPushInfos[i].getConnectionUrl(), aPushInfos[i].getFilter(), aSuiteUid, aPushInfos[i].getName(), true);
            }
            PushDbHandler.storePushRegs(aSession, aPushInfos);
        }
        catch (ConnectionNotFoundException ex) {
            Logger.LOG(12, 1, "registerPush(): Orig. exception: " + ex);
            throw new PushRegistrationException(7, null, 6, new String[]{aPushInfos[i].getConnectionUrl()}, 911);
        }
        catch (IllegalArgumentException ex) {
            Logger.LOG(12, 1, "registerPush(): Orig. exception: " + ex);
            throw new PushRegistrationException(7, null, 7, new String[]{aPushInfos[i].getPushAttribute()}, 911);
        }
        catch (StorageException ex) {
            Logger.LOG(12, 1, "registerPush(): Orig. exception: " + ex.toString());
            int errCode = 8;
            String[] errTxt = new String[]{"Storing push registrations failed to the db error"};
            if (this.isUniqueConstraintErr(ex.toString())) {
                errCode = 7;
                errTxt = new String[]{"Storing push registrations failed to unique constraint error"};
            }
            throw new PushRegistrationException(errCode, null, 12, errTxt, 911);
        }
        catch (PushRegistrationException ex) {
            throw ex;
        }
        catch (AccessControlException ex) {
            Logger.LOG(12, 1, "registerPush(): Orig. exception: " + ex);
            throw new PushRegistrationException(7, null, 7, new String[]{aPushInfos[i].getPushAttribute()}, 910, null);
        }
        catch (Throwable ex) {
            Logger.LOG(12, 1, "registerPush(): Orig. exception: " + ex);
            throw new PushRegistrationException(8, null, 12, new String[]{"Registering push attributes failed to unexpected exception"}, 902, ex);
        }
    }

    public void unregisterPush(StorageSession aSession, Uid aSuiteUid, Uid[] aUids) {
        Logger.LOG(12, 4, "PushRegistratorImpl.unregisterPush()");
        if (null == aSession) {
            throw new PushRegistrationException(102, null, 12, new String[]{"unregisterPush() 'aSession' argument is null"}, 902, null);
        }
        if (aUids == null) {
            return;
        }
        try {
            for (int i = 0; i < aUids.length; ++i) {
                PushDbHandler.deletePushRegs(aSession, aUids[i]);
                PushDbHandler.deleteAlarm(aSession, aUids[i]);
            }
        }
        catch (StorageException ex) {
            Logger.LOG(12, 1, "unregisterPush(): Orig. exception: " + ex);
            throw new PushRegistrationException(102, null, 12, new String[]{"Deleting push registrations failed to the db error"}, 902, ex);
        }
        catch (Throwable ex) {
            Logger.LOG(12, 1, "unregisterPush(): Orig. exception: " + ex);
            throw new PushRegistrationException(102, null, 12, new String[]{"Unregistering push attributes failed to unexpected exception"}, 902, ex);
        }
    }

    public void upgradePush(StorageSession aSession, Uid aSuiteUid, PushApplicationInfo[] aOldPushAppInfos, PushApplicationInfo[] aNewPushApplicationInfos, PushInfo[] aNewPushInfos) {
        Logger.LOG(12, 4, "PushRegistratorImpl.upgradePush()");
        if (null == aOldPushAppInfos || null == aNewPushApplicationInfos || null == aSession) {
            throw new PushRegistrationException(8, null, 12, new String[]{"upgradePush() One of the mandatory argument is null"}, 902, null);
        }
        try {
            for (int i = 0; i < aOldPushAppInfos.length; ++i) {
                PushDbHandler.deletePushRegs(aSession, aOldPushAppInfos[i].getUid());
                PushDbHandler.deleteAlarm(aSession, aOldPushAppInfos[i].getUid());
            }
        }
        catch (StorageException ex) {
            Logger.LOG(12, 1, "upgradePush(): Orig. exception: " + ex);
            throw new PushRegistrationException(8, null, 12, new String[]{"Upgrading push registrations failed to the db error"}, 902, ex);
        }
        this.registerPush(aSession, aSuiteUid, aNewPushInfos);
    }

    public PushInfo[] getPushInfos(Uid aUid) {
        Logger.LOG(12, 4, "PushRegistratorImpl.getPushInfos()");
        StorageSession sessionObj = null;
        try {
            PushInfo[] retTable;
            sessionObj = StorageFactory.createSession();
            sessionObj.open();
            PushInfo[] pushInfoArray = retTable = PushDbHandler.getPushRegs(sessionObj, aUid);
            return pushInfoArray;
        }
        catch (StorageException ex) {
            Logger.LOG(12, 1, "upgradePush(): Orig. exception: " + ex);
            throw new PushRegistrationException(8, null, 12, new String[]{"Getting push registrations failed to the db error"}, 902, ex);
        }
        catch (Throwable ex) {
            Logger.LOG(12, 1, "upgradePush(): Orig. exception: " + ex);
            throw new PushRegistrationException(8, null, 12, new String[]{"Getting push attributes failed to unexpected exception"}, 902, ex);
        }
        finally {
            if (null != sessionObj) {
                sessionObj.close();
                sessionObj.destroySession();
            }
        }
    }
}

