/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.push;

import com.nokia.mj.impl.gcf.PushValidator;
import com.nokia.mj.impl.utils.Logger;
import com.nokia.mj.impl.utils.Uid;
import java.io.IOException;
import java.util.Hashtable;
import javax.microedition.io.ConnectionNotFoundException;

final class PushValidatorLoader {
    private static final String PROTOCOL_PACKAGE_PATH = "com.nokia.mj.impl.gcf.protocol.";
    private static final String NAME_OF_VALIDATOR_CLASS = ".PushValidatorImpl";
    private static PushValidatorLoader sValidatorLoaderObj = null;
    Hashtable mValidatorContainer = new Hashtable();

    public static synchronized PushValidatorLoader getInstance() {
        if (null == sValidatorLoaderObj) {
            sValidatorLoaderObj = new PushValidatorLoader();
        }
        return sValidatorLoaderObj;
    }

    public void validatePushArguments(String aUri, String aFilter, Uid aSuiteUid, String aMidletName, boolean aIsStaticRegistration) throws ConnectionNotFoundException, IOException {
        Logger.LOG(8, 4, "+ PushValidatorLoader.validatePushArguments()");
        try {
            if (null == aUri || null == aFilter) {
                throw new IllegalArgumentException("URI/filter argument is null");
            }
            if (aUri.equals("") || aFilter.equals("")) {
                throw new IllegalArgumentException("URI/filter argument string is empty");
            }
            PushValidator validatorInstance = this.getPushValidator(aUri);
            validatorInstance.validate(aUri, aFilter, aSuiteUid, aMidletName, aIsStaticRegistration);
            Logger.LOG(8, 4, "- PushValidatorLoader.validatePushArguments()");
        }
        catch (ClassNotFoundException ex) {
            throw new ConnectionNotFoundException("Unsupported URI scheme");
        }
        catch (IllegalAccessException ex) {
            throw new ConnectionNotFoundException("Validator class of the URI is not accessible");
        }
        catch (InstantiationException ex) {
            throw new ConnectionNotFoundException("Validator object of the URI can not be instantiated");
        }
    }

    private PushValidator getPushValidator(String aUri) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        PushValidator validatorObj;
        int index = aUri.indexOf(58);
        if (-1 == index) {
            throw new IllegalArgumentException("Uri is not valid");
        }
        String schemeStr = aUri.substring(0, index);
        if (schemeStr.equals("secure-element")) {
            schemeStr = "secureelement";
        }
        if (null != (validatorObj = (PushValidator)this.mValidatorContainer.get(schemeStr))) {
            return validatorObj;
        }
        StringBuffer nameOfValidatorClass = new StringBuffer(PROTOCOL_PACKAGE_PATH.length() + schemeStr.length() + NAME_OF_VALIDATOR_CLASS.length());
        nameOfValidatorClass.append(PROTOCOL_PACKAGE_PATH);
        nameOfValidatorClass.append(schemeStr);
        nameOfValidatorClass.append(NAME_OF_VALIDATOR_CLASS);
        Class clazz = Class.forName(nameOfValidatorClass.toString());
        validatorObj = (PushValidator)clazz.newInstance();
        this.mValidatorContainer.put(schemeStr, validatorObj);
        return validatorObj;
    }
}

