/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.rt.midp;

import com.nokia.mj.impl.rt.midp.Log;
import com.nokia.mj.impl.rt.midp.MidletLifeCycle;
import com.nokia.mj.impl.rt.support.ApplicationInfo;
import com.nokia.mj.impl.rt.support.ApplicationUtils;
import com.nokia.mj.impl.security.midp.authorization.AccessControllerFactoryImpl;
import com.nokia.mj.impl.security.midp.authorization.AccessControllerImpl;
import com.nokia.mj.impl.utils.Uid;
import com.nokia.mj.impl.utils.exception.UserCancelException;
import java.security.AccessControlException;
import java.security.Permission;

public class ApplicationUtilsImpl
extends ApplicationUtils {
    private AccessControllerImpl mAccessController;

    public static void doShutdownImpl() {
        ((ApplicationUtilsImpl)sInstance).doShutdown();
    }

    public static void releaseStartWaiterImpl(boolean doStart) {
        ((ApplicationUtilsImpl)sInstance).releaseStartWaiter(doStart);
    }

    public void notifyExitCmd() {
        MidletLifeCycle.getInstance().terminateMidletRequest(true);
    }

    public void pauseApplication() {
        MidletLifeCycle.getInstance().pauseApplication();
    }

    public void resumeApplication() {
        MidletLifeCycle.getInstance().resumeRequest();
    }

    public void checkPermission(Permission p) throws AccessControlException, NullPointerException {
        if (p == null) {
            throw new NullPointerException("Check permission called with null Permission");
        }
        if (this.mAccessController == null) {
            try {
                this.mAccessController = AccessControllerFactoryImpl.getAccessController(ApplicationInfo.getInstance().getSuiteUid(), ApplicationInfo.getInstance().getName());
            }
            catch (Throwable t) {
                throw new AccessControlException("Error creating AccessControllerFactory. Reason " + t);
            }
            if (this.mAccessController == null) {
                throw new AccessControlException("Error in AccessController");
            }
        }
        try {
            this.mAccessController.checkPermission(p);
        }
        catch (UserCancelException uce) {
            if (uce.getRootException() instanceof AccessControlException) {
                throw (AccessControlException)uce.getRootException();
            }
            throw new AccessControlException("User cancelled");
        }
        catch (AccessControlException a) {
            throw a;
        }
        catch (Throwable t) {
            Log.logE("Error in checking permission: " + p, t);
            throw new AccessControlException("Error in Security impl. Reason " + t);
        }
    }

    public void checkPermission(Uid appUid, Permission p) throws AccessControlException, NullPointerException {
        this.checkPermission(p);
    }
}

