/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.rt.midp;

import com.nokia.mj.impl.coreui.CoreUi;
import com.nokia.mj.impl.fileutils.FileUtility;
import com.nokia.mj.impl.gcf.PushSecurityUtils;
import com.nokia.mj.impl.rt.legacy.LegacySupport;
import com.nokia.mj.impl.rt.midp.ApplicationInfoImpl;
import com.nokia.mj.impl.rt.midp.ApplicationUtilsImpl;
import com.nokia.mj.impl.rt.midp.DrmUtil;
import com.nokia.mj.impl.rt.midp.ExtensionUtil;
import com.nokia.mj.impl.rt.midp.LifeCycleTask;
import com.nokia.mj.impl.rt.midp.Log;
import com.nokia.mj.impl.rt.midp.MainArgs;
import com.nokia.mj.impl.rt.midp.MidletApplicationBase;
import com.nokia.mj.impl.rt.midp.MidletInfo;
import com.nokia.mj.impl.rt.midp.MidletInvoker;
import com.nokia.mj.impl.rt.midp.MidpComms;
import com.nokia.mj.impl.rt.midp.RuntimeErrorDialog;
import com.nokia.mj.impl.rt.midp.StartupException;
import com.nokia.mj.impl.rt.midp.StorageAccessor;
import com.nokia.mj.impl.rt.support.Jvm;
import com.nokia.mj.impl.rt.support.JvmInternal;
import com.nokia.mj.impl.rt.support.ThreadEventListener;
import com.nokia.mj.impl.security.common.RuntimeSecurityException;
import com.nokia.mj.impl.security.midp.authentication.AuthenticationModule;
import com.nokia.mj.impl.security.midp.storage.AuthenticationStorageData;
import com.nokia.mj.impl.security.packageprotection.PackageProtector;
import com.nokia.mj.impl.utils.LineReader;
import com.nokia.mj.impl.utils.TaskQueue;
import com.nokia.mj.impl.utils.Uid;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Timer;
import java.util.TimerTask;

final class MidletLifeCycle {
    private static final int STARTING_INIT = 1;
    private static final int PRE_INIT_DONE = 2;
    private static final int POST_INIT_DONE = 4;
    private static final int STARTING_MIDLET = 8;
    private static final int RUNNING = 16;
    private static final int PAUSED = 32;
    private static final int STOPPING_MIDLET = 64;
    private static final int CLOSED = 128;
    private static final int RESUMING = 256;
    private static MidletLifeCycle mInstance = new MidletLifeCycle();
    private Timer mTimer;
    private ShutDownTimerTask mShutDownTimerTask;
    private MainArgs mMainArgs;
    private TaskQueue mTaskQueue;
    private int mState = 1;
    private MidpComms mMidpcomms;
    private MidletApplicationBase mMidletApplication;
    private Uid mMidletUid;
    private int mNativeRuntimeStarterHandle;
    private RuntimeErrorDialog mRuntimeErrDialog;
    private boolean mPrewarmStart = false;
    private boolean mBackGroundStart = false;

    private MidletLifeCycle() {
    }

    static MidletLifeCycle getInstance() {
        return mInstance;
    }

    static void destroyInstance() {
        if (mInstance != null) {
            DrmUtil.consumeRightsStop();
            if (MidletLifeCycle.mInstance.mState != 128) {
                MidletLifeCycle._closeInd(MidletLifeCycle.mInstance.mNativeRuntimeStarterHandle);
            }
            if (MidletLifeCycle.mInstance.mMidpcomms != null) {
                MidletLifeCycle.mInstance.mMidpcomms.close();
            }
            mInstance = null;
        }
    }

    void doRun(String[] args) {
        this.mMainArgs = new MainArgs(args);
        this.doPreInit();
        this.startStateMachine();
        DrmUtil.consumeRightsStop();
        if (this.mRuntimeErrDialog != null) {
            this.mRuntimeErrDialog.showDialog();
        }
        MidletLifeCycle._closeInd(this.mNativeRuntimeStarterHandle);
        ApplicationUtilsImpl.doShutdownImpl();
        this.mMidpcomms.sendTerminatedIndication(0);
        this.mMidpcomms.close();
        this.mMidpcomms = null;
        try {
            Thread.sleep(200L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LegacySupport.stopDispatchers();
        this.mState = 128;
    }

    void setMidletApplication(MidletApplicationBase midletApplication) {
        this.mMidletApplication = midletApplication;
    }

    MidletApplicationBase getMidletApplication() {
        return this.mMidletApplication;
    }

    void notifyDestroyed() {
        this.mTaskQueue.addTask(new LifeCycleTask(2, 1));
    }

    void notifyPaused() {
        this.mTaskQueue.addTask(new LifeCycleTask(5));
    }

    void pauseApplication() {
        this.mTaskQueue.addTask(new LifeCycleTask(6));
    }

    void resumeRequest() {
        this.mTaskQueue.addTask(new LifeCycleTask(7));
    }

    void launchMidletRequest(Uid uid, boolean backGroundStart) {
        this.mBackGroundStart = backGroundStart;
        if (this.mState == 2) {
            this.mMidletUid = uid;
            this.mTaskQueue.addTask(new LifeCycleTask(1, 2));
        }
    }

    void terminateMidletRequest(boolean useTimer) {
        if (this.mState != 64 && this.mState != 128) {
            if (useTimer) {
                this.startShutDownTimer();
            }
            this.mTaskQueue.addTask(new LifeCycleTask(2, 2));
        }
    }

    void midletStarted() {
        this.mTaskQueue.addTask(new LifeCycleTask(3));
    }

    void midletResumed(boolean ok) {
        if (ok) {
            this.mTaskQueue.addTask(new LifeCycleTask(3));
        }
    }

    void midletDestroyed() {
        this.mTaskQueue.addTask(new LifeCycleTask(4));
    }

    void handleMidletStartUpFailure(Throwable th) {
        Log.logE("Failed to start MIDlet! ", th);
        this.mRuntimeErrDialog = RuntimeErrorDialog.getStartUpErrorDialog(th);
        this.mTaskQueue.addTask(new LifeCycleTask(8));
    }

    void handleMidletPauseAppFailure() {
        this.mTaskQueue.addTask(new LifeCycleTask(10));
    }

    void handleUncaughtException(Throwable th) {
        Log.logE("Uncaught exception! ", th);
        this.mRuntimeErrDialog = RuntimeErrorDialog.getUnhandledDialog(th);
        this.mTaskQueue.addTask(new LifeCycleTask(9));
    }

    boolean isBackGroundStart() {
        return this.mBackGroundStart;
    }

    private void startStateMachine() {
        boolean loop = true;
        block11: while (loop) {
            LifeCycleTask task = (LifeCycleTask)this.mTaskQueue.getTask();
            int mainTask = task.getMainTask();
            int subTask = task.getSubTask();
            switch (mainTask) {
                case 1: {
                    this.handleStartRequest(subTask);
                    continue block11;
                }
                case 3: {
                    this.mState = 16;
                    continue block11;
                }
                case 2: {
                    loop = this.handleStopRequest(subTask);
                    continue block11;
                }
                case 4: {
                    this.cancelShutDownTimer();
                    loop = false;
                    continue block11;
                }
                case 5: {
                    this.handlePauseRequest();
                    continue block11;
                }
                case 6: {
                    this.handlePauseAppRequest();
                    continue block11;
                }
                case 7: {
                    this.handleResumeRequest();
                    continue block11;
                }
                case 8: 
                case 10: {
                    MidletInvoker.stopMidlet();
                    loop = false;
                    continue block11;
                }
                case 9: {
                    loop = false;
                    continue block11;
                }
            }
            Log.logE("LOOP: Unknown task: " + mainTask);
        }
        this.mState = 128;
    }

    private void handleStartRequest(int subTask) {
        if (this.mState == 4) {
            if (subTask == 1) {
                this.mState = 8;
                MidletInvoker.startMidlet();
            } else if (subTask == 2) {
                this.doPreWarmInit();
            }
        }
    }

    private boolean handleStopRequest(int subTask) {
        this.mState = 64;
        boolean loop = true;
        if (subTask == 1) {
            loop = false;
        } else if (subTask == 2) {
            MidletInvoker.stopMidlet();
        } else if (subTask == 3) {
            loop = false;
        }
        return loop;
    }

    private void handlePauseRequest() {
        if (this.mState != 16) {
            Log.logW("Pause request received in illegal state: " + this.mState);
        }
        this.mState = 32;
    }

    private void handlePauseAppRequest() {
        if (this.mState != 16) {
            Log.logW("Pause request received in illegal state: " + this.mState);
        }
        MidletInvoker.pauseMidlet();
        this.mState = 32;
    }

    private void handleResumeRequest() {
        if (this.mState == 32) {
            this.mState = 8;
            MidletInvoker.resumeMidlet();
        } else {
            Log.logW("Resume request received in illegal state: " + this.mState);
        }
    }

    private void setClassProtection() {
        PackageProtector protector = PackageProtector.getInstance();
        JvmInternal.addProtectedPackagePrefixes(protector.getProtectedPackageNames());
        JvmInternal.addRestrictedPackagePrefixes(protector.getRestrictedPackageNames());
    }

    private void doPreInit() {
        Jvm.loadSystemLibrary("javamidpruntime");
        JvmInternal.setThreadEventListener(new ThreadEventListener(){

            public void threadStarting(Thread newThread, Thread parentThread) {
            }

            public void threadDied(Thread thread) {
            }

            public void uncaughtException(Thread thread, Throwable throwable) {
                MidletLifeCycle.this.handleUncaughtException(throwable);
            }
        });
        this.mNativeRuntimeStarterHandle = Integer.parseInt(this.mMainArgs.findArgument("-handle"));
        JvmInternal.disableRuntimeExit();
        this.setClassProtection();
        ExtensionUtil.handleExtensions();
        this.mTaskQueue = new TaskQueue();
        String pid = this.mMainArgs.findArgument("-prewarm");
        this.mPrewarmStart = pid != null;
        this.mState = 2;
        if (!this.mPrewarmStart) {
            this.mMidletUid = Uid.createUid(this.mMainArgs.findArgument("-uid"));
            if (!CoreUi.connectToUi()) {
                throw new StartupException("Core UI closed.", false);
            }
            this.mBackGroundStart = this.mMainArgs.findArgument("-background") != null;
            this.doPostInit();
            this.mMidpcomms = new MidpComms(this.mMidletUid);
            this.mMidpcomms.sendRunningIndication(0);
        } else {
            this.mMidpcomms = new MidpComms();
            this.mMidpcomms.sendProcessRunningIndication(Integer.parseInt(pid));
            this.wakeUpUi();
        }
    }

    private void wakeUpUi() {
        String className = System.getProperty("com.nokia.mj.impl.ui");
        if (className != null) {
            try {
                Class clazz = Class.forName(className);
                clazz.newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void doPreWarmInit() {
        this._setUid(this.mMidletUid.toString(), this.mNativeRuntimeStarterHandle);
        int heap = this.getRecordedHeapSize();
        if (heap > 20) {
            // empty if block
        }
        this.doPostInit();
        String classPath = ApplicationInfoImpl.getMidletInfo().getClassPath();
        JvmInternal.appendToClassPath(classPath);
    }

    private void doPostInit() {
        this.setMidletInfo();
        if (this.mPrewarmStart) {
            CoreUi.createUi(this.mMidletUid, this.mBackGroundStart);
        }
        this.verifyMIDletSuiteAuthenticity();
        DrmUtil.consumeRightsStart();
        if (this.mMainArgs.findArgument("-autoinvocation") != null) {
            try {
                String pushAdditionalInfo = this.mMainArgs.findArgument("-autoInvocationAdditional");
                PushSecurityUtils.ensurePermission("autoinvocation", pushAdditionalInfo);
            }
            catch (SecurityException se) {
                throw new StartupException("Auto invocation not allowed.", false);
            }
        }
        LegacySupport.startDispatchers();
        LegacySupport.init(ApplicationInfoImpl.getMidletInfo().getMidletAttributes(), this.isBackGroundStart());
        LegacySupport.createToolkit();
        this.mState = 4;
        this.mTaskQueue.addTask(new LifeCycleTask(1, 1));
        ApplicationUtilsImpl.releaseStartWaiterImpl(true);
    }

    private void verifyMIDletSuiteAuthenticity() {
        MidletInfo midletInfo = ApplicationInfoImpl.getMidletInfo();
        try {
            AuthenticationModule authenticationModule = AuthenticationModule.getInstance();
            AuthenticationStorageData securityStorageData = new AuthenticationStorageData(midletInfo.getProtectionDomainName(), midletInfo.getProtectionDomain(), midletInfo.getMidletHash(), midletInfo.getRootHash(), midletInfo.getClassPath());
            authenticationModule.verifyMIDletSuiteAuthenticity(midletInfo.getSuiteUid(), securityStorageData);
        }
        catch (RuntimeSecurityException rse) {
            RuntimeErrorDialog.showAuthenticationFailed(rse);
            throw new StartupException("Suite authentication failed.");
        }
    }

    private int getRecordedHeapSize() {
        String heapFile = ApplicationInfoImpl.getMidletInfo().getRootPath();
        heapFile = heapFile + "heap";
        InputStream fis = null;
        int heap = 0;
        String line = null;
        try {
            fis = new FileUtility(heapFile).openInputStream();
            LineReader lr = new LineReader(new InputStreamReader(fis));
            line = lr.readLine();
            heap = Integer.parseInt(line);
        }
        catch (NumberFormatException nfe) {
            Log.logE("Error reading heap file ", nfe);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            if (fis != null) {
                fis.close();
                fis = null;
            }
        }
        catch (IOException ioe) {
            Log.logE("getMonitoredHeapSize: error while closing file " + heapFile, ioe);
        }
        return heap;
    }

    private void setMidletInfo() {
        MidletInfo midletInfo = new MidletInfo();
        StorageAccessor.setMidletStartArguments(midletInfo, this.mMidletUid);
        StorageAccessor.setMidletAttributes(midletInfo);
        ApplicationInfoImpl.setMidletInfo(midletInfo);
    }

    private void startShutDownTimer() {
        if (this.mTimer == null) {
            this.mTimer = new Timer();
            this.mShutDownTimerTask = new ShutDownTimerTask();
            this.mTimer.schedule((TimerTask)this.mShutDownTimerTask, 5000L);
        } else {
            Log.logW("Shutdown timer already running");
        }
    }

    private void cancelShutDownTimer() {
        if (this.mTimer != null) {
            this.mTimer.cancel();
            this.mTimer = null;
            this.mShutDownTimerTask = null;
        }
    }

    private native void _setUid(String var1, int var2);

    private static native void _closeInd(int var0);

    private class ShutDownTimerTask
    extends TimerTask {
        private ShutDownTimerTask() {
        }

        public final void run() {
            try {
                MidletLifeCycle.this.mTaskQueue.addTask(new LifeCycleTask(2, 3));
            }
            catch (Throwable t) {
                Log.logE("Error in Timer! ", t);
            }
        }
    }
}

