/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.rt.midp;

import com.nokia.mj.impl.rt.midp.MidletInfo;
import com.nokia.mj.impl.storage.StorageAttribute;
import com.nokia.mj.impl.storage.StorageEntry;
import com.nokia.mj.impl.storage.StorageFactory;
import com.nokia.mj.impl.storage.StorageSession;
import com.nokia.mj.impl.utils.Uid;

final class StorageAccessor {
    private static StorageSession mSession;

    StorageAccessor() {
    }

    static void setMidletStartArguments(MidletInfo midletInfo, Uid midletUid) {
        midletInfo.setUid(midletUid);
        mSession = StorageFactory.createSession();
        mSession.open();
        StorageEntry midletEntry = mSession.readEntry("APPLICATION", midletInfo.getUid());
        midletInfo.setMainClass(midletEntry.getAttribute("MAIN_CLASS").getValue());
        midletInfo.setName(midletEntry.getAttribute("NAME").getValue());
        midletInfo.setSuiteUid(Uid.createUid(midletEntry.getAttribute("PACKAGE_ID").getValue()));
        StorageEntry midletSuiteEntry = mSession.readEntry("APPLICATION_PACKAGE", midletInfo.getSuiteUid());
        midletInfo.setSuiteName(midletSuiteEntry.getAttribute("PACKAGE_NAME").getValue());
        midletInfo.setVendor(midletSuiteEntry.getAttribute("VENDOR").getValue());
        midletInfo.setVersion(midletSuiteEntry.getAttribute("VERSION").getValue());
        midletInfo.setRootPath(midletSuiteEntry.getAttribute("ROOT_PATH").getValue());
        midletInfo.setClassPath(midletSuiteEntry.getAttribute("JAR_PATH").getValue());
        midletInfo.setDrm(midletSuiteEntry.getAttribute("CONTENT_INFO").getValue().equals("1"));
        StorageAttribute contentId = midletSuiteEntry.getAttribute("CONTENT_ID");
        if (contentId != null) {
            midletInfo.setContentId(contentId.getValue());
        }
        StorageEntry midletSuiteSpecificEntry = mSession.readEntry("MIDP_PACKAGE", midletInfo.getSuiteUid());
        midletInfo.setProtectionDomain(midletSuiteSpecificEntry.getAttribute("SECURITY_DOMAIN_CATEGORY").getValue());
        StorageAttribute hash = midletSuiteSpecificEntry.getAttribute("HASH");
        if (hash != null) {
            midletInfo.setMidletHash(hash.getValue());
        }
        midletInfo.setProtectionDomainName(midletSuiteSpecificEntry.getAttribute("SECURITY_DOMAIN").getValue());
        StorageAttribute rootHash = midletSuiteSpecificEntry.getAttribute("CERT_HASH");
        if (rootHash != null) {
            midletInfo.setRootHash(rootHash.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setMidletAttributes(MidletInfo midletInfo) {
        try {
            StorageEntry[] attributeEntries;
            if (mSession == null) {
                mSession = StorageFactory.createSession();
                mSession.open();
            }
            if ((attributeEntries = mSession.readEntries("APPLICATION_PACKAGE_ATTRIBUTES", midletInfo.getSuiteUid())) != null) {
                for (int i = 0; i < attributeEntries.length; ++i) {
                    StorageAttribute name = attributeEntries[i].getAttribute("NAME");
                    StorageAttribute value = attributeEntries[i].getAttribute("VALUE");
                    midletInfo.addAttribute(name.getValue(), value.getValue());
                }
            }
        }
        finally {
            if (mSession != null) {
                mSession.close();
                mSession.destroySession();
                mSession = null;
            }
        }
    }
}

