/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.rt.support;

import com.nokia.mj.impl.rt.support.JvmInternal;
import com.nokia.mj.impl.utils.Logger;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;

public abstract class Finalizer {
    private static boolean traceFinalizers;
    private static Hashtable references;
    static /* synthetic */ Class class$com$nokia$mj$impl$rt$support$Finalizer;

    public abstract void finalizeImpl();

    protected Finalizer() {
        this.debugFinalizeCreated();
    }

    protected final void finalize() {
        try {
            this.debugFinalize();
            this.finalizeImpl();
        }
        catch (Throwable t) {
            Logger.ELOG(6, "Exception caught in finalizer.", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void debugFinalizeCreated() {
        if (!(traceFinalizers || references != null)) {
            return;
        }
        String clazz = this.getClass().getName();
        if (traceFinalizers) {
            Logger.LOG(6, 4, "Finalizable created: " + clazz);
        }
        if (references != null) {
            Hashtable hashtable = references;
            synchronized (hashtable) {
                Refcount r = (Refcount)references.get(clazz);
                if (r != null) {
                    ++r.total;
                    ++r.count;
                    if (r.count > r.max) {
                        r.max = r.count;
                    }
                } else {
                    references.put(clazz, new Refcount(clazz));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void debugFinalize() {
        if (!(traceFinalizers || references != null)) {
            return;
        }
        String clazz = this.getClass().getName();
        if (traceFinalizers) {
            Logger.LOG(6, 4, "Finalizable destroyed: " + clazz);
        }
        if (references != null) {
            Hashtable hashtable = references;
            synchronized (hashtable) {
                Refcount r = (Refcount)references.get(clazz);
                --r.count;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        JvmInternal.enableFinalization(class$com$nokia$mj$impl$rt$support$Finalizer == null ? (class$com$nokia$mj$impl$rt$support$Finalizer = Finalizer.class$("com.nokia.mj.impl.rt.support.Finalizer")) : class$com$nokia$mj$impl$rt$support$Finalizer);
        traceFinalizers = false;
        String s = System.getProperty("com.nokia.mj.impl.rt.support.FinalizerDump");
        if (s != null) {
            int delay = 60;
            try {
                delay = Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            Logger.LOG(6, 4, "Finalizer debug will dump finalize classes every " + delay + " seconds");
            references = new Hashtable();
            new Timer().schedule((TimerTask)new DumpReferred(), 1000 * delay, (long)(1000 * delay));
        }
        if ((s = System.getProperty("com.nokia.mj.impl.rt.support.FinalizerTrace")) != null) {
            Logger.LOG(6, 4, "Finalizer debug will trace each allocation/free");
            traceFinalizers = true;
        }
    }

    private static class DumpReferred
    extends TimerTask {
        private static StringBuffer sb = new StringBuffer();

        private DumpReferred() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            System.gc();
            JvmInternal.runFinalization();
            Hashtable hashtable = references;
            synchronized (hashtable) {
                sb.append("Finalizable objects\n");
                Enumeration e = references.elements();
                while (e.hasMoreElements()) {
                    Refcount r = (Refcount)e.nextElement();
                    if (r == null) continue;
                    sb.append(" count=" + r.count + " max=" + r.max + " total=" + r.total + " class=" + r.clazz + "\n");
                }
            }
            Logger.LOG(6, 4, sb.toString());
            sb.setLength(0);
        }
    }

    private static class Refcount {
        int total = 1;
        int count = 1;
        int max = 1;
        String clazz;

        private Refcount(String c) {
            this.clazz = c;
        }
    }
}

