/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.security;

import com.nokia.mj.impl.rt.support.Finalizer;
import com.nokia.mj.impl.rt.support.Jvm;
import com.nokia.mj.impl.utils.Logger;
import java.security.DigestException;
import java.security.NoSuchAlgorithmException;

public class MessageDigestImpl {
    private final int iHandle;
    private Finalizer iFinalizer;

    public MessageDigestImpl(String aAlgorithm) throws NoSuchAlgorithmException {
        Logger.LOG(23, 4, "+ MessageDigestImpl::MessageDigestImpl");
        String algorithm = aAlgorithm.toUpperCase();
        if (algorithm.equals("SHA-1") || algorithm.equals("MD2") || algorithm.equals("MD5")) {
            this.iHandle = MessageDigestImpl._create(aAlgorithm.toUpperCase());
            if (this.iHandle <= 0 && this.iHandle == -4) {
                throw new NoSuchAlgorithmException("Failed to create MessageDigest for algorithm: " + aAlgorithm);
            }
        } else {
            throw new NoSuchAlgorithmException("Unsupported algorithm: " + aAlgorithm);
        }
        this.iFinalizer = this.registerForFinalization();
        Logger.LOG(23, 4, "-- MessageDigestImpl::MessageDigestImpl");
    }

    private Finalizer registerForFinalization() {
        return new Finalizer(){

            public void finalizeImpl() {
                MessageDigestImpl.this.doFinalize();
            }
        };
    }

    void doFinalize() {
        if (this.iFinalizer == null) {
            return;
        }
        this.iFinalizer = null;
        MessageDigestImpl._dispose(this.iHandle);
    }

    public int digest(byte[] aBuf, int aOffset, int aLength) throws DigestException {
        Logger.LOG(23, 4, "+ MessageDigestImpl::digest");
        if (aBuf == null) {
            throw new DigestException("Digest method failed: buffer is null");
        }
        if (aBuf.length < aOffset + aLength && aBuf.length <= aOffset) {
            throw new IllegalArgumentException("Digest method failed: output buffer out of bounds");
        }
        if (aOffset < 0 || aLength < 0) {
            throw new IllegalArgumentException("Digest method failed: offset or length is negative");
        }
        int retVal = MessageDigestImpl._digest(this.iHandle, aBuf, aOffset, aLength);
        if (retVal < 0 && retVal == -4) {
            throw new DigestException("Digest method failed: cannot allocate memory");
        }
        Logger.LOG(23, 4, "-- MessageDigestImpl::digest");
        return retVal;
    }

    public void reset() {
        Logger.LOG(23, 4, "+ MessageDigestImpl::reset");
        if (MessageDigestImpl._reset(this.iHandle) < 0) {
            throw new OutOfMemoryError("Internal error");
        }
    }

    public void update(byte[] aInput, int aOffset, int aLength) {
        Logger.LOG(23, 4, "+ MessageDigestImpl::update");
        if (aLength == 0) {
            return;
        }
        if (aInput.length < aOffset + aLength && aInput.length <= aOffset) {
            throw new IllegalArgumentException("Update method failed: input array out of bounds.");
        }
        if (aOffset < 0 || aLength < 0) {
            throw new IllegalArgumentException("Update method failed: offset or length is negative.");
        }
        int err = MessageDigestImpl._update(this.iHandle, aInput, aOffset, aLength);
        if (err < 0 && err == -4) {
            throw new IllegalArgumentException("Update method failed: cannot allocate memory");
        }
    }

    private static native int _create(String var0);

    private static native int _update(int var0, byte[] var1, int var2, int var3);

    private static native int _digest(int var0, byte[] var1, int var2, int var3);

    private static native int _reset(int var0);

    private static native void _dispose(int var0);

    static {
        try {
            Jvm.loadSystemLibrary("javasatsa");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

