/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.security.common;

import java.util.Calendar;
import java.util.Date;

public class Certificate {
    private String issuer = null;
    private String subject = null;
    private String organization = null;
    private String notBefore = null;
    private String notAfter = null;
    private String serialNumber = null;
    private String fingerprint = null;

    public Certificate(String issuer, String subject, String organization, String notBefore, String notAfter, String serialNumber, String fingerprint) {
        this.issuer = issuer;
        this.subject = subject;
        this.organization = organization;
        this.notBefore = notBefore;
        this.notAfter = notAfter;
        this.serialNumber = serialNumber;
        this.fingerprint = fingerprint;
    }

    public Certificate(Certificate otherCert) {
        if (otherCert != null) {
            this.issuer = otherCert.getIssuer();
            this.subject = otherCert.getSubject();
            this.organization = otherCert.getOrganization();
            this.notBefore = otherCert.getNotBefore();
            this.notAfter = otherCert.getNotAfter();
            this.serialNumber = otherCert.getSerialNumber();
            this.fingerprint = otherCert.getFingerprint();
        }
    }

    public String getIssuer() {
        return this.issuer;
    }

    public Date getValidFrom() {
        return this.str2Date(this.notBefore);
    }

    public Date getValidUntil() {
        return this.str2Date(this.notAfter);
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getNotAfter() {
        return this.notAfter;
    }

    public String getNotBefore() {
        return this.notBefore;
    }

    public String getFormattedFingerprint() {
        if (this.fingerprint == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.fingerprint.length(); ++i) {
            sb.append(this.fingerprint.charAt(i));
            if ((i + 1) % 4 != 0) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    public String getFormattedIssuer() {
        return this.formatDN(this.getIssuer());
    }

    public String getFormattedSubject() {
        return this.formatDN(this.getSubject());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nIssuer:").append(this.getIssuer()).append("\nSubject:").append(this.getSubject()).append("\nOrganization:").append(this.getOrganization()).append("\nValidFrom:").append(this.getNotBefore()).append("\nValidUntil:").append(this.getNotAfter()).append("\nSerialNumber:").append(this.getSerialNumber()).append("\nFingerprint:").append(this.getFingerprint());
        return sb.toString();
    }

    private Date str2Date(String str) {
        if (str != null && str.length() == 14) {
            try {
                Calendar cal = Calendar.getInstance();
                cal.set(1, Integer.parseInt(str.substring(0, 4)));
                cal.set(2, Integer.parseInt(str.substring(4, 6)));
                cal.set(7, Integer.parseInt(str.substring(6, 8)));
                cal.set(10, Integer.parseInt(str.substring(8, 10)));
                cal.set(12, Integer.parseInt(str.substring(10, 12)));
                cal.set(13, Integer.parseInt(str.substring(12, 14)));
                return cal.getTime();
            }
            catch (NumberFormatException e) {
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return null;
    }

    private String formatDN(String DN) {
        if (DN != null) {
            StringBuffer buf = new StringBuffer();
            String tmp = this.getToken(DN, "/CN=");
            if (tmp != null) {
                buf.append(tmp);
            }
            if ((tmp = this.getToken(DN, "/O=")) != null) {
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                buf.append(tmp);
            }
            if ((tmp = this.getToken(DN, "/OU=")) != null) {
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                buf.append(tmp);
            }
            if ((tmp = this.getToken(DN, "/C=")) != null) {
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                buf.append(tmp);
            }
            if ((tmp = this.getToken(DN, "/ST=")) != null) {
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                buf.append(tmp);
            }
            if ((tmp = this.getToken(DN, "/L=")) != null) {
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                buf.append(tmp);
            }
            return buf.toString();
        }
        return null;
    }

    private String getToken(String str, String sep) {
        int startIndex = str.indexOf(sep);
        if (startIndex != -1) {
            int endIndex = str.indexOf("/", startIndex += sep.length());
            if (endIndex == -1) {
                endIndex = str.length();
            }
            return str.substring(startIndex, endIndex);
        }
        return null;
    }
}

