/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.security.midp.authorization;

import com.nokia.mj.impl.security.common.PermissionBase;
import com.nokia.mj.impl.security.midp.authorization.ClassInstantiator;
import com.nokia.mj.impl.security.midp.common.PermissionAttribute;
import com.nokia.mj.impl.security.midp.common.PolicyBasedPermission;
import com.nokia.mj.impl.security.midp.common.PolicyBasedPermissionImpl;
import com.nokia.mj.impl.security.midp.common.UserSecuritySettings;
import com.nokia.mj.impl.security.midp.storage.SecurityStorage;
import com.nokia.mj.impl.security.utils.Logger;
import com.nokia.mj.impl.storage.StorageSession;
import com.nokia.mj.impl.utils.Tokenizer;
import com.nokia.mj.impl.utils.Uid;
import com.nokia.mj.impl.utils.exception.InvalidAttributeException;
import java.security.Permission;
import java.util.Hashtable;
import java.util.Vector;

public final class PermissionResolver {
    private static Hashtable policyPermissionInstances = new Hashtable();
    private static Hashtable grantedPermissionInstances = new Hashtable();

    public static Vector resolvePermissions(Uid msUID, PermissionAttribute[] requestedPermissions, PolicyBasedPermission[] policyPermissions) {
        if (requestedPermissions == null) {
            return null;
        }
        Vector resolvedPermissions = new Vector();
        for (int i = 0; i < requestedPermissions.length; ++i) {
            if (requestedPermissions[i].isLegacyAttribute()) {
                Vector legacyPermissions = PermissionResolver.resolveLegacyPermission(requestedPermissions[i], policyPermissions);
                if (legacyPermissions != null && legacyPermissions.size() > 0) {
                    for (int j = 0; j < legacyPermissions.size(); ++j) {
                        resolvedPermissions.addElement(legacyPermissions.elementAt(j));
                    }
                    continue;
                }
                if (requestedPermissions[i].getImportance() != 1) continue;
                Logger.logError("Permission " + requestedPermissions[i].getName() + " not supported");
                throw new InvalidAttributeException(3, null, 6, new String[]{requestedPermissions[i].getAttributeName()}, 910);
            }
            try {
                Permission p = (Permission)ClassInstantiator.newInstance(requestedPermissions[i].getName(), requestedPermissions[i].getTarget(), requestedPermissions[i].getActionList());
                Vector resolvedPermissionSet = PermissionResolver.resolvePermission(msUID, p, policyPermissions);
                if (resolvedPermissionSet != null) {
                    if (PermissionResolver.identicalSettings(resolvedPermissionSet)) {
                        PolicyBasedPermission rPerm = (PolicyBasedPermission)resolvedPermissionSet.elementAt(0);
                        if (rPerm.getUserSecuritySettings() == null) {
                            resolvedPermissions.addElement(new PolicyBasedPermissionImpl(requestedPermissions[i].getName(), requestedPermissions[i].getTarget(), requestedPermissions[i].getActionList(), rPerm.getType()));
                            continue;
                        }
                        resolvedPermissions.addElement(new PolicyBasedPermissionImpl(requestedPermissions[i].getName(), requestedPermissions[i].getTarget(), requestedPermissions[i].getActionList(), rPerm.getUserSecuritySettings()));
                        continue;
                    }
                    for (int j = 0; j < resolvedPermissionSet.size(); ++j) {
                        resolvedPermissions.addElement(resolvedPermissionSet.elementAt(j));
                    }
                    continue;
                }
                if (requestedPermissions[i].getImportance() != 1) continue;
                Logger.logError("Permission " + requestedPermissions[i].getName() + " not supported");
                throw new InvalidAttributeException(3, null, 6, new String[]{requestedPermissions[i].getAttributeName()}, 910);
            }
            catch (InstantiationException e) {
                if (requestedPermissions[i].getImportance() != 1) continue;
                Logger.logError("Permission " + requestedPermissions[i].getName() + " not supported");
                throw new InvalidAttributeException(3, null, 6, new String[]{requestedPermissions[i].getAttributeName()}, 910);
            }
        }
        if (resolvedPermissions.size() == 0) {
            return null;
        }
        return resolvedPermissions;
    }

    public static Vector resolvePermission(StorageSession aStorageSession, Uid msUID, Permission requestedPermission) {
        return PermissionResolver.resolvePermission(requestedPermission, PermissionResolver.getGrantedPermissionInstances(aStorageSession, msUID));
    }

    static void settingsChanged(Uid msUID, UserSecuritySettings newSettings) {
        Vector oldPermissionInstancesAndSettings = (Vector)grantedPermissionInstances.remove(msUID);
        if (oldPermissionInstancesAndSettings != null) {
            Vector newPermissionInstancesAndSettings = new Vector();
            for (int i = 0; i < oldPermissionInstancesAndSettings.size(); ++i) {
                PermisionInstanceAndSettings p = (PermisionInstanceAndSettings)oldPermissionInstancesAndSettings.elementAt(i);
                if (p.getSettings() != null && p.getSettings().getName().equals(newSettings.getName())) {
                    newPermissionInstancesAndSettings.addElement(new PermisionInstanceAndSettings(p.getPermissionInstance(), newSettings));
                    continue;
                }
                newPermissionInstancesAndSettings.addElement(p);
            }
            grantedPermissionInstances.put(msUID, newPermissionInstancesAndSettings);
        }
    }

    public static void testClearCache() {
        policyPermissionInstances.clear();
        grantedPermissionInstances.clear();
    }

    private static Vector resolvePermission(Permission requestedPermission, Vector permissionInstances) {
        if (permissionInstances == null || requestedPermission == null) {
            return null;
        }
        Vector resolvedPermissions = new Vector();
        for (int i = 0; i < permissionInstances.size(); ++i) {
            PermisionInstanceAndSettings p = (PermisionInstanceAndSettings)permissionInstances.elementAt(i);
            Object policyPermission = p.getPermissionInstance();
            if (!((Permission)policyPermission).implies(requestedPermission)) continue;
            resolvedPermissions.addElement(PermissionResolver.getResolvedPermission(requestedPermission, policyPermission, p.getSettings(), requestedPermission.getClass().getName(), requestedPermission.getName(), requestedPermission.getActions()));
            return resolvedPermissions;
        }
        String[] actions = Tokenizer.split(requestedPermission.getActions(), ",");
        if (actions != null && actions.length > 0) {
            for (int i = 0; i < actions.length; ++i) {
                boolean permissionResolved = false;
                try {
                    Permission p1 = (Permission)ClassInstantiator.newInstance(requestedPermission.getClass().getName(), requestedPermission.getName(), actions[i]);
                    for (int j = 0; j < permissionInstances.size(); ++j) {
                        PermisionInstanceAndSettings p = (PermisionInstanceAndSettings)permissionInstances.elementAt(j);
                        Object policyPermission = p.getPermissionInstance();
                        if (!((Permission)policyPermission).implies(p1)) continue;
                        permissionResolved = true;
                        PolicyBasedPermissionImpl permission1 = PermissionResolver.getResolvedPermission(requestedPermission, policyPermission, p.getSettings(), requestedPermission.getClass().getName(), requestedPermission.getName(), actions[i]);
                        if (permission1.getActionList() == null || permission1.getActionList().length() == 0) {
                            resolvedPermissions.addElement(permission1);
                            continue;
                        }
                        UserSecuritySettings settings1 = permission1.getUserSecuritySettings();
                        boolean found = false;
                        for (int k = 0; k < resolvedPermissions.size(); ++k) {
                            PolicyBasedPermissionImpl permission2 = (PolicyBasedPermissionImpl)resolvedPermissions.elementAt(k);
                            if (permission2.getActionList() == null || permission2.getActionList().length() <= 0) continue;
                            UserSecuritySettings settings2 = permission2.getUserSecuritySettings();
                            if (!permission1.getClass().getName().equals(permission2.getClass().getName()) || (permission1.getName() == null || permission2.getName() == null || !permission1.getName().equals(permission2.getName())) && (permission1.getName() != null || permission2.getName() != null) || (settings1 == null || settings2 == null || !settings1.equals(settings2)) && (settings1 != null || settings2 != null)) continue;
                            resolvedPermissions.setElementAt(PermissionResolver.getResolvedPermission(permission1.getPromptDetails(), p.getSettings(), requestedPermission.getClass().getName(), requestedPermission.getName(), permission2.getActionList() + "," + permission1.getActionList()), k);
                            found = true;
                            break;
                        }
                        if (!found) {
                            resolvedPermissions.addElement(permission1);
                        }
                        break;
                    }
                }
                catch (InstantiationException e) {
                    // empty catch block
                }
                if (permissionResolved) continue;
                resolvedPermissions.removeAllElements();
                break;
            }
            if (resolvedPermissions.size() > 0) {
                return resolvedPermissions;
            }
        }
        Vector tmp = new Vector();
        for (int i = 0; i < permissionInstances.size(); ++i) {
            tmp.addElement(permissionInstances.elementAt(i));
        }
        while (tmp.size() > 0) {
            PermisionInstanceAndSettings instance1 = (PermisionInstanceAndSettings)tmp.elementAt(0);
            tmp.removeElementAt(0);
            Permission permission1 = (Permission)instance1.getPermissionInstance();
            UserSecuritySettings settings1 = instance1.getSettings();
            String compositeAction = "";
            Vector uniqueActions = new Vector();
            int i = 0;
            while (i < tmp.size()) {
                PermisionInstanceAndSettings instance2 = (PermisionInstanceAndSettings)tmp.elementAt(i);
                Permission permission2 = (Permission)instance2.getPermissionInstance();
                UserSecuritySettings settings2 = instance2.getSettings();
                if (permission1.getClass().getName().equals(permission2.getClass().getName()) && (permission1.getName() != null && permission2.getName() != null && permission1.getName().equals(permission2.getName()) || permission1.getName() == null && permission2.getName() == null) && (settings1 != null && settings2 != null && settings1.equals(settings2) || settings1 == null && settings2 == null)) {
                    tmp.removeElementAt(i);
                    if (permission1.getActions() != null && permission1.getActions().length() > 0 && !uniqueActions.contains(permission1.getActions())) {
                        if (compositeAction.length() > 0) {
                            compositeAction = compositeAction + ",";
                        }
                        compositeAction = compositeAction + permission1.getActions();
                        uniqueActions.addElement(permission1.getActions());
                    }
                    if (permission2.getActions() == null || permission2.getActions().length() <= 0 || uniqueActions.contains(permission2.getActions())) continue;
                    if (compositeAction.length() > 0) {
                        compositeAction = compositeAction + ",";
                    }
                    compositeAction = compositeAction + permission2.getActions();
                    uniqueActions.addElement(permission2.getActions());
                    continue;
                }
                ++i;
            }
            if (compositeAction.length() <= 0 || compositeAction.indexOf(44) == -1) continue;
            try {
                Permission perm = (Permission)ClassInstantiator.newInstance(permission1.getClass().getName(), permission1.getName(), compositeAction);
                if (!perm.implies(requestedPermission)) continue;
                resolvedPermissions.addElement(PermissionResolver.getResolvedPermission(requestedPermission, permission1, settings1, requestedPermission.getClass().getName(), requestedPermission.getName(), requestedPermission.getActions()));
                return resolvedPermissions;
            }
            catch (InstantiationException ex) {
            }
        }
        if (resolvedPermissions.size() == 0) {
            return null;
        }
        return resolvedPermissions;
    }

    private static Vector resolvePermission(Uid msUID, Permission requestedPermission, PolicyBasedPermission[] policyPermissions) {
        Vector permissionInstances = PermissionResolver.getPolicyPermissionInstances(msUID, policyPermissions);
        return PermissionResolver.resolvePermission(requestedPermission, permissionInstances);
    }

    private static PolicyBasedPermissionImpl getResolvedPermission(PermissionBase securityPromptDetails, UserSecuritySettings userSettings, String permissionName, String targetName, String actionList) {
        PermissionBase securityPromptDetails2 = securityPromptDetails;
        if (!(securityPromptDetails == null || PermissionBase.matchActions(securityPromptDetails.getActions(), actionList) && PermissionBase.matchActions(actionList, securityPromptDetails.getActions()))) {
            try {
                securityPromptDetails2 = (PermissionBase)ClassInstantiator.newInstance(securityPromptDetails.getClass().getName(), securityPromptDetails.getName(), actionList);
            }
            catch (InstantiationException e2) {
                // empty catch block
            }
        }
        return new PolicyBasedPermissionImpl(permissionName, targetName, actionList, userSettings, securityPromptDetails2);
    }

    private static PolicyBasedPermissionImpl getResolvedPermission(Permission requestedPermission, Object policyPermission, UserSecuritySettings userSettings, String permissionName, String targetName, String actionList) {
        PermissionBase securityPromptDetails = null;
        if (requestedPermission instanceof PermissionBase) {
            securityPromptDetails = (PermissionBase)requestedPermission;
        } else if (policyPermission instanceof PermissionBase) {
            try {
                securityPromptDetails = (PermissionBase)ClassInstantiator.newInstance(policyPermission.getClass().getName(), requestedPermission.getName(), requestedPermission.getActions());
            }
            catch (InstantiationException e2) {
                // empty catch block
            }
        }
        return new PolicyBasedPermissionImpl(permissionName, targetName, actionList, userSettings, securityPromptDetails);
    }

    private static Vector getPolicyPermissionInstances(Uid msUID, PolicyBasedPermission[] policyPermissions) {
        Vector policyPermissionInstancesAndSettings = (Vector)policyPermissionInstances.get(msUID);
        if (policyPermissionInstancesAndSettings != null) {
            return policyPermissionInstancesAndSettings;
        }
        policyPermissionInstancesAndSettings = new Vector();
        if (policyPermissions == null) {
            return null;
        }
        for (int i = 0; i < policyPermissions.length; ++i) {
            try {
                Object p = ClassInstantiator.newInstance(policyPermissions[i].getName(), policyPermissions[i].getTarget(), policyPermissions[i].getActionList());
                policyPermissionInstancesAndSettings.addElement(new PermisionInstanceAndSettings(p, policyPermissions[i].getUserSecuritySettings()));
                continue;
            }
            catch (InstantiationException e) {
                // empty catch block
            }
        }
        policyPermissionInstances.put(msUID, policyPermissionInstancesAndSettings);
        return policyPermissionInstancesAndSettings;
    }

    private static Vector getGrantedPermissionInstances(StorageSession aStorageSession, Uid msUID) {
        Vector grantedPermissionInstancesAndSettings = (Vector)grantedPermissionInstances.get(msUID);
        if (grantedPermissionInstancesAndSettings != null) {
            return grantedPermissionInstancesAndSettings;
        }
        grantedPermissionInstancesAndSettings = new Vector();
        SecurityStorage storage = new SecurityStorage(aStorageSession);
        Vector grantedPermissions = storage.readGrantedPermissions(msUID);
        if (grantedPermissions == null) {
            return null;
        }
        for (int i = 0; i < grantedPermissions.size(); ++i) {
            try {
                PolicyBasedPermission grantedPermission = (PolicyBasedPermission)grantedPermissions.elementAt(i);
                Object p = ClassInstantiator.newInstance(grantedPermission.getName(), grantedPermission.getTarget(), grantedPermission.getActionList());
                grantedPermissionInstancesAndSettings.addElement(new PermisionInstanceAndSettings(p, grantedPermission.getUserSecuritySettings()));
                continue;
            }
            catch (InstantiationException e) {
                // empty catch block
            }
        }
        grantedPermissionInstances.put(msUID, grantedPermissionInstancesAndSettings);
        return grantedPermissionInstancesAndSettings;
    }

    private static boolean identicalSettings(Vector permissions) {
        UserSecuritySettings settings = ((PolicyBasedPermission)permissions.elementAt(0)).getUserSecuritySettings();
        for (int i = 1; i < permissions.size(); ++i) {
            PolicyBasedPermission p = (PolicyBasedPermission)permissions.elementAt(i);
            if ((settings != null || p.getUserSecuritySettings() == null) && settings.equals(p.getUserSecuritySettings())) continue;
            return false;
        }
        return true;
    }

    private static Vector resolveLegacyPermission(PermissionAttribute legacyPermission, PolicyBasedPermission[] policyPermissions) {
        if (policyPermissions == null) {
            return null;
        }
        Vector resolvedPermissions = new Vector();
        if (legacyPermission.getName() == null) {
            if (policyPermissions == null) {
                return null;
            }
            resolvedPermissions = new Vector();
            for (int i = 0; i < policyPermissions.length; ++i) {
                resolvedPermissions.addElement(new PolicyBasedPermissionImpl(policyPermissions[i].getName(), policyPermissions[i].getTarget(), policyPermissions[i].getActionList(), policyPermissions[i].getUserSecuritySettings()));
            }
        } else {
            for (int i = 0; i < policyPermissions.length; ++i) {
                String target;
                if (!legacyPermission.getName().equals(policyPermissions[i].getName()) || (target = legacyPermission.getTarget()) != null && target.indexOf("*") == -1 && !target.equals(policyPermissions[i].getTarget())) continue;
                String actionList = legacyPermission.getActionList();
                if (actionList == null) {
                    resolvedPermissions.addElement(new PolicyBasedPermissionImpl(policyPermissions[i].getName(), policyPermissions[i].getTarget(), policyPermissions[i].getActionList(), policyPermissions[i].getUserSecuritySettings()));
                    continue;
                }
                if (!PermissionBase.matchActions(actionList, policyPermissions[i].getActionList())) continue;
                resolvedPermissions.addElement(new PolicyBasedPermissionImpl(policyPermissions[i].getName(), policyPermissions[i].getTarget(), actionList, policyPermissions[i].getUserSecuritySettings()));
            }
        }
        return resolvedPermissions;
    }

    private static class PermisionInstanceAndSettings {
        private Object permissionObject;
        private UserSecuritySettings settings;

        public PermisionInstanceAndSettings(Object permissionObject, UserSecuritySettings settings) {
            this.permissionObject = permissionObject;
            this.settings = settings;
        }

        public Object getPermissionInstance() {
            return this.permissionObject;
        }

        public UserSecuritySettings getSettings() {
            return this.settings;
        }
    }
}

