/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.security.midp.common;

import com.nokia.mj.impl.security.midp.common.AuthenticationInfo;
import com.nokia.mj.impl.utils.Base64;
import com.nokia.mj.impl.utils.exception.InvalidAttributeException;

public class AuthenticationAttribute
extends AuthenticationInfo {
    public static final String MAIN_ATTRIBUTE_PREFIX = "MIDlet-Certificate-";
    public static final String SECOND_ATTRIBUTE_PREFIX = "MIDlet-Jar-RSA-SHA1-";
    public static final String SECOND_LEGACY_ATTRIBUTE_NAME = "MIDlet-Jar-RSA-SHA1";

    AuthenticationAttribute(String mainAttrName, String[] mainAttrValue, String secondAttrName, String secondAttrValue) {
        this(mainAttrName, mainAttrValue, secondAttrName, secondAttrValue, false);
    }

    AuthenticationAttribute(String mainAttrName, String[] mainAttrValue, String secondAttrName, String secondAttrValue, boolean skipSecondAttrValidation) {
        if (mainAttrValue == null) {
            if (secondAttrValue != null) {
                throw new InvalidAttributeException(3, null, 4, new String[]{mainAttrName + 1}, 909);
            }
            return;
        }
        String[] cChain = new String[mainAttrValue.length];
        for (int i = 0; i < mainAttrValue.length; ++i) {
            cChain[i] = mainAttrValue[i];
            if (Base64.decode(cChain[i]) != null) continue;
            throw new InvalidAttributeException(3, null, 7, new String[]{mainAttrName + (i + 1)}, 909);
        }
        this.certChain = cChain;
        if (secondAttrValue == null) {
            throw new InvalidAttributeException(3, null, 4, new String[]{secondAttrName}, 909);
        }
        if (!skipSecondAttrValidation && Base64.decode(secondAttrValue) == null) {
            throw new InvalidAttributeException(3, null, 7, new String[]{secondAttrName}, 909);
        }
        this.signature = secondAttrValue;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Cert chain:");
        if (this.certChain != null) {
            for (int i = 0; i < this.certChain.length; ++i) {
                sb.append(" chain[" + (i + 1) + "]:" + this.certChain[i]);
            }
        } else {
            sb.append("null");
        }
        sb.append("\n Signature:");
        if (this.signature != null) {
            sb.append(" " + this.signature);
        } else {
            sb.append("null");
        }
        return sb.toString();
    }
}

