/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.security.utils;

import com.nokia.mj.impl.security.midp.authentication.AuthenticationException;
import com.nokia.mj.impl.security.midp.authentication.Credentials;
import com.nokia.mj.impl.security.midp.common.PolicyBasedPermissionImpl;
import com.nokia.mj.impl.security.midp.storage.AuthenticationStorageData;
import java.util.Vector;

public class Logger {
    private static final int SECURITY_LOG_ID = 20;
    private static boolean logEnabled = false;

    public static void log(String aMsg) {
        if (!logEnabled) {
            return;
        }
        Logger.log(aMsg, 4);
    }

    public static void logError(String aMsg) {
        if (!logEnabled) {
            return;
        }
        Logger.log(aMsg, 1);
    }

    public static void logWarning(String aMsg) {
        if (!logEnabled) {
            return;
        }
        Logger.log(aMsg, 2);
    }

    public static void log(Exception aExc) {
        if (!logEnabled) {
            return;
        }
        if (aExc instanceof AuthenticationException) {
            Logger.logAuthenticationException((AuthenticationException)aExc);
        } else {
            Logger.logWarning(aExc.getMessage());
        }
    }

    public static void logOcspResponse(int aOcspSummaryResponse, int[] aOcspIndividualResponses) {
        if (!logEnabled) {
            return;
        }
        StringBuffer logMsg = new StringBuffer();
        logMsg.append("Ocsp response = ");
        logMsg.append(" summary:");
        switch (aOcspSummaryResponse) {
            case 1: {
                logMsg.append("GOOD");
                break;
            }
            case 3: 
            case 4: {
                logMsg.append("UNKNOWN");
                break;
            }
            case 2: {
                logMsg.append("REVOKED");
            }
        }
        logMsg.append(" individual responses:");
        if (aOcspIndividualResponses != null && aOcspIndividualResponses.length > 0) {
            for (int i = 0; i < aOcspIndividualResponses.length; ++i) {
                switch (aOcspIndividualResponses[i]) {
                    case 1: {
                        logMsg.append("GOOD");
                        break;
                    }
                    case 3: {
                        logMsg.append("UNKNOWN");
                        break;
                    }
                    case 2: {
                        logMsg.append("REVOKED");
                        break;
                    }
                    case 4: {
                        logMsg.append("CANNOT_OBTAIN_CERT_STATUS");
                        break;
                    }
                    case 5: {
                        logMsg.append("INVALID_REVOCATION_SERVER_URI");
                        break;
                    }
                    case 6: {
                        logMsg.append("SIGNATURE_VALIDATION_FAILURE");
                        break;
                    }
                    case 7: {
                        logMsg.append("INVALID_REVOCATION_SERVER_RESPONSE");
                        break;
                    }
                    case 8: {
                        logMsg.append("RESPONSE_MISSING_NONCE");
                        break;
                    }
                    case 9: {
                        logMsg.append("INVALID_CERT_STATUS_INFO");
                    }
                }
                if (i >= aOcspIndividualResponses.length - 1) continue;
                logMsg.append(",");
            }
        } else {
            logMsg.append("NULL");
        }
        Logger.log(logMsg.toString());
    }

    public static void logAuthenticationCredentials(Vector aAuthCredentials) {
        if (!logEnabled) {
            return;
        }
        StringBuffer logMsg = new StringBuffer();
        logMsg.append("Authentication credentials:");
        if (aAuthCredentials != null) {
            for (int i = 0; i < aAuthCredentials.size(); ++i) {
                Credentials authCredentials = (Credentials)aAuthCredentials.elementAt(i);
                logMsg.append(authCredentials);
            }
        } else {
            logMsg.append("NULL");
        }
        Logger.log(logMsg.toString());
    }

    public static void logAuthenticationData(AuthenticationStorageData aAuthData) {
        if (!logEnabled) {
            return;
        }
        StringBuffer logMsg = new StringBuffer();
        logMsg.append("Authentication data:");
        if (aAuthData != null) {
            logMsg.append(aAuthData.toString());
        } else {
            logMsg.append("NULL");
        }
        Logger.log(logMsg.toString());
    }

    public static void logGrantedPermissions(Vector aGrantedPermissions) {
        if (!logEnabled) {
            return;
        }
        StringBuffer logMsg = new StringBuffer();
        logMsg.append("Granted permissions:");
        if (aGrantedPermissions != null) {
            for (int i = 0; i < aGrantedPermissions.size(); ++i) {
                PolicyBasedPermissionImpl permission = (PolicyBasedPermissionImpl)aGrantedPermissions.elementAt(i);
                logMsg.append(permission.toString());
            }
        } else {
            logMsg.append("NULL");
        }
        Logger.log(logMsg.toString());
    }

    public static void logBlanketPermissions(String[] aBlanketPermissions) {
        if (!logEnabled) {
            return;
        }
        StringBuffer logMsg = new StringBuffer();
        logMsg.append("Blanket permissions = ");
        if (aBlanketPermissions != null) {
            for (int i = 0; i < aBlanketPermissions.length; ++i) {
                logMsg.append(aBlanketPermissions[i]);
                if (i >= aBlanketPermissions.length - 1) continue;
                logMsg.append(",");
            }
        } else {
            logMsg.append("NULL");
        }
        Logger.log(logMsg.toString());
    }

    private static void logAuthenticationException(AuthenticationException aExc) {
        String logMsg = "Authentication failed because ";
        switch (aExc.getErrorCode()) {
            case 1: {
                logMsg = logMsg + "the connection to JavaCaptain could not be established";
                break;
            }
            case 2: {
                logMsg = logMsg + "sending a comms message to JavaCertStore failed";
                break;
            }
            case 3: {
                logMsg = logMsg + "the signing certificate chain validation failed";
                break;
            }
            case 7: {
                logMsg = logMsg + "the signing certificate is not yet valid";
                break;
            }
            case 8: {
                logMsg = logMsg + "the signing certificate is expired";
                break;
            }
            case 9: {
                logMsg = logMsg + "the signing certificate chain includes the root certificate";
                break;
            }
            case 5: {
                logMsg = logMsg + "the signing certificate chain does not point to a trusted root";
                break;
            }
            case 4: {
                logMsg = logMsg + "the signature verification failed";
                break;
            }
            case 6: {
                logMsg = logMsg + "the root certificate is not mapped to any protection domain";
                break;
            }
            default: {
                logMsg = logMsg + "of an unknown reason";
            }
        }
        Logger.logWarning(logMsg);
    }

    private static void log(String aMsg, int logLevel) {
        com.nokia.mj.impl.utils.Logger.LOG(20, logLevel, aMsg);
    }

    static {
        logEnabled = com.nokia.mj.impl.utils.Logger.Activated[20];
    }
}

