/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.sensor;

import com.nokia.mj.impl.rt.support.Finalizer;
import com.nokia.mj.impl.rt.support.Jvm;
import com.nokia.mj.impl.sensor.SensorInfoImpl;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.sensor.SensorInfo;
import javax.microedition.sensor.SensorListener;

public class SensorManagerImpl {
    static boolean isDebug;
    private static final SensorInfoImpl[] NO_INFOS;
    private static final char[] RESERVED;
    private static final String SCHEME_CONTEXT = "contextType";
    private static final String SCHEME_LOCATION = "location";
    private static final String SCHEME_MODEL = "model";
    private static final String SCHEME_QUERY_SEP = "?";
    private static final String SCHEME_SENSOR = "sensor:";
    private static final char SCHEME_COLON = ':';
    private static final char SCHEME_SEMICOLON = ';';
    private static final char SCHEME_EQUALS = '=';
    private static final String INVALID_URL_PREFIX = "Invalid URL: ";
    private static SensorManagerImpl _instance;
    private Vector sensorListeners = new Vector();
    int sSensorConnectionList;
    private SensorInfo[] iSensorInfos;
    private Finalizer iFinalizer = this.registerForFinalization();

    private SensorManagerImpl() {
        Vector sensorIdentifiers = new Vector();
        this.sSensorConnectionList = this._initSensors(sensorIdentifiers);
        if (this.sSensorConnectionList < 0) {
            throw new OutOfMemoryError();
        }
        if (sensorIdentifiers.isEmpty()) {
            throw new OutOfMemoryError();
        }
        int sensorCount = sensorIdentifiers.size();
        this.iSensorInfos = new SensorInfo[sensorCount];
        for (int i = 0; i < sensorCount; ++i) {
            this.iSensorInfos[i] = new SensorInfoImpl((String)sensorIdentifiers.elementAt(i), i);
        }
    }

    public Finalizer registerForFinalization() {
        return new Finalizer(){

            public void finalizeImpl() {
                SensorManagerImpl.this.doFinalize();
            }
        };
    }

    void doFinalize() {
        if (this.iFinalizer == null) {
            return;
        }
        this.iFinalizer = null;
        if (this.sSensorConnectionList > 0) {
            this._dispose(this.sSensorConnectionList);
        }
    }

    public static SensorManagerImpl getInstance() {
        if (_instance == null) {
            _instance = new SensorManagerImpl();
        }
        return _instance;
    }

    public synchronized void addSensorListener(SensorListener listener, SensorInfo info) {
        int i;
        if (listener == null) {
            throw new NullPointerException("Adding sensor listener failed, listener is null");
        }
        if (info == null) {
            throw new NullPointerException("Adding sensor listener failed, SensorInfo is null");
        }
        int l = this.iSensorInfos.length;
        for (i = 0; i < l && this.iSensorInfos[i] != info; ++i) {
        }
        if (i == l) {
            throw new IllegalArgumentException("Adding Sensor Listener failed, unknown SensorInfo");
        }
        if (!this.sensorListeners.contains(listener)) {
            if (info.isAvailable()) {
                listener.sensorAvailable(info);
            } else {
                listener.sensorUnavailable(info);
            }
            this.sensorListeners.addElement(listener);
        }
    }

    public void addSensorListener(SensorListener listener, String quantity) {
        if (listener == null) {
            throw new NullPointerException("Adding sensor listener failed, listener is null");
        }
        if (quantity == null) {
            throw new NullPointerException("Adding sensor listener failed, quantity is null");
        }
        SensorInfo[] infos = this.findSensors(quantity, null);
        int l = infos.length;
        for (int i = 0; i < l; ++i) {
            this.addSensorListener(listener, infos[i]);
        }
    }

    public SensorInfo[] findSensors(String quantity, String contextType) {
        if (quantity == null && contextType == null) {
            return this.iSensorInfos;
        }
        if (quantity == null) {
            if (this.isValidContext(contextType)) {
                Vector matchingSensorInfos = new Vector();
                for (int i = 0; i < this.iSensorInfos.length; ++i) {
                    if (!this.iSensorInfos[i].getContextType().equals(contextType)) continue;
                    matchingSensorInfos.addElement(this.iSensorInfos[i]);
                }
                Object[] result = new SensorInfo[matchingSensorInfos.size()];
                matchingSensorInfos.copyInto(result);
                return result;
            }
            throw new IllegalArgumentException("Finding sensor failed: invalid contextType  " + contextType);
        }
        String url = SCHEME_SENSOR + quantity;
        if (contextType != null) {
            url = url + ";contextType=" + contextType;
        }
        return this.findSensors(url);
    }

    private boolean isValidContext(String contextType) {
        if (contextType == null) {
            return false;
        }
        return contextType.equals("ambient") || contextType.equals("device") || contextType.equals("user") || contextType.equals("vehicle");
    }

    public SensorInfo[] findSensors(String url) {
        String quantity;
        if (url == null) {
            throw new NullPointerException("Finding sensors failed: URL is null");
        }
        if (!url.startsWith(SCHEME_SENSOR)) {
            throw new IllegalArgumentException("Invalid URL: URL does not start with sensor:");
        }
        url = url.substring(SCHEME_SENSOR.length());
        if (url.indexOf(58) > -1) {
            throw new IllegalArgumentException("Invalid URL: colon seperator not allowed aftersensor:");
        }
        boolean isOnlyQuantity = false;
        int start = 0;
        int end = 0;
        end = url.indexOf(59, start);
        if (end < 0) {
            end = url.indexOf(SCHEME_QUERY_SEP, start);
        }
        if (end < 0) {
            end = url.length();
            isOnlyQuantity = true;
        }
        if ((quantity = url.substring(start, end)) == null || quantity.length() == 0) {
            throw new IllegalArgumentException("Invalid URL: quantity is null");
        }
        if (this.containsIllegalCharacters(quantity)) {
            throw new IllegalArgumentException("Invalid URL: quantity " + quantity + " contains illegal characters");
        }
        String contextType = null;
        String location = null;
        String model = null;
        if (!isOnlyQuantity) {
            Hashtable properties = this.parseProperty(url = url.substring(quantity.length() + 1));
            contextType = (String)properties.remove(SCHEME_CONTEXT);
            if (contextType != null && !this.isValidContext(contextType)) {
                throw new IllegalArgumentException("Invalid URL: contextType is invalid");
            }
            location = (String)properties.remove(SCHEME_LOCATION);
            model = (String)properties.remove(SCHEME_MODEL);
            if (properties.size() != 0) {
                throw new IllegalArgumentException("Invalid URL: URL contains invalid property name-value pair(s)");
            }
        }
        Vector matchingInfos = new Vector();
        for (int i = 0; i < this.iSensorInfos.length; ++i) {
            if (!this.iSensorInfos[i].getQuantity().equals(quantity) || contextType != null && !contextType.equals(this.iSensorInfos[i].getContextType()) || model != null && !model.equals(this.iSensorInfos[i].getModel())) continue;
            if (location != null) {
                Object sensorLoc = null;
                try {
                    sensorLoc = this.iSensorInfos[i].getProperty(SCHEME_LOCATION);
                }
                catch (IllegalArgumentException iae) {
                    // empty catch block
                }
                if (!location.equals(sensorLoc)) continue;
            }
            matchingInfos.addElement(this.iSensorInfos[i]);
        }
        if (matchingInfos.size() > 0) {
            Object[] result = new SensorInfo[matchingInfos.size()];
            matchingInfos.copyInto(result);
            return result;
        }
        return NO_INFOS;
    }

    private boolean containsIllegalCharacters(String aValue) {
        if (aValue == null) {
            throw new NullPointerException();
        }
        int ll = RESERVED.length;
        for (int i = 0; i < ll; ++i) {
            if (aValue.indexOf(RESERVED[i]) <= -1) continue;
            return true;
        }
        return false;
    }

    private Hashtable parseProperty(String aProperties) {
        Hashtable result = new Hashtable();
        int start = 0;
        int end = -1;
        int length = aProperties.length();
        while (start >= 0 && start < length) {
            end = aProperties.indexOf(61, start);
            if (-1 == end) {
                throw new IllegalArgumentException("Invalid URL: property name " + aProperties + " not found");
            }
            String key = aProperties.substring(start, end);
            start = end + 1;
            if (-1 == (end = aProperties.indexOf(59, start)) && start < length) {
                end = length;
            }
            if (-1 == end) {
                throw new IllegalArgumentException(start + INVALID_URL_PREFIX + " value not found for property name " + aProperties);
            }
            String value = aProperties.substring(start, end);
            result.put(key, value);
            start = end + 1;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeSensorListener(SensorListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        Vector vector = this.sensorListeners;
        synchronized (vector) {
            this.sensorListeners.removeElement(listener);
        }
    }

    private native int _initSensors(Vector var1);

    private native void _dispose(int var1);

    static {
        try {
            Jvm.loadSystemLibrary("javasensor");
        }
        catch (Exception exception) {
            // empty catch block
        }
        isDebug = true;
        NO_INFOS = new SensorInfoImpl[0];
        RESERVED = new char[]{';', '/', '?', ':', '@', '&', '=', '+', '$', ','};
    }
}

