/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.sms;

import com.nokia.mj.impl.rt.support.ApplicationUtils;
import com.nokia.mj.impl.rt.support.ShutdownListener;
import com.nokia.mj.impl.sms.SMSBinaryMessageImpl;
import com.nokia.mj.impl.sms.SMSMessageImpl;
import com.nokia.mj.impl.sms.SMSPermissionImpl;
import com.nokia.mj.impl.sms.SMSTextMessageImpl;
import com.nokia.mj.impl.smscbs.utils.WmaUrl;
import com.nokia.mj.impl.utils.Logger;
import java.io.IOException;
import java.io.InterruptedIOException;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.MessageListener;

public class SMSConnectionImpl
implements MessageConnection {
    private static final String SERVER_MSG = "Message Connection must be a Server connection";
    private static final int INITIAL = 0;
    private static final int OPEN = 1;
    private static final int CLOSED = 2;
    private static final int ERROR = 3;
    private static final int MAXIMUM_MESAGE_SEGMENTS_SUPPORTED = 10;
    private int iState;
    private int iRecvError;
    private int iSendResult;
    private int iMessageWaiting;
    private int iMessagesOnQueue;
    private int iMessageNotificationsToMake;
    private int iNativeHandle;
    private boolean iMissedMessage;
    private boolean iServerConnection;
    private final Object iReadLock;
    private final Object iWriteLock;
    private final Object iCloseLock;
    private final Object iMessageLock;
    private final Object iSendLock;
    private MessageListener iMessageListener;
    private WmaUrl iUri;

    public SMSConnectionImpl(WmaUrl aMsgUri, boolean aServerMode) throws IOException {
        Logger.LOG(15, 4, "+ SMSConnectionImpl::SMSConnectionImpl");
        this.iUri = aMsgUri;
        this.iState = 0;
        this.iServerConnection = aServerMode;
        this.iNativeHandle = this._createConnection(this.iUri.getAbsoluteUri(), this.iServerConnection);
        this.iReadLock = new Object();
        this.iWriteLock = new Object();
        this.iCloseLock = new Object();
        this.iMessageLock = new Object();
        this.iSendLock = new Object();
        this.setShutdownListener();
        Logger.LOG(15, 4, "- SMSConnectionImpl::SMSConnectionImpl");
    }

    private void setShutdownListener() {
        Logger.LOG(15, 4, "+ SMSConnectionImpl::setShutdownListener");
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        appUtils.addShutdownListener(new ShutdownListener(){

            public void shuttingDown() {
                try {
                    SMSConnectionImpl.this.close();
                }
                catch (IOException ex) {
                    Logger.ELOG(15, ex.toString(), ex);
                }
            }
        });
        Logger.LOG(15, 4, "- SMSConnectionImpl::setShutdownListener");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IOException {
        Logger.LOG(15, 4, "+ SMSConnectionImpl::open");
        if (this.iState == 0) {
            this.iState = 1;
            if (this.iServerConnection) {
                Object object = this.iCloseLock;
                synchronized (object) {
                    new Thread(new Runnable(){

                        public void run() {
                            SMSConnectionImpl.this._openConnection(SMSConnectionImpl.this.iNativeHandle);
                        }
                    }).start();
                }
            }
        }
        Logger.LOG(15, 4, "- SMSConnectionImpl::open");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Logger.LOG(15, 4, "+ SMSConnectionImpl::close");
        Object object = this.iCloseLock;
        synchronized (object) {
            if (this.iState != 2) {
                this.iState = 2;
                this._closeConnection(this.iNativeHandle);
                Object object2 = this.iMessageLock;
                synchronized (object2) {
                    this.iMessageLock.notify();
                }
                object2 = this.iReadLock;
                synchronized (object2) {
                    this.iReadLock.notify();
                }
                this._dispose(this.iNativeHandle);
            }
        }
        Logger.LOG(15, 4, "- SMSConnectionImpl::close");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageListener(MessageListener aListener) throws IOException {
        Logger.LOG(15, 4, "+ SMSConnectionImpl::setMessageListener");
        if (!this.iServerConnection) {
            throw new IOException(SERVER_MSG);
        }
        if (this.iState == 2) {
            throw new IOException("Setting message listener failed: connection is already closed");
        }
        this.checkReceivePermission();
        Object object = this.iReadLock;
        synchronized (object) {
            this.iMessageListener = aListener;
            if (aListener != null) {
                Object object2 = this.iMessageLock;
                synchronized (object2) {
                    this.iMessageLock.notify();
                }
            }
        }
        Logger.LOG(15, 4, "+ SMSConnectionImpl::setMessageListener");
    }

    private final void checkForReceiveError() throws IOException {
        if (this.iRecvError != 0) {
            int err = this.iRecvError;
            this.iRecvError = 0;
            if (err < 0) {
                this._checkError(err, false);
            }
        }
    }

    protected void checkReceivePermission() {
        ApplicationUtils appUtils = ApplicationUtils.getInstance();
        SMSPermissionImpl permission = new SMSPermissionImpl("sms://*", "receive");
        appUtils.checkPermission(permission);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receive() throws IOException, InterruptedIOException {
        Logger.LOG(15, 4, "+ SMSConnectionImpl::receive");
        if (!this.iServerConnection) {
            throw new IOException(SERVER_MSG);
        }
        SMSMessageImpl message = null;
        Object object = this.iReadLock;
        synchronized (object) {
            Object object2;
            if (this.iState == 2) {
                throw new IOException("Receiving message failed: connection is already closed");
            }
            if (this.iUri.isRestrictedPort()) {
                throw new SecurityException("No permission to receive on port: " + this.iUri.getPort());
            }
            this.checkReceivePermission();
            if (this.iMessagesOnQueue == 0) {
                ++this.iMessageWaiting;
                object2 = this.iMessageLock;
                synchronized (object2) {
                    this.iMessageLock.notify();
                }
                try {
                    Logger.LOG(15, 4, "WMA : Waiting for message");
                    this.iReadLock.wait();
                }
                catch (InterruptedException ex) {
                    Logger.ELOG(15, ex.toString(), ex);
                }
            }
            this.checkForReceiveError();
            object2 = this.iCloseLock;
            synchronized (object2) {
                if (this.iState == 2) {
                    throw new InterruptedIOException("Connection closed while receiving message");
                }
                int messageType = this._getMessageType(this.iNativeHandle);
                if (messageType != 0 && messageType != 1 && messageType < 0) {
                    this._checkError(messageType, false);
                }
                String remoteAddress = this._getHostAddress(this.iNativeHandle);
                long timestamp = this._getTimestamp(this.iNativeHandle);
                if (messageType == 0) {
                    String textData = (String)this._getReceivedMessageData(this.iNativeHandle, messageType);
                    SMSTextMessageImpl textMessage = new SMSTextMessageImpl(remoteAddress, timestamp);
                    textMessage.setPayloadText(textData);
                    message = textMessage;
                } else {
                    byte[] binaryData = (byte[])this._getReceivedMessageData(this.iNativeHandle, messageType);
                    SMSBinaryMessageImpl binaryMessage = new SMSBinaryMessageImpl(remoteAddress, timestamp);
                    binaryMessage.setPayloadData(binaryData);
                    message = binaryMessage;
                }
            }
            --this.iMessagesOnQueue;
        }
        Logger.LOG(15, 4, "- SMSConnectionImpl::receive");
        return message;
    }

    public Message newMessage(String aType) {
        String address = null;
        if (!this.iServerConnection) {
            address = this.iUri.getAbsoluteUri();
        }
        return this.newMessage(aType, address);
    }

    public Message newMessage(String aType, String aAddress) {
        SMSMessageImpl msg;
        if (aType.equals("text")) {
            msg = new SMSTextMessageImpl(aAddress, 0L);
        } else if (aType.equals("binary")) {
            msg = new SMSBinaryMessageImpl(aAddress, 0L);
        } else {
            throw new IllegalArgumentException("Message type is invalid: " + aType);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numberOfSegments(Message aMsg) {
        SMSMessageImpl messageImpl;
        WmaUrl uri;
        Logger.LOG(15, 4, "+ SMSConnectionImpl::numberOfSegments");
        int messageSegments = 0;
        if (aMsg == null) {
            throw new NullPointerException("Message parameter is null");
        }
        String address = aMsg.getAddress();
        if (this.iServerConnection && address != null) {
            uri = new WmaUrl(address);
            uri.validateUri();
        } else {
            uri = this.iUri;
        }
        try {
            messageImpl = (SMSMessageImpl)aMsg;
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException("NumberOfSegments can onlybe calculated for Text/Binary Message");
        }
        Object object = this.iCloseLock;
        synchronized (object) {
            if (this.iState != 2) {
                messageSegments = messageImpl.getType() == 0 ? this._smsTextDataSegments(this.iNativeHandle, messageImpl.getType(), uri.getHost(), uri.getPort(), messageImpl.getPayloadTextData()) : this._smsBinaryDataSegments(this.iNativeHandle, messageImpl.getType(), uri.getHost(), uri.getPort(), messageImpl.getPayloadBinaryData());
            }
        }
        if (messageSegments > 10) {
            messageSegments = 0;
        }
        Logger.LOG(15, 4, "+ SMSConnectionImpl::numberOfSegments");
        return messageSegments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message aMsg) throws IOException, InterruptedIOException {
        SMSMessageImpl messageImpl;
        Logger.LOG(15, 4, "+ SMSConnectionImpl::send");
        int messageSegments = 0;
        if (aMsg == null) {
            throw new NullPointerException("Message parameter is null");
        }
        String sendAddress = aMsg.getAddress();
        if (sendAddress == null) {
            throw new IllegalArgumentException("Message destination address not specified");
        }
        WmaUrl uri = new WmaUrl(sendAddress);
        uri.validateUri();
        if ("".equals(uri.getHost())) {
            throw new IllegalArgumentException("Message destination address not specified");
        }
        try {
            messageImpl = (SMSMessageImpl)aMsg;
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException("The message to be sent withthis connection can only be Text/Binary Message");
        }
        if (uri.isRestrictedPort()) {
            throw new SecurityException("No permission to send on port: " + uri.getPort());
        }
        Object object = this.iWriteLock;
        synchronized (object) {
            Object object2 = this.iSendLock;
            synchronized (object2) {
                Object object3 = this.iCloseLock;
                synchronized (object3) {
                    if (this.iState == 2) {
                        throw new IOException("Sending message failed: connection is already closed");
                    }
                    messageSegments = messageImpl.getType() == 0 ? this._smsTextDataSegments(this.iNativeHandle, messageImpl.getType(), uri.getHost(), uri.getPort(), messageImpl.getPayloadTextData()) : this._smsBinaryDataSegments(this.iNativeHandle, messageImpl.getType(), uri.getHost(), uri.getPort(), messageImpl.getPayloadBinaryData());
                    if (messageSegments > 10) {
                        throw new IllegalArgumentException("Message exceeds the maximum supported segments: 10");
                    }
                    ApplicationUtils appUtils = ApplicationUtils.getInstance();
                    SMSPermissionImpl permission = new SMSPermissionImpl("sms://*", "send", messageSegments, sendAddress);
                    appUtils.checkPermission(permission);
                    new Thread(new Runnable(){

                        public void run() {
                            SMSConnectionImpl.this.doSend();
                        }
                    }).start();
                    try {
                        this.iSendLock.wait();
                    }
                    catch (InterruptedException ex) {
                        Logger.LOG(15, 1, ex.toString());
                    }
                    if (this.iSendResult < 0) {
                        this._checkError(this.iSendResult, true);
                    }
                }
            }
        }
        Logger.LOG(15, 4, "- SMSConnectionImpl::send");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSend() {
        this.iSendResult = this._sendMessage(this.iNativeHandle);
        Object object = this.iSendLock;
        synchronized (object) {
            this.iSendLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int messageReceiveCallback(int aReceivedMsgs, int aError) {
        Logger.LOG(15, 4, "+ SMSConnectionImpl::messageReceiveCallback");
        Object object = this.iMessageLock;
        synchronized (object) {
            if (0 == this.iMessageWaiting && null == this.iMessageListener) {
                try {
                    this.iMessageLock.wait();
                }
                catch (InterruptedException ex) {
                    Logger.ELOG(15, ex.toString(), ex);
                }
            }
        }
        object = this.iReadLock;
        synchronized (object) {
            if (aReceivedMsgs > 0) {
                this.iMessagesOnQueue += aReceivedMsgs;
                this.iMessageNotificationsToMake += aReceivedMsgs;
            } else {
                this.iRecvError = aError;
            }
            if (0 != this.iMessageWaiting) {
                --this.iMessageWaiting;
                this.iReadLock.notify();
            } else if (null != this.iMessageListener) {
                while (this.iMessageNotificationsToMake > 0) {
                    this.iMessageListener.notifyIncomingMessage(this);
                    --this.iMessageNotificationsToMake;
                }
                if (this.iRecvError != 0) {
                    this.iMessageListener.notifyIncomingMessage(this);
                }
            }
        }
        Logger.LOG(15, 4, "+ SMSConnectionImpl::messageReceiveCallback");
        return this.iState == 2 ? -1 : 0;
    }

    private native int _createConnection(String var1, boolean var2);

    private native void _openConnection(int var1);

    private native void _closeConnection(int var1);

    private native int _smsTextDataSegments(int var1, int var2, String var3, String var4, String var5);

    private native int _smsBinaryDataSegments(int var1, int var2, String var3, String var4, byte[] var5);

    private native int _sendMessage(int var1);

    private native int _getMessageType(int var1);

    private native String _getHostAddress(int var1);

    private native long _getTimestamp(int var1);

    private native Object _getReceivedMessageData(int var1, int var2);

    private native void _dispose(int var1);

    private native void _checkError(int var1, boolean var2);
}

