/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.ssl;

import com.nokia.mj.impl.connectionmanager.AccessPoint;
import com.nokia.mj.impl.connectionmanager.ConnectionManager;
import com.nokia.mj.impl.gcf.utils.StreamConnectionBase;
import com.nokia.mj.impl.gcf.utils.UrlParser;
import com.nokia.mj.impl.rt.support.Finalizer;
import com.nokia.mj.impl.rt.ui.ConfirmData;
import com.nokia.mj.impl.rt.ui.RuntimeUi;
import com.nokia.mj.impl.rt.ui.RuntimeUiFactory;
import com.nokia.mj.impl.ssl.SecurityInfoImpl;
import com.nokia.mj.impl.utils.Logger;
import com.nokia.mj.impl.utils.ResourceLoader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.SecureConnection;
import javax.microedition.io.SecurityInfo;
import javax.microedition.pki.CertificateException;

public class SecureConnectionImpl
extends StreamConnectionBase
implements SecureConnection {
    private UrlParser iUri;
    private int iSocketDesc;
    private Finalizer iFinalizer;
    private boolean iConnectionOpen;
    private static final int X509_V_OK = 0;
    private boolean iOutputStreamOpenedOnce;
    private boolean iInputStreamOpenedOnce;
    private boolean iDataOutputStreamOpenedOnce;
    private boolean iDataInputStreamOpenedOnce;
    private boolean iInput;
    private int iChoice;
    private ConnectionManager iCmInstance;
    private AccessPoint iApn;
    private static final String SSL_RES_NAME = "javassl";
    private static final String LOCALISED_STRING_ID = "qtn_ssl_prompt_";
    private static final String UNTRUSTED_CERTIFICATE_WARNING = "untrusted_certificate";

    public void showUI() {
        Logger.LOG(14, 4, "display ui called ");
        RuntimeUi rui = RuntimeUiFactory.getRuntimeUi();
        String[] ans = new String[]{"Yes", "No"};
        String localisedWarning = ResourceLoader.getInstance(SSL_RES_NAME, LOCALISED_STRING_ID).format(UNTRUSTED_CERTIFICATE_WARNING, null);
        ConfirmData conf = new ConfirmData(localisedWarning, ans, 0);
        this.iInput = rui.confirm("SecureConnection", conf);
        this.iChoice = conf.getAnswer();
        Logger.LOG(14, 4, "confirmdata returned value : " + this.iInput + "selected button :" + this.iChoice);
    }

    /*
     * Enabled aggressive block sorting
     */
    public SecureConnectionImpl(UrlParser aUri, int aMode, int aSock, ConnectionManager cm, AccessPoint apnInfo) throws IOException {
        block9: {
            super(aUri.toString(), aMode, false);
            this.iConnectionOpen = false;
            this.iOutputStreamOpenedOnce = false;
            this.iInputStreamOpenedOnce = false;
            this.iDataOutputStreamOpenedOnce = false;
            this.iDataInputStreamOpenedOnce = false;
            this.iInput = false;
            this.iChoice = -1;
            this.iCmInstance = null;
            this.iApn = null;
            int[] retval = new int[2];
            this.iCmInstance = cm;
            this.iApn = apnInfo;
            Logger.LOG(14, 4, "+SecureConnectionImpl::SecureConnectionImpl()");
            this.iSocketDesc = aSock;
            int ret = this.iApn != null ? this._doHandshake(this.iNativePeerHandle, this.iSocketDesc, this.iApn.getType(), this.iApn.getNapId(), retval) : this._doHandshake(this.iNativePeerHandle, this.iSocketDesc, -1, -1, retval);
            Logger.LOG(14, 4, "setting access point return value =" + retval[0]);
            if (this.iCmInstance != null && retval[0] < 0) {
                this.iCmInstance.reset();
            }
            Logger.LOG(14, 4, "ssl connect return value =" + ret);
            if (ret < 0) {
                throw new IOException("Unable to open a secure connection. Posix error code: " + ret);
            }
            if (retval[1] < 0) {
                this.iConnectionOpen = true;
                SecurityInfo tmpSecurityInfo = this.getSecurityInfo();
                throw new CertificateException("Invalid server certificate. Symbian OS error code: " + retval[1], tmpSecurityInfo.getServerCertificate(), 14);
            }
            if (ret != 0) {
                this.iConnectionOpen = true;
                if (ret != 18) {
                    SecurityInfo tmpSecurityInfo = this.getSecurityInfo();
                    throw new CertificateException("Untrusted server certificate", tmpSecurityInfo.getServerCertificate(), 14);
                }
                this.showUI();
                if (!this.iInput) {
                    SecurityInfo tmpSecurityInfo = this.getSecurityInfo();
                    throw new CertificateException("Untrusted server certificate", tmpSecurityInfo.getServerCertificate(), 14);
                }
                if (this.iChoice == 0) {
                    Logger.LOG(14, 4, "SecureConnectionImpl()- untrusted certificate accepted");
                    break block9;
                } else {
                    SecurityInfo tmpSecurityInfo = this.getSecurityInfo();
                    if (tmpSecurityInfo.getServerCertificate() == null) {
                        Logger.LOG(14, 4, "tmpSecurityInfo.getServerCertificate() is null");
                        throw new CertificateException("Untrusted server certificate", tmpSecurityInfo.getServerCertificate(), 14);
                    }
                    Logger.LOG(14, 4, "tmpSecurityInfo.getServerCertificate() is not null");
                    throw new CertificateException("Untrusted server certificate", tmpSecurityInfo.getServerCertificate(), 14);
                }
            }
            this.iConnectionOpen = true;
        }
        this.iFinalizer = this.createFinalizer();
        Logger.LOG(14, 4, "--SecureConnectionImpl(), socketdescrip = " + this.iSocketDesc);
    }

    public int createNativePeer(String aUri, int aMode, boolean aTimeOut) {
        Logger.LOG(14, 4, "+SecureConnectionImpl::createNativePeer()");
        this.iUri = new UrlParser(aUri);
        Logger.LOG(14, 4, "SecureConnectionImpl::createNativePeer() aUri = " + aUri + "aMode = " + aMode + "iUri.host = " + this.iUri.host);
        int ret = this._createNativePeer(aUri, aMode, this.iUri.host, this.iUri.port);
        Logger.LOG(14, 4, "-SecureConnectionImpl::createNativePeer()");
        return ret;
    }

    public String getAddress() throws IOException {
        Logger.LOG(14, 4, "+SecureConnectionImpl::getAddress()");
        String[] addr = new String[1];
        if (!this.iConnectionOpen) {
            throw new IOException("getAddress failed: connection is already closed");
        }
        int retValue = this._getAddress(this.iNativePeerHandle, addr);
        if (retValue < 0) {
            throw new IOException("getAddress failed. POSIX error code: " + retValue);
        }
        Logger.LOG(14, 4, "-SecureConnectionImpl::getAddress()");
        return addr[0];
    }

    public String getLocalAddress() throws IOException {
        Logger.LOG(14, 4, "+SecureConnectionImpl::getLocalAddress()");
        String[] addr = new String[1];
        if (!this.iConnectionOpen) {
            throw new IOException("getLocalAddress failed: connection is already closed");
        }
        int retValue = this._getLocalAddress(this.iNativePeerHandle, addr);
        if (retValue < 0) {
            throw new IOException("getLocalAddress failed. POSIX error code: " + retValue);
        }
        Logger.LOG(14, 4, "-SecureConnectionImpl::getLocalAddress()");
        return addr[0];
    }

    public int getLocalPort() throws IOException {
        Logger.LOG(14, 4, "+SecureConnectionImpl::getLocalPort()");
        if (!this.iConnectionOpen) {
            throw new IOException("getLocalPort failed: connection is already closed");
        }
        int localPort = this._getLocalPort(this.iNativePeerHandle);
        if (localPort < 0) {
            throw new IOException("getLocalPort failed. POSIX error code: " + localPort);
        }
        Logger.LOG(14, 4, "-SecureConnectionImpl::getLocalPort()");
        return localPort;
    }

    public int getPort() throws IOException {
        Logger.LOG(14, 4, "+SecureConnectionImpl::getPort()");
        if (!this.iConnectionOpen) {
            throw new IOException("getPort failed: connection is already closed");
        }
        int result = this._getport(this.iNativePeerHandle);
        if (result < 0) {
            throw new IOException("getPort failed. POSIX error code: " + result);
        }
        Logger.LOG(14, 4, "-SecureConnectionImpl::getPort()");
        return result;
    }

    public int getSocketOption(byte aOption) throws IllegalArgumentException, IOException {
        Logger.LOG(14, 4, "+SecureConnectionImpl::getSocketOption()");
        if (!this.iConnectionOpen) {
            throw new IOException("getSocketOption failed: connection is already closed");
        }
        this.checkOption(aOption);
        int retVal = this._getSocketOption(this.iNativePeerHandle, aOption);
        if (retVal < 0) {
            throw new IOException("getSocketOption failed. POSIX error code: " + retVal);
        }
        Logger.LOG(14, 4, "-SecureConnectionImpl::getSocketOption()");
        return retVal;
    }

    public void setSocketOption(byte aOption, int aValue) throws IllegalArgumentException, IOException {
        Logger.LOG(14, 4, "+SecureConnectionImpl::setSocketOption()");
        if (!this.iConnectionOpen) {
            throw new IOException("setSocketOption failed: connection is already closed");
        }
        this.checkOption(aOption);
        if (aValue < 0) {
            throw new IllegalArgumentException("Incorrect value for setSocketOption");
        }
        int retval = this._setSocketOption(this.iNativePeerHandle, aOption, aValue);
        if (retval < 0) {
            throw new IOException("setSocketOption failed. POSIX error code: " + retval);
        }
        Logger.LOG(14, 4, "-SecureConnectionImpl::setSocketOption()");
    }

    private void checkOption(byte option) throws IllegalArgumentException {
        if (option != 0 && option != 2 && option != 1 && option != 3 && option != 4) {
            throw new IllegalArgumentException("Unsupported socket option");
        }
    }

    public SecurityInfo getSecurityInfo() throws IOException {
        Logger.LOG(14, 4, "+SecureConnectionImpl::getSecurityInfo()");
        if (!this.iConnectionOpen) {
            throw new IOException("getSecurityInfo failed: connection is already closed");
        }
        String[] iStringArray = new String[9];
        long version = 0L;
        int res = this._getSecurityInfo(this.iNativePeerHandle, iStringArray);
        SecurityInfoImpl securityInfo = new SecurityInfoImpl(iStringArray);
        Logger.LOG(14, 4, "-SecureConnectionImpl::getSecurityInfo()");
        return securityInfo;
    }

    public OutputStream openOutputStream() throws IOException {
        if (this.iOutputStreamOpenedOnce) {
            throw new IOException("OutputStream cannot be opened multiple times");
        }
        this.iOutputStreamOpenedOnce = true;
        return super.openOutputStream();
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        if (this.iDataOutputStreamOpenedOnce) {
            throw new IOException("DataOutputStream cannot be opened multiple times");
        }
        this.iDataOutputStreamOpenedOnce = true;
        return super.openDataOutputStream();
    }

    public InputStream openInputStream() throws IOException {
        if (this.iInputStreamOpenedOnce) {
            throw new IOException("InputStream cannot be opened multiple times");
        }
        this.iInputStreamOpenedOnce = true;
        return super.openInputStream();
    }

    public DataInputStream openDataInputStream() throws IOException {
        if (this.iDataInputStreamOpenedOnce) {
            throw new IOException("DataInputStream cannot be opened multiple times");
        }
        this.iDataInputStreamOpenedOnce = true;
        return super.openDataInputStream();
    }

    public void close() throws IOException {
        Logger.LOG(14, 4, "+SecureConnectionImpl::close() open flag = " + this.iConnectionOpen);
        if (this.iConnectionOpen) {
            this.iConnectionOpen = false;
            super.close();
            if (this.isStreamsClosed()) {
                Logger.LOG(14, 4, "+SecureConnectionImpl::close() calling _close " + this.iConnectionOpen);
                int ret = this._close(this.iNativePeerHandle);
                Logger.LOG(14, 4, "-SecureConnectionImpl::close() = close returned " + ret);
                if (ret != 0) {
                    throw new IOException("Posix error code : " + ret);
                }
            }
        }
        Logger.LOG(14, 4, "-SecureConnectionImpl::close()");
    }

    Finalizer createFinalizer() {
        Logger.LOG(14, 4, "creating a socket finalizer object ");
        return new Finalizer(){

            public void finalizeImpl() {
                SecureConnectionImpl.this.doFinalize();
            }
        };
    }

    public void doFinalize() {
        Logger.LOG(14, 4, "securesocket doFinalize() called :");
        if (this.iConnectionOpen) {
            this.iConnectionOpen = false;
            if (this.iNativePeerHandle != 0) {
                int n = this._close(this.iNativePeerHandle);
            }
        }
        if (this.iNativePeerHandle != 0) {
            this._dispose(this.iNativePeerHandle);
            this.iNativePeerHandle = 0;
        }
    }

    private native int _createNativePeer(String var1, int var2, String var3, int var4);

    private native int _doHandshake(int var1, int var2, int var3, int var4, int[] var5);

    private native int _getSecurityInfo(int var1, String[] var2);

    private native int _getAddress(int var1, String[] var2);

    private native int _getLocalAddress(int var1, String[] var2);

    private native int _getLocalPort(int var1);

    private native int _getport(int var1);

    private native int _setSocketOption(int var1, int var2, int var3);

    private native int _getSocketOption(int var1, int var2);

    private native int _close(int var1);

    private native void _dispose(int var1);
}

