/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.storage;

import com.nokia.mj.impl.rt.support.Jvm;
import com.nokia.mj.impl.storage.StorageException;
import com.nokia.mj.impl.utils.Logger;

final class StorageConnection {
    private int iSessionHandle = 0;

    StorageConnection() {
        if (0 != this.iSessionHandle) {
            Logger.WLOG(11, "Session already created");
            return;
        }
        int ret = StorageConnection._startSession();
        if (ret < 0) {
            throw new StorageException("Native storage session failed:" + String.valueOf(ret));
        }
        this.iSessionHandle = ret;
    }

    String open(String aHeaders, String aStorageName) throws StorageException {
        return this._open(this.iSessionHandle, aHeaders, aStorageName);
    }

    void close(String aHeaders) throws StorageException {
        this._close(this.iSessionHandle, aHeaders);
    }

    String execute(String aHeaders, String aSqlStatement) throws StorageException {
        return this._execute(this.iSessionHandle, aHeaders, aSqlStatement);
    }

    void closeSession() {
        if (0 != this.iSessionHandle) {
            StorageConnection._closeSession(this.iSessionHandle);
            this.iSessionHandle = 0;
        }
    }

    private static native int _startSession();

    private static native void _closeSession(int var0);

    private native String _open(int var1, String var2, String var3);

    private native void _close(int var1, String var2);

    private native String _execute(int var1, String var2, String var3);

    static {
        Jvm.loadSystemLibrary("javastorage");
    }
}

