/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.utils;

import java.io.IOException;
import java.io.Reader;

public class BufferedReader
extends Reader {
    private static final int BUF_SIZE = 16384;
    private Reader iReader = null;
    private char[] iBuf = null;
    private int iBufAmount = 0;
    private int iBufPos = 0;

    public BufferedReader(Reader aIn) {
        this(aIn, 16384);
    }

    public BufferedReader(Reader aIn, int aSize) {
        if (aSize <= 0) {
            throw new IllegalArgumentException("BufferedReader: Invalid buffer size");
        }
        this.iBuf = new char[aSize];
        this.iReader = aIn;
    }

    public void close() throws IOException {
        this.iBuf = null;
        this.iBufAmount = 0;
        this.iBufPos = 0;
        if (this.iReader != null) {
            this.iReader.close();
        }
    }

    public int read() throws IOException {
        int result = 0;
        if (this.iBufPos >= this.iBufAmount) {
            result = this.fillBuf();
        }
        if (result > -1) {
            result = this.iBuf[this.iBufPos++];
        }
        return result;
    }

    public int read(char[] aBuf) throws IOException {
        return this.read(aBuf, 0, aBuf.length);
    }

    public int read(char[] aBuf, int aOffset, int aLength) throws IOException {
        if (aOffset < 0 || aOffset >= aBuf.length) {
            throw new IllegalArgumentException("BufferedReader: Invalid buffer offset");
        }
        int charsToRead = aBuf.length - aOffset;
        if (charsToRead > aLength) {
            charsToRead = aLength;
        }
        int bufCharCount = this.iBufAmount - this.iBufPos;
        int readCount = 0;
        if (charsToRead <= bufCharCount) {
            for (int i = 0; i < charsToRead; ++i) {
                aBuf[aOffset + i] = this.iBuf[this.iBufPos++];
            }
            readCount += charsToRead;
        } else {
            for (int i = 0; i < bufCharCount; ++i) {
                aBuf[aOffset + i] = this.iBuf[this.iBufPos++];
            }
            readCount += bufCharCount;
            if (this.fillBuf() > -1) {
                readCount += this.read(aBuf, aOffset + readCount, aLength - readCount);
            }
        }
        if (readCount <= 0) {
            readCount = -1;
        }
        return readCount;
    }

    public String readLine() throws IOException {
        if (!this.ensureBuf()) {
            return null;
        }
        StringBuffer line = new StringBuffer();
        while (this.ensureBuf() && !this.skipEol()) {
            line.append(this.iBuf[this.iBufPos++]);
        }
        return line.toString();
    }

    public boolean ready() throws IOException {
        if (this.iBufPos < this.iBufAmount) {
            return true;
        }
        if (this.iReader != null) {
            return this.iReader.ready();
        }
        return false;
    }

    public long skip(long aAmountToSkip) throws IOException {
        if (aAmountToSkip < 0L) {
            throw new IllegalArgumentException("BufferedReader: Cannot skip negative amount of characters");
        }
        long skipped = 0L;
        int bufCharCount = this.iBufAmount - this.iBufPos;
        if (aAmountToSkip <= (long)bufCharCount) {
            this.iBufPos = (int)((long)this.iBufPos + aAmountToSkip);
            skipped += aAmountToSkip;
        } else {
            this.iBufPos += bufCharCount;
            skipped += (long)bufCharCount;
            if (this.iReader != null) {
                skipped += this.iReader.skip(aAmountToSkip - skipped);
            }
        }
        return skipped;
    }

    private boolean skipEol() throws IOException {
        if (!this.ensureBuf()) {
            return true;
        }
        boolean eolFound = false;
        if (this.iBufAmount > this.iBufPos && this.iBuf[this.iBufPos] == '\r') {
            ++this.iBufPos;
            eolFound = true;
            this.ensureBuf();
        }
        if (this.iBufAmount > this.iBufPos && this.iBuf[this.iBufPos] == '\n') {
            ++this.iBufPos;
            eolFound = true;
        }
        return eolFound;
    }

    private boolean ensureBuf() throws IOException {
        boolean result = true;
        if (this.iBufPos >= this.iBufAmount && this.fillBuf() == -1) {
            result = false;
        }
        return result;
    }

    private int fillBuf() throws IOException {
        if (this.iReader == null) {
            return -1;
        }
        int readCount = this.iReader.read(this.iBuf);
        if (readCount > -1) {
            this.iBufAmount = readCount;
            this.iBufPos = 0;
        }
        return readCount;
    }
}

