/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.mj.impl.utils;

public final class JavaLanguageSyntaxChecker {
    private static final String[] JAVA_KEYWORDS = new String[]{"abstract", "continue", "for", "new", "switch", "assert", "default", "if", "package", "synchronized", "boolean", "do", "goto", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while", "true", "false", "null"};

    public static boolean checkClassName(String fullyQualifiedClassName) {
        boolean isLetter;
        if (fullyQualifiedClassName == null || fullyQualifiedClassName.length() == 0) {
            return false;
        }
        char c = fullyQualifiedClassName.charAt(0);
        boolean bl = isLetter = c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
        if (!isLetter && c != '_' && c != '$') {
            return false;
        }
        StringBuffer identifier = new StringBuffer();
        identifier.append(c);
        int len = fullyQualifiedClassName.length();
        for (int i = 1; i < len; ++i) {
            c = fullyQualifiedClassName.charAt(i);
            if (c != '.') {
                boolean isLetterOrDigit;
                boolean bl2 = isLetterOrDigit = c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9';
                if (!isLetterOrDigit && c != '_' && c != '$') {
                    return false;
                }
                identifier.append(c);
                continue;
            }
            if (identifier.length() == 0) {
                return false;
            }
            if (JavaLanguageSyntaxChecker.isKeyword(identifier.toString())) {
                return false;
            }
            identifier = new StringBuffer();
        }
        return !JavaLanguageSyntaxChecker.isKeyword(identifier.toString());
    }

    private static boolean isKeyword(String str) {
        for (int i = 0; i < JAVA_KEYWORDS.length; ++i) {
            if (!str.equals(JAVA_KEYWORDS[i])) continue;
            return true;
        }
        return false;
    }
}

