/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ukit.jaxp;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class ReaderUTF8
extends Reader {
    private InputStream is;

    public ReaderUTF8(InputStream is) {
        this.is = is;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int num;
        block5: for (num = 0; num < len; ++num) {
            int val = this.is.read();
            if (val < 0) {
                return num != 0 ? num : -1;
            }
            switch (val & 0xF0) {
                case 192: 
                case 208: {
                    cbuf[off++] = (char)((val & 0x1F) << 6 | this.is.read() & 0x3F);
                    continue block5;
                }
                case 224: {
                    cbuf[off++] = (char)((val & 0xF) << 12 | (this.is.read() & 0x3F) << 6 | this.is.read() & 0x3F);
                    continue block5;
                }
                case 240: {
                    throw new UnsupportedEncodingException();
                }
                default: {
                    cbuf[off++] = (char)val;
                }
            }
        }
        return num;
    }

    public int read() throws IOException {
        int val = this.is.read();
        if (val < 0) {
            return -1;
        }
        switch (val & 0xF0) {
            case 192: 
            case 208: {
                val = (val & 0x1F) << 6 | this.is.read() & 0x3F;
                break;
            }
            case 224: {
                val = (val & 0xF) << 12 | (this.is.read() & 0x3F) << 6 | this.is.read() & 0x3F;
                break;
            }
            case 240: {
                throw new UnsupportedEncodingException();
            }
        }
        return val;
    }

    public void close() throws IOException {
        this.is.close();
    }
}

