/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.epoc.events;

import com.symbian.epoc.events.MIDEventServerFactory;
import com.symbian.util.NativeError;

public class MIDEventServer {
    private static final int MAX_USER_NAME = 64;
    private final int iHandle;

    public MIDEventServer(String aName) {
        this.iHandle = this.openEventServer(aName, new DefaultFactory());
    }

    protected MIDEventServer(String aName, MIDEventServerFactory aFactory) {
        this.iHandle = this.openEventServer(aName, aFactory);
    }

    private int openEventServer(String aName, MIDEventServerFactory aFactory) {
        if (aName.length() > 64) {
            throw new IllegalArgumentException();
        }
        int c = this._findServer(aName);
        if (c < 0) {
            c = aFactory.createServer(aName);
            NativeError.checkOOM(c);
        }
        return c;
    }

    public int getHandle() {
        return this.iHandle;
    }

    public void shutdown() {
        this._shutdown(this.iHandle);
    }

    private native int _findServer(String var1);

    private native void _shutdown(int var1);

    private native int _createServer(String var1);

    private class DefaultFactory
    implements MIDEventServerFactory {
        DefaultFactory() {
        }

        public int createServer(String aName) {
            return MIDEventServer.this._createServer(aName);
        }
    }
}

