/*
 * Decompiled with CFR 0.152.
 */
package com.symbian.lcdjava.lang;

import com.nokia.mj.impl.rt.support.Jvm;
import com.nokia.mj.impl.rt.support.JvmInternal;

public class SystemExtensions {
    private static final int FREE_KB_RAM_LIMIT_FOR_FINALIZATION = 4096;
    private static final int NATIVE_ALLOCATION_GC_THRESHOLD = 0x200000;
    static final Object sNativeAllocationLock;
    static long sNativeAllocationCounter;

    public static void startEventProcessing() {
        try {
            Class.forName("com.nokia.mj.impl.rt.symbian.EventProcessor");
        }
        catch (ClassNotFoundException x) {
            throw new Error("Failed to load the event processor: " + x);
        }
    }

    public static void runFinalization() {
        JvmInternal.runFinalization();
    }

    public static void dispatchCallbacks(int aThreadNumber) {
        SystemExtensions._dispatchCallbacks(aThreadNumber);
    }

    public static void ensureMinFreeRAM() {
        long freeRAM = SystemExtensions._getFreeRAMInKB();
        if (freeRAM < 4096L) {
            SystemExtensions.freeNativeMemory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nativeMemoryAllocated(int aNativeBytes) {
        boolean gc = false;
        Object object = sNativeAllocationLock;
        synchronized (object) {
            if ((sNativeAllocationCounter += (long)aNativeBytes) > 0x200000L) {
                sNativeAllocationCounter = 0L;
                gc = true;
            }
        }
        if (gc) {
            SystemExtensions.freeNativeMemory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nativeMemoryFreed(int aNativeBytes) {
        Object object = sNativeAllocationLock;
        synchronized (object) {
            if ((sNativeAllocationCounter -= (long)aNativeBytes) < 0L) {
                sNativeAllocationCounter = 0L;
            }
        }
    }

    public static void freeNativeMemory() {
        if (JvmInternal.runYoungGenerationGc()) {
            JvmInternal.runFinalization();
            if (SystemExtensions._getFreeRAMInKB() >= 4096L) {
                return;
            }
        }
        System.gc();
        JvmInternal.runFinalization();
    }

    private static native long _getFreeRAMInKB();

    public static void ExitThreads() {
        SystemExtensions._exitThreads();
    }

    private static native void _dispatchCallbacks(int var0);

    private static native void _exitThreads();

    static {
        Jvm.loadSystemLibrary("javalegacyutils");
        sNativeAllocationLock = new Object();
        sNativeAllocationCounter = 0L;
    }
}

