/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.Util;
import com.ibm.oti.vm.VM;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class DataInputStream
extends InputStream
implements DataInput {
    protected InputStream in;
    static final int MAX_BUF_SIZE = 8192;
    private static final boolean useNative = VM.useNatives();

    public DataInputStream(InputStream in) {
        this.in = in;
    }

    public final int read(byte[] buffer) throws IOException {
        return this.in.read(buffer, 0, buffer.length);
    }

    public final int read(byte[] buffer, int offset, int length) throws IOException {
        return this.in.read(buffer, offset, length);
    }

    public final boolean readBoolean() throws IOException {
        int temp = this.in.read();
        if (temp >= 0) {
            return temp != 0;
        }
        throw new EOFException();
    }

    public final byte readByte() throws IOException {
        int temp = this.in.read();
        if (temp >= 0) {
            return (byte)temp;
        }
        throw new EOFException();
    }

    public final char readChar() throws IOException {
        int b2;
        int b1 = this.in.read();
        if ((b1 | (b2 = this.in.read())) >= 0) {
            return (char)((b1 << 8) + b2);
        }
        throw new EOFException();
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final void readFully(byte[] buffer) throws IOException {
        this.readFully(buffer, 0, buffer.length);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void readFully(byte[] buffer, int offset, int length) throws IOException {
        if (buffer == null) throw new NullPointerException(Msg.getString("K0047"));
        if (offset < 0 || offset > buffer.length || length < 0 || length > buffer.length - offset) throw new IndexOutOfBoundsException();
        while (length > 0) {
            int result = this.in.read(buffer, offset, length);
            if (result < 0) throw new EOFException();
            offset += result;
            length -= result;
        }
    }

    public final int readInt() throws IOException {
        int b4;
        int b3;
        int b2;
        int b1 = this.in.read();
        if ((b1 | (b2 = this.in.read()) | (b3 = this.in.read()) | (b4 = this.in.read())) >= 0) {
            return (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
        }
        throw new EOFException();
    }

    public final long readLong() throws IOException {
        int b4;
        int b3;
        int b2;
        int i1 = this.readInt();
        int b1 = this.in.read();
        if ((b1 | (b2 = this.in.read()) | (b3 = this.in.read()) | (b4 = this.in.read())) >= 0) {
            return ((long)i1 << 32) + ((long)b1 << 24) + (long)(b2 << 16) + (long)(b3 << 8) + (long)b4;
        }
        throw new EOFException();
    }

    public final short readShort() throws IOException {
        int b2;
        int b1 = this.in.read();
        if ((b1 | (b2 = this.in.read())) >= 0) {
            return (short)((b1 << 8) + b2);
        }
        throw new EOFException();
    }

    public final int readUnsignedByte() throws IOException {
        int temp = this.in.read();
        if (temp >= 0) {
            return temp;
        }
        throw new EOFException();
    }

    public final int readUnsignedShort() throws IOException {
        int b2;
        int b1 = this.in.read();
        if ((b1 | (b2 = this.in.read())) >= 0) {
            return (b1 << 8) + b2;
        }
        throw new EOFException();
    }

    public final String readUTF() throws IOException {
        int utfSize = this.readUnsignedShort();
        return this.decodeUTF(utfSize);
    }

    String decodeUTF(int utfSize) throws IOException {
        byte[] buf = new byte[utfSize];
        char[] out = null;
        if (!useNative) {
            out = new char[utfSize];
        }
        this.readFully(buf, 0, utfSize);
        String result = useNative ? Util.convertFromUTF8(buf, 0, utfSize) : Util.convertUTF8WithBuf(buf, out, 0, utfSize);
        return result;
    }

    public static final String readUTF(DataInput in) throws IOException {
        return in.readUTF();
    }

    public final int skipBytes(int count) throws IOException {
        long skip;
        int skipped = 0;
        while (skipped < count && (skip = this.in.skip(count - skipped)) != 0L) {
            skipped = (int)((long)skipped + skip);
        }
        if (skipped >= 0) {
            return skipped;
        }
        throw new EOFException();
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
    }

    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public int read() throws IOException {
        return this.in.read();
    }

    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    public long skip(long count) throws IOException {
        return this.in.skip(count);
    }
}

