/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Long {
    final long value;
    public static final long MAX_VALUE = 0x7FFFFFFFFFFFFFFFL;
    public static final long MIN_VALUE = -9223372036854775808L;

    public Long(long value) {
        this.value = value;
    }

    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Long && this.value == ((Long)o).value;
    }

    public float floatValue() {
        return this.value;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public long longValue() {
        return this.value;
    }

    public static long parseLong(String string) throws NumberFormatException {
        return Long.parseLong(string, 10);
    }

    public static long parseLong(String string, int radix) throws NumberFormatException {
        boolean negative;
        if (string == null || radix < 2 || radix > 36) {
            throw new NumberFormatException();
        }
        int length = string.length();
        int i = 0;
        if (length == 0) {
            throw new NumberFormatException(string);
        }
        boolean bl = negative = string.charAt(i) == '-';
        if (negative && ++i == length) {
            throw new NumberFormatException(string);
        }
        return Long.parse(string, i, radix, negative);
    }

    private static long parse(String string, int offset, int radix, boolean negative) {
        long max = Long.MIN_VALUE / (long)radix;
        long result = 0L;
        long length = string.length();
        while ((long)offset < length) {
            int digit;
            if ((digit = Character.digit(string.charAt(offset++), radix)) == -1) {
                throw new NumberFormatException(string);
            }
            if (max > result) {
                throw new NumberFormatException(string);
            }
            long next = result * (long)radix - (long)digit;
            if (next > result) {
                throw new NumberFormatException(string);
            }
            result = next;
        }
        if (!negative && (result = -result) < 0L) {
            throw new NumberFormatException(string);
        }
        return result;
    }

    public String toString() {
        return Long.toString(this.value);
    }

    public static String toString(long l) {
        return Long.toString(l, 10);
    }

    public static String toString(long l, int radix) {
        boolean negative;
        if (radix < 2 || radix > 36) {
            radix = 10;
        }
        if (l == 0L) {
            return "0";
        }
        int count = 2;
        long j = l;
        boolean bl = negative = l < 0L;
        if (!negative) {
            count = 1;
            j = -l;
        }
        while ((l /= (long)radix) != 0L) {
            ++count;
        }
        char[] buffer = new char[count];
        do {
            int ch;
            ch = (ch = 0 - (int)(j % (long)radix)) > 9 ? ch - 10 + 97 : (ch += 48);
            buffer[--count] = (char)ch;
        } while ((j /= (long)radix) != 0L);
        if (negative) {
            buffer[0] = 45;
        }
        return new String(0, buffer.length, buffer);
    }
}

