/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

final class StackTraceElement {
    String declaringClass;
    String methodName;
    String fileName;
    int lineNumber;

    private StackTraceElement() {
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StackTraceElement)) {
            return false;
        }
        StackTraceElement castObj = (StackTraceElement)obj;
        if (this.methodName == null || castObj.methodName == null) {
            return false;
        }
        if (!this.getMethodName().equals(castObj.getMethodName())) {
            return false;
        }
        if (!this.getClassName().equals(castObj.getClassName())) {
            return false;
        }
        String localFileName = this.getFileName();
        if (localFileName == null ? castObj.getFileName() != null : !localFileName.equals(castObj.getFileName())) {
            return false;
        }
        return this.getLineNumber() == castObj.getLineNumber();
    }

    public String getClassName() {
        return this.declaringClass == null ? "<unknown class>" : this.declaringClass;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getMethodName() {
        return this.methodName == null ? "<unknown method>" : this.methodName;
    }

    public int hashCode() {
        if (this.methodName == null) {
            return 0;
        }
        return this.methodName.hashCode() ^ this.declaringClass.hashCode();
    }

    public boolean isNativeMethod() {
        return this.lineNumber == -2;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(80);
        buf.append(this.getClassName());
        buf.append('.');
        buf.append(this.getMethodName());
        if (this.isNativeMethod()) {
            buf.append("(Native Method)");
        } else {
            String fileName = this.getFileName();
            if (fileName == null) {
                buf.append("(Unknown Source)");
            } else {
                int lineNumber = this.getLineNumber();
                buf.append('(');
                buf.append(fileName);
                if (lineNumber >= 0) {
                    buf.append(':');
                    buf.append(lineNumber);
                }
                buf.append(')');
            }
        }
        return buf.toString();
    }
}

