/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

class TimeZoneTable
extends TimeZone {
    private int rawOffset;
    private SimpleTimeZone[] timezones;
    private int[][] dateOffsets;
    private long[] longOffsets;

    public TimeZoneTable(SimpleTimeZone[] timezones, int[][] dateOffsets, long[] longOffsets) {
        this.timezones = timezones;
        this.dateOffsets = dateOffsets;
        this.longOffsets = longOffsets;
        this.rawOffset = timezones[timezones.length - 1].getRawOffset();
    }

    public int getOffset(int era, int year, int month, int day, int dayOfWeek, int time) {
        if (era == 1) {
            int i = this.dateOffsets.length - 1;
            while (i >= 0) {
                if (year >= this.dateOffsets[i][0] && (year != this.dateOffsets[i][0] || month >= this.dateOffsets[i][1] && (month != this.dateOffsets[i][1] || day >= this.dateOffsets[i][2] && (day != this.dateOffsets[i][2] || time >= this.dateOffsets[i][3])))) {
                    return this.timezones[i + 1].getOffset(era, year, month, day, dayOfWeek, time);
                }
                --i;
            }
        }
        return this.timezones[0].getOffset(era, year, month, day, dayOfWeek, time);
    }

    public boolean useDaylightTime() {
        return this.timezones[this.timezones.length - 1].useDaylightTime();
    }

    public int getRawOffset() {
        return this.rawOffset;
    }

    public boolean inDaylightTime(Date time) {
        long millis = time.getTime();
        int i = this.longOffsets.length - 1;
        while (i >= 0) {
            if (millis >= this.longOffsets[i]) {
                return this.timezones[i + 1].inDaylightTime(time);
            }
            --i;
        }
        return this.timezones[0].inDaylightTime(time);
    }

    public int getOffset(long time) {
        int i = this.longOffsets.length - 1;
        while (i >= 0) {
            if (time >= this.longOffsets[i]) {
                return this.timezones[i + 1].getOffset(time);
            }
            --i;
        }
        return this.timezones[0].getOffset(time);
    }

    public String getID() {
        return this.timezones[0].getID();
    }

    public int getDSTSavings() {
        int i = this.longOffsets.length - 1;
        while (i >= 0) {
            if (this.timezones[i].useDaylightTime()) {
                return this.timezones[i].getDSTSavings();
            }
            --i;
        }
        return 0;
    }
}

