/*
 * Decompiled with CFR 0.152.
 */
package javax.bluetooth;

import com.intel.bluetooth.BlueCoveImpl;
import com.intel.bluetooth.BluetoothConnectionNotifierServiceRecordAccess;
import com.intel.bluetooth.BluetoothStack;
import com.intel.bluetooth.RemoteDeviceHelper;
import com.intel.bluetooth.ServiceRecordsRegistry;
import com.intel.bluetooth.UtilsJavaSE;
import java.util.Hashtable;
import javax.bluetooth.BluetoothStateException;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.DiscoveryAgent;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.ServiceRegistrationException;
import javax.microedition.io.Connection;

public class LocalDevice {
    private static Hashtable localDevices = new Hashtable();
    private BluetoothStack bluetoothStack;
    private DiscoveryAgent discoveryAgent;
    private String addressStr;

    private LocalDevice(BluetoothStack stack) throws BluetoothStateException {
        this.bluetoothStack = stack;
        this.discoveryAgent = new DiscoveryAgent(this.bluetoothStack);
        this.addressStr = RemoteDeviceHelper.formatBluetoothAddress(this.bluetoothStack.getLocalDeviceBluetoothAddress());
    }

    private static synchronized LocalDevice getLocalDeviceInstance() throws BluetoothStateException {
        BluetoothStack stack = BlueCoveImpl.instance().getBluetoothStack();
        LocalDevice localDevice = (LocalDevice)localDevices.get(stack);
        if (localDevice == null) {
            localDevice = new LocalDevice(stack);
            localDevices.put(stack, localDevice);
        }
        return localDevice;
    }

    public static LocalDevice getLocalDevice() throws BluetoothStateException {
        return LocalDevice.getLocalDeviceInstance();
    }

    public static boolean isPowerOn() {
        try {
            return BlueCoveImpl.instance().getBluetoothStack().isLocalDevicePowerOn();
        }
        catch (BluetoothStateException e) {
            return false;
        }
    }

    public DiscoveryAgent getDiscoveryAgent() {
        return this.discoveryAgent;
    }

    public String getFriendlyName() {
        return this.bluetoothStack.getLocalDeviceName();
    }

    public DeviceClass getDeviceClass() {
        return this.bluetoothStack.getLocalDeviceClass();
    }

    public boolean setDiscoverable(int mode) throws BluetoothStateException {
        if (mode != 10390323 && mode != 10390272 && mode != 0 && (mode < 10390272 || mode > 10390335)) {
            throw new IllegalArgumentException("Invalid discoverable mode");
        }
        return this.bluetoothStack.setLocalDeviceDiscoverable(mode);
    }

    public static String getProperty(String property) {
        try {
            if ("bluetooth.api.version".equals(property)) {
                return "1.1";
            }
            if ("obex.api.version".equals(property)) {
                return "1.1";
            }
            if ("bluecove".equals(property)) {
                return BlueCoveImpl.version;
            }
            if ("bluecove.stack".equals(property)) {
                return BlueCoveImpl.instance().getBluetoothStack().getStackID();
            }
            if ("bluecove.feature.l2cap".equals(property)) {
                return BlueCoveImpl.instance().getLocalDeviceFeature(1);
            }
            if ("bluecove.feature.service_attributes".equals(property)) {
                return BlueCoveImpl.instance().getLocalDeviceFeature(2);
            }
            if ("bluecove.feature.set_device_service_classes".equals(property)) {
                return BlueCoveImpl.instance().getLocalDeviceFeature(4);
            }
            if ("bluecove.connections".equals(property)) {
                return String.valueOf(RemoteDeviceHelper.openConnections());
            }
            return BlueCoveImpl.instance().getBluetoothStack().getLocalDeviceProperty(property);
        }
        catch (BluetoothStateException e) {
            throw (RuntimeException)UtilsJavaSE.initCause(new RuntimeException(e.getMessage()), e);
        }
    }

    public int getDiscoverable() {
        return this.bluetoothStack.getLocalDeviceDiscoverable();
    }

    public String getBluetoothAddress() {
        return this.addressStr;
    }

    public ServiceRecord getRecord(Connection notifier) {
        if (notifier == null) {
            throw new NullPointerException("notifier is null");
        }
        if (!(notifier instanceof BluetoothConnectionNotifierServiceRecordAccess)) {
            throw new IllegalArgumentException("connection is not a Bluetooth notifier");
        }
        return ((BluetoothConnectionNotifierServiceRecordAccess)((Object)notifier)).getServiceRecord();
    }

    public void updateRecord(ServiceRecord srvRecord) throws ServiceRegistrationException {
        if (srvRecord == null) {
            throw new NullPointerException("Service Record is null");
        }
        ServiceRecordsRegistry.updateServiceRecord(srvRecord);
    }
}

