/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.location;

import com.nokia.mj.impl.rt.support.Jvm;
import com.nokia.mj.impl.utils.Logger;

public class Coordinates {
    public static final int DD_MM_SS = 1;
    public static final int DD_MM = 2;
    private double iLatitude = Double.NaN;
    private double iLongitude = Double.NaN;
    private float iAltitude = Float.NaN;
    static final double MIN_LATITUDE = -90.0;
    static final double MAX_LATITUDE = 90.0;
    static final double MIN_LONGITUDE = -180.0;
    static final double MAX_LONGITUDE = 180.0;
    private static final float BEARING_ZERO = 0.0f;
    private static final float BEARING_HALF = 180.0f;
    private static final String LATITUDE_OUT_OF_RANGE = "Latitude argument is out of range: ";
    private static final String LONGITUDE_OUT_OF_RANGE = "Longitude argument is out of range: ";
    private static final String COORDINATES_NULL_ERROR = "Coordinates is null";
    private static final String INVALID_COORDINATES_ERROR = "Coordinate is invalid: ";
    private static final String INVALID_OUTPUT_TYPE_ERROR = "Output type is invalid: ";

    public Coordinates(double aLatitude, double aLongitude, float aAltitude) {
        this.setLatitude(aLatitude);
        this.setLongitude(aLongitude);
        this.iAltitude = aAltitude;
    }

    public float getAltitude() {
        return this.iAltitude;
    }

    public double getLatitude() {
        return this.iLatitude;
    }

    public double getLongitude() {
        return this.iLongitude;
    }

    public void setAltitude(float aAltitude) {
        this.iAltitude = aAltitude;
    }

    public void setLatitude(double aLatitude) {
        if (Double.isNaN(aLatitude) || aLatitude < -90.0 || aLatitude > 90.0) {
            throw new IllegalArgumentException(LATITUDE_OUT_OF_RANGE + aLatitude);
        }
        this.iLatitude = aLatitude;
    }

    public void setLongitude(double aLongitude) {
        if (Double.isNaN(aLongitude) || aLongitude < -180.0 || aLongitude >= 180.0) {
            throw new IllegalArgumentException(LONGITUDE_OUT_OF_RANGE + aLongitude);
        }
        this.iLongitude = aLongitude;
    }

    public static double convert(String aCoordinate) {
        if (aCoordinate == null) {
            throw new NullPointerException(COORDINATES_NULL_ERROR);
        }
        if ((aCoordinate = aCoordinate.trim()).length() < 4) {
            throw new IllegalArgumentException(INVALID_COORDINATES_ERROR + aCoordinate);
        }
        char lastChar = aCoordinate.charAt(aCoordinate.length() - 1);
        if (lastChar < '0' || lastChar > '9') {
            throw new IllegalArgumentException(INVALID_COORDINATES_ERROR + aCoordinate);
        }
        int ddix = aCoordinate.indexOf(58);
        if (ddix < 1) {
            throw new IllegalArgumentException(INVALID_COORDINATES_ERROR + aCoordinate);
        }
        if (ddix > 1 && aCoordinate.charAt(0) == '0' || ddix > 2 && aCoordinate.charAt(0) == '-' && aCoordinate.charAt(1) == '0') {
            throw new IllegalArgumentException(INVALID_COORDINATES_ERROR + aCoordinate);
        }
        try {
            int dd = Integer.parseInt(aCoordinate.substring(0, ddix));
            if (dd >= 180 || dd < -180) {
                throw new IllegalArgumentException(INVALID_COORDINATES_ERROR + aCoordinate);
            }
            int sign = 1;
            if (aCoordinate.startsWith("-")) {
                sign = -1;
                dd = -dd;
            }
            int inputType = 1;
            String mmstr = null;
            int mmix = aCoordinate.indexOf(58, ddix + 1);
            if (mmix < 1) {
                inputType = 2;
                mmix = aCoordinate.length();
            }
            if (inputType == 2) {
                mmstr = aCoordinate.substring(ddix + 1, aCoordinate.length());
                if (mmstr.length() < 2) {
                    throw new IllegalArgumentException(INVALID_COORDINATES_ERROR + aCoordinate);
                }
                if (mmstr.length() > 2 && mmstr.charAt(2) != '.') {
                    throw new IllegalArgumentException(INVALID_COORDINATES_ERROR + aCoordinate);
                }
                char minIntChar1 = mmstr.charAt(0);
                if (minIntChar1 < '0' || minIntChar1 > '9') {
                    throw new IllegalArgumentException(INVALID_COORDINATES_ERROR + aCoordinate);
                }
                char minIntChar2 = mmstr.charAt(1);
                if (minIntChar2 < '0' || minIntChar2 > '9') {
                    throw new IllegalArgumentException(INVALID_COORDINATES_ERROR + aCoordinate);
                }
                if (mmstr.length() > 8) {
                    throw new IllegalArgumentException(INVALID_COORDINATES_ERROR + aCoordinate);
                }
                double mm = Double.parseDouble(mmstr);
                if (mm >= 60.0 || mm < 0.0) {
                    throw new IllegalArgumentException(INVALID_COORDINATES_ERROR + aCoordinate);
                }
                double res = (double)sign * ((double)dd + mm / 60.0);
                if (res >= 180.0 || res < -180.0) {
                    throw new IllegalArgumentException(INVALID_COORDINATES_ERROR + aCoordinate);
                }
                return res;
            }
            if (inputType == 1) {
                double res;
                if (mmix - (ddix + 1) < 2) {
                    throw new IllegalArgumentException(INVALID_COORDINATES_ERROR + aCoordinate);
                }
                mmstr = aCoordinate.substring(ddix + 1, mmix);
                if (mmstr.length() > 2 && mmstr.charAt(2) != '.') {
                    throw new IllegalArgumentException(INVALID_COORDINATES_ERROR + aCoordinate);
                }
                char minIntChar1 = mmstr.charAt(0);
                if (minIntChar1 < '0' || minIntChar1 > '9') {
                    throw new IllegalArgumentException(INVALID_COORDINATES_ERROR + aCoordinate);
                }
                char minIntChar2 = mmstr.charAt(1);
                if (minIntChar2 < '0' || minIntChar2 > '9') {
                    throw new IllegalArgumentException(INVALID_COORDINATES_ERROR + aCoordinate);
                }
                int mm = Integer.parseInt(mmstr);
                if (mm > 59 || mm < 0) {
                    throw new IllegalArgumentException(INVALID_COORDINATES_ERROR + aCoordinate);
                }
                String ssstr = null;
                double ss = 0.0;
                if (mmix != aCoordinate.length()) {
                    ssstr = aCoordinate.substring(mmix + 1, aCoordinate.length());
                    if (ssstr.length() < 2) {
                        throw new IllegalArgumentException(INVALID_COORDINATES_ERROR + aCoordinate);
                    }
                    if (ssstr.length() > 2 && ssstr.charAt(2) != '.') {
                        throw new IllegalArgumentException(INVALID_COORDINATES_ERROR + aCoordinate);
                    }
                    char secIntChar1 = ssstr.charAt(0);
                    if (secIntChar1 < '0' || secIntChar1 > '9') {
                        throw new IllegalArgumentException(INVALID_COORDINATES_ERROR + aCoordinate);
                    }
                    char secIntChar2 = ssstr.charAt(1);
                    if (secIntChar2 < '0' || secIntChar2 > '9') {
                        throw new IllegalArgumentException(INVALID_COORDINATES_ERROR + aCoordinate);
                    }
                    if (ssstr.length() > 6) {
                        throw new IllegalArgumentException(INVALID_COORDINATES_ERROR + aCoordinate);
                    }
                    ss = Double.parseDouble(ssstr);
                    if (ss >= 60.0 || ss < 0.0) {
                        throw new IllegalArgumentException(INVALID_COORDINATES_ERROR + aCoordinate);
                    }
                }
                if ((res = (double)sign * ((double)dd + (double)mm / 60.0 + ss / 3600.0)) >= 180.0 || res < -180.0) {
                    throw new IllegalArgumentException(INVALID_COORDINATES_ERROR + aCoordinate);
                }
                return res;
            }
            throw new IllegalArgumentException(INVALID_COORDINATES_ERROR + aCoordinate);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(nfe.getMessage());
        }
    }

    public static String convert(double aCoordinate, int aOutputType) {
        if (aCoordinate >= 180.0 || aCoordinate < -180.0) {
            throw new IllegalArgumentException(INVALID_COORDINATES_ERROR + aCoordinate);
        }
        if (Double.isNaN(aCoordinate)) {
            throw new IllegalArgumentException(INVALID_COORDINATES_ERROR + aCoordinate);
        }
        boolean sign = aCoordinate < 0.0;
        aCoordinate = Math.abs(aCoordinate);
        if (aOutputType == 2) {
            int rmm = (int)Math.floor(6000000.0 * aCoordinate + 0.5);
            int dd = rmm / 6000000;
            int mmi = rmm / 100000 - 60 * dd;
            int mmd = rmm - 100000 * (60 * dd + mmi);
            String result = (sign ? "-" : "") + dd + ":" + (mmi < 10 ? "0" : "") + mmi + ".";
            if (mmd != 0) {
                if (mmd < 10) {
                    result = result + "0000";
                } else if (mmd < 100) {
                    result = result + "000";
                } else if (mmd < 1000) {
                    result = result + "00";
                } else if (mmd < 10000) {
                    result = result + "0";
                }
                while (mmd % 10 == 0) {
                    mmd /= 10;
                }
            }
            return result + mmd;
        }
        if (aOutputType == 1) {
            int rss = (int)Math.floor(3600000.0 * aCoordinate + 0.5);
            int dd = rss / 3600000;
            int mm = rss / 60000 - 60 * dd;
            int ssi = rss / 1000 - (3600 * dd + 60 * mm);
            int ssd = rss - 1000 * (3600 * dd + 60 * mm + ssi);
            String result = (sign ? "-" : "") + dd + ":" + (mm < 10 ? "0" : "") + mm + ":" + (ssi < 10 ? "0" : "") + ssi + ".";
            if (ssd != 0) {
                if (ssd < 10) {
                    result = result + "00";
                } else if (ssd < 100) {
                    result = result + "0";
                }
                while (ssd % 10 == 0) {
                    ssd /= 10;
                }
            }
            return result + ssd;
        }
        throw new IllegalArgumentException(INVALID_OUTPUT_TYPE_ERROR + aOutputType);
    }

    public float azimuthTo(Coordinates aTo) {
        if (aTo == null) {
            throw new NullPointerException(COORDINATES_NULL_ERROR);
        }
        if (this.iLatitude == 90.0 && aTo.iLatitude != 90.0) {
            return 180.0f;
        }
        if (this.iLatitude == -90.0) {
            return 0.0f;
        }
        return this._azimuthTo(this.iLatitude, this.iLongitude, aTo.iLatitude, aTo.iLongitude);
    }

    public float distance(Coordinates aTo) {
        if (aTo == null) {
            throw new NullPointerException(COORDINATES_NULL_ERROR);
        }
        return this._distance(this.iLatitude, this.iLongitude, aTo.iLatitude, aTo.iLongitude);
    }

    private native float _azimuthTo(double var1, double var3, double var5, double var7);

    private native float _distance(double var1, double var3, double var5, double var7);

    static {
        try {
            Jvm.loadSystemLibrary("javalocation");
        }
        catch (Exception e) {
            Logger.ELOG(24, "Unable to load javalocation dll.");
        }
    }
}

