/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.location;

import com.nokia.mj.impl.location.LAPIManager;
import com.nokia.mj.impl.rt.support.Finalizer;
import com.nokia.mj.impl.rt.support.Jvm;
import java.io.IOException;
import javax.microedition.location.AddressInfo;
import javax.microedition.location.LandmarkStore;
import javax.microedition.location.QualifiedCoordinates;

public class Landmark {
    private static final String UNABLE_TO_CREATE_LANDMARK = "Unable to create new landmark";
    private static final String LANDMARK_NAME_IS_NULL = "Landmark name is null";
    private static final String UNABLE_TO_STORE_LANDMARK_DATA = "Unable to store landmark data";
    private int iLandmarkHandle = -1;
    private int iFunctionSourceHandle = -1;
    private LandmarkStore iLandmarkStore;
    private Finalizer mFinalizer;
    private String iLandmarkName;
    private String iLandmarkDescription;
    private QualifiedCoordinates iCoordinates;
    private AddressInfo iAddressInfo;

    public Landmark(String aName, String aDescription, QualifiedCoordinates aCoordinates, AddressInfo aAddressInfo) {
        this.iFunctionSourceHandle = LAPIManager.getInstance().getFunctionSourceHandle();
        this.iLandmarkHandle = this._createNativePeer(this.iFunctionSourceHandle);
        if (this.iLandmarkHandle < 0) {
            throw new OutOfMemoryError(UNABLE_TO_CREATE_LANDMARK);
        }
        this.mFinalizer = this.registerForFinalization();
        this.setName(aName);
        this.setDescription(aDescription);
        this.setQualifiedCoordinates(aCoordinates);
        this.setAddressInfo(aAddressInfo);
    }

    Finalizer registerForFinalization() {
        return new Finalizer(){

            public void finalizeImpl() {
                Landmark.this.doFinalize();
            }
        };
    }

    Landmark(int aLandmarkHandle, int aFunctionSourceHandle) {
        this.iLandmarkHandle = aLandmarkHandle;
        this.iFunctionSourceHandle = aFunctionSourceHandle;
        this.mFinalizer = this.registerForFinalization();
    }

    final void doFinalize() {
        this._dispose(this.iFunctionSourceHandle, this.iLandmarkHandle);
    }

    public String getName() {
        if (this.iLandmarkName == null) {
            this.iLandmarkName = this._getName(this.iFunctionSourceHandle, this.iLandmarkHandle);
            if (this.iLandmarkName == null) {
                return "";
            }
        }
        return this.iLandmarkName;
    }

    public String getDescription() {
        if (this.iLandmarkDescription == null) {
            this.iLandmarkDescription = this._getDescription(this.iFunctionSourceHandle, this.iLandmarkHandle);
        }
        return this.iLandmarkDescription;
    }

    public QualifiedCoordinates getQualifiedCoordinates() {
        float[] coordinateInfo;
        double[] coordinates;
        int err;
        if (this.iCoordinates == null && (err = this._getCoordinates(this.iFunctionSourceHandle, this.iLandmarkHandle, coordinates = new double[2], coordinateInfo = new float[3])) == 0) {
            this.iCoordinates = new QualifiedCoordinates(coordinates[0], coordinates[1], coordinateInfo[0], coordinateInfo[1], coordinateInfo[2]);
        }
        return this.iCoordinates;
    }

    public AddressInfo getAddressInfo() {
        String[] addressInfos;
        if (this.iAddressInfo == null && (addressInfos = this._getAddressInfo(this.iFunctionSourceHandle, this.iLandmarkHandle)) != null && addressInfos.length > 0) {
            AddressInfo info = new AddressInfo();
            for (int i = 0; i < addressInfos.length; ++i) {
                if (addressInfos[i] == null) continue;
                info.setField(i + 1, addressInfos[i]);
            }
            this.iAddressInfo = info;
        }
        return this.iAddressInfo;
    }

    public void setName(String aName) {
        if (aName == null) {
            throw new NullPointerException(LANDMARK_NAME_IS_NULL);
        }
        this.iLandmarkName = aName;
    }

    public void setDescription(String aDescription) {
        int err = this._setDescription(this.iFunctionSourceHandle, this.iLandmarkHandle, aDescription);
        this.checkSetError(err);
        this.iLandmarkDescription = aDescription;
    }

    public void setQualifiedCoordinates(QualifiedCoordinates aCoordinates) {
        double[] coordinates = null;
        float[] coordinateInfo = null;
        if (aCoordinates != null) {
            coordinates = new double[]{aCoordinates.getLatitude(), aCoordinates.getLongitude()};
            coordinateInfo = new float[]{aCoordinates.getAltitude(), aCoordinates.getHorizontalAccuracy(), aCoordinates.getVerticalAccuracy()};
        }
        int err = this._setCoordinates(this.iFunctionSourceHandle, this.iLandmarkHandle, coordinates, coordinateInfo);
        this.checkSetError(err);
        this.iCoordinates = aCoordinates;
    }

    public void setAddressInfo(AddressInfo aAddressInfo) {
        String[] addressInfo = null;
        if (aAddressInfo != null) {
            addressInfo = new String[17];
            for (int i = 0; i < 17; ++i) {
                addressInfo[i] = aAddressInfo.getField(i + 1);
            }
        }
        int err = this._setAddressInfo(this.iFunctionSourceHandle, this.iLandmarkHandle, addressInfo);
        this.checkSetError(err);
        this.iAddressInfo = aAddressInfo;
    }

    synchronized void associateToStore(LandmarkStore aLandmarkStore) {
        this.iLandmarkStore = aLandmarkStore;
    }

    synchronized LandmarkStore getAssociatedStore() {
        return this.iLandmarkStore;
    }

    synchronized int getHandle() {
        return this.iLandmarkHandle;
    }

    synchronized void prepareForSave() throws IOException {
        int error;
        if (this.iCoordinates != null) {
            this.setQualifiedCoordinates(this.iCoordinates);
        }
        if (this.iAddressInfo != null) {
            this.setAddressInfo(this.iAddressInfo);
        }
        if (this.iLandmarkName != null && (error = this._setName(this.iFunctionSourceHandle, this.iLandmarkHandle, this.iLandmarkName)) != 0) {
            throw new IOException(UNABLE_TO_STORE_LANDMARK_DATA);
        }
    }

    private void checkSetError(int aError) {
        if (aError != 0) {
            throw new OutOfMemoryError(UNABLE_TO_STORE_LANDMARK_DATA);
        }
    }

    private native int _createNativePeer(int var1);

    private native String _getName(int var1, int var2);

    private native String _getDescription(int var1, int var2);

    private native int _getCoordinates(int var1, int var2, double[] var3, float[] var4);

    private native String[] _getAddressInfo(int var1, int var2);

    private native int _setName(int var1, int var2, String var3);

    private native int _setDescription(int var1, int var2, String var3);

    private native int _setCoordinates(int var1, int var2, double[] var3, float[] var4);

    private native int _setAddressInfo(int var1, int var2, String[] var3);

    private native void _dispose(int var1, int var2);

    static {
        try {
            Jvm.loadSystemLibrary("javalocation");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

