/*
 * Decompiled with CFR 0.152.
 */
package junit.runner;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class TestCaseClassLoader
extends ClassLoader {
    private Vector fPathItems;
    private String[] defaultExclusions = new String[]{"junit.framework.", "junit.extensions.", "junit.runner."};
    static final String EXCLUDED_FILE = "excluded.properties";
    private Vector fExcluded;

    public TestCaseClassLoader() {
        this(System.getProperty("java.class.path"));
    }

    public TestCaseClassLoader(String string) {
        this.scanPath(string);
        this.readExcludedPackages();
    }

    private void scanPath(String string) {
        String string2 = System.getProperty("path.separator");
        this.fPathItems = new Vector(10);
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            this.fPathItems.addElement(stringTokenizer.nextToken());
        }
    }

    public URL getResource(String string) {
        return ClassLoader.getSystemResource(string);
    }

    public InputStream getResourceAsStream(String string) {
        return ClassLoader.getSystemResourceAsStream(string);
    }

    public boolean isExcluded(String string) {
        int n = 0;
        while (n < this.fExcluded.size()) {
            if (string.startsWith((String)this.fExcluded.elementAt(n))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(string);
        if (clazz != null) {
            return clazz;
        }
        if (this.isExcluded(string)) {
            try {
                clazz = this.findSystemClass(string);
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (clazz == null) {
            byte[] byArray = this.lookupClassData(string);
            if (byArray == null) {
                throw new ClassNotFoundException();
            }
            clazz = this.defineClass(string, byArray, 0, byArray.length);
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private byte[] lookupClassData(String string) throws ClassNotFoundException {
        byte[] byArray = null;
        int n = 0;
        while (n < this.fPathItems.size()) {
            String string2 = (String)this.fPathItems.elementAt(n);
            String string3 = String.valueOf(string.replace('.', '/')) + ".class";
            byArray = this.isJar(string2) ? this.loadJarData(string2, string3) : this.loadFileData(string2, string3);
            if (byArray != null) {
                return byArray;
            }
            ++n;
        }
        throw new ClassNotFoundException(string);
    }

    boolean isJar(String string) {
        return string.endsWith(".jar") || string.endsWith(".zip");
    }

    private byte[] loadFileData(String string, String string2) {
        File file = new File(string, string2);
        if (file.exists()) {
            return this.getClassData(file);
        }
        return null;
    }

    private byte[] getClassData(File file) {
        try {
            int n;
            FileInputStream fileInputStream = new FileInputStream(file);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1000);
            byte[] byArray = new byte[1000];
            while ((n = fileInputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            fileInputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] loadJarData(String string, String string2) {
        InputStream inputStream;
        block16: {
            byte[] byArray;
            ZipFile zipFile = null;
            inputStream = null;
            File file = new File(string);
            if (!file.exists()) {
                return null;
            }
            try {
                zipFile = new ZipFile(file);
            }
            catch (IOException iOException) {
                return null;
            }
            ZipEntry zipEntry = zipFile.getEntry(string2);
            if (zipEntry == null) {
                return null;
            }
            int n = (int)zipEntry.getSize();
            try {
                try {
                    inputStream = zipFile.getInputStream(zipEntry);
                    byte[] byArray2 = new byte[n];
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            zipFile.close();
                            byArray = byArray2;
                            Object var11_12 = null;
                            break;
                        }
                        int n3 = inputStream.read(byArray2, n2, byArray2.length - n2);
                        n2 += n3;
                    }
                }
                catch (IOException iOException) {
                    break block16;
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                try {
                    if (inputStream == null) throw throwable;
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            if (inputStream == null) return byArray;
            inputStream.close();
            return byArray;
        }
        Object var11_14 = null;
        try {}
        catch (IOException iOException) {
            return null;
        }
        if (inputStream == null) return null;
        inputStream.close();
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readExcludedPackages() {
        Enumeration<?> enumeration;
        InputStream inputStream;
        this.fExcluded = new Vector(10);
        int n = 0;
        while (true) {
            if (n >= this.defaultExclusions.length) {
                inputStream = this.getClass().getResourceAsStream(EXCLUDED_FILE);
                if (inputStream != null) break;
                return;
            }
            this.fExcluded.addElement(this.defaultExclusions[n]);
            ++n;
        }
        Properties properties = new Properties();
        try {
            try {
                properties.load(inputStream);
            }
            catch (IOException iOException) {
                Object var3_4 = null;
                try {
                    inputStream.close();
                    return;
                }
                catch (IOException iOException2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            try {}
            catch (IOException iOException) {}
            inputStream.close();
            throw throwable;
            throw throwable;
        }
        {
            enumeration = null;
        }
        try {}
        catch (IOException iOException) {}
        inputStream.close();
        enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith("excluded.")) continue;
            String string2 = properties.getProperty(string);
            if ((string2 = string2.trim()).endsWith("*")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (string2.length() <= 0) continue;
            this.fExcluded.addElement(string2);
        }
        return;
    }
}

