/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description:
*
*/

package hello;

import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;

/**
 * Class HelloMIDlet tests system properties
 */
public class HelloMIDlet extends MIDlet implements CommandListener
{

    private static final String NETWORK_ACCESS = "com.nokia.mid.network.access";
    private static final String BATTERY_LEVEL = "com.nokia.mid.batterylevel";
    private static final String COUNTRY_CODE = "com.nokia.mid.countrycode";
    private static final String IMEI = "com.nokia.mid.imsi";
    private static final String IMSI = "com.nokia.mid.imei";
    private static final String NETWORK_AVAILABILITY = "com.nokia.mid.networkavailability";
    private static final String NETWORK_ID = "com.nokia.mid.networkid";
    private static final String NETWORK_SIGNAL = "com.nokia.mid.networksignal";
    private static final String EMAIL_RECIEVE_SETTINGS = "com.nokia.mid.settings.email-receive-protocol";
    private static final String EMAIL_SEND_SETTINGS = "com.nokia.mid.settings.email-send-protocol";
    private static final String CELLID = "com.nokia.mid.cellid";
    private static final String MSISDN = "com.nokia.mid.msisdn";
    private static final String DATEFORMAT = "com.nokia.mid.dateformat";
    private static final String TIMEFORMAT = "com.nokia.mid.timeformat";
    private static final String NETWORKSTATUS = "com.nokia.mid.networkstatus";
    private boolean midletPaused = false;

    //<editor-fold defaultstate="collapsed" desc=" Generated Fields ">//GEN-BEGIN:|fields|0|
    private Command exitCommand;
    private Form form;
    //</editor-fold>//GEN-END:|fields|0|

    /**
     * The HelloMIDlet constructor.
     */
    public HelloMIDlet()
    {
    }

    //<editor-fold defaultstate="collapsed" desc=" Generated Methods ">//GEN-BEGIN:|methods|0|
    //</editor-fold>//GEN-END:|methods|0|

    //<editor-fold defaultstate="collapsed" desc=" Generated Method: initialize ">//GEN-BEGIN:|0-initialize|0|0-preInitialize
    /**
     * Initilizes the application.
     * It is called only once when the MIDlet is started. The method is called before the <code>startMIDlet</code> method.
     */
    private void initialize()  //GEN-END:|0-initialize|0|0-preInitialize
    {
        // write pre-initialize user code here
//GEN-LINE:|0-initialize|1|0-postInitialize
        // write post-initialize user code here
    }//GEN-BEGIN:|0-initialize|2|
    //</editor-fold>//GEN-END:|0-initialize|2|

    //<editor-fold defaultstate="collapsed" desc=" Generated Method: startMIDlet ">//GEN-BEGIN:|3-startMIDlet|0|3-preAction
    /**
     * Performs an action assigned to the Mobile Device - MIDlet Started point.
     */
    public void startMIDlet()  //GEN-END:|3-startMIDlet|0|3-preAction
    {
        // write pre-action user code here
        switchDisplayable(null, getForm());//GEN-LINE:|3-startMIDlet|1|3-postAction
        // write post-action user code here
    }//GEN-BEGIN:|3-startMIDlet|2|
    //</editor-fold>//GEN-END:|3-startMIDlet|2|

    //<editor-fold defaultstate="collapsed" desc=" Generated Method: resumeMIDlet ">//GEN-BEGIN:|4-resumeMIDlet|0|4-preAction
    /**
     * Performs an action assigned to the Mobile Device - MIDlet Resumed point.
     */
    public void resumeMIDlet()  //GEN-END:|4-resumeMIDlet|0|4-preAction
    {
        // write pre-action user code here
//GEN-LINE:|4-resumeMIDlet|1|4-postAction
        // write post-action user code here
    }//GEN-BEGIN:|4-resumeMIDlet|2|
    //</editor-fold>//GEN-END:|4-resumeMIDlet|2|

    //<editor-fold defaultstate="collapsed" desc=" Generated Method: switchDisplayable ">//GEN-BEGIN:|5-switchDisplayable|0|5-preSwitch
    /**
     * Switches a current displayable in a display. The <code>display</code> instance is taken from <code>getDisplay</code> method. This method is used by all actions in the design for switching displayable.
     * @param alert the Alert which is temporarily set to the display; if <code>null</code>, then <code>nextDisplayable</code> is set immediately
     * @param nextDisplayable the Displayable to be set
     */
    public void switchDisplayable(Alert alert, Displayable nextDisplayable)  //GEN-END:|5-switchDisplayable|0|5-preSwitch
    {
        // write pre-switch user code here
        Display display = getDisplay();//GEN-BEGIN:|5-switchDisplayable|1|5-postSwitch
        if (alert == null)
        {
            display.setCurrent(nextDisplayable);
        }
        else
        {
            display.setCurrent(alert, nextDisplayable);
        }//GEN-END:|5-switchDisplayable|1|5-postSwitch
        // write post-switch user code here
    }//GEN-BEGIN:|5-switchDisplayable|2|
    //</editor-fold>//GEN-END:|5-switchDisplayable|2|

    //<editor-fold defaultstate="collapsed" desc=" Generated Method: commandAction for Displayables ">//GEN-BEGIN:|7-commandAction|0|7-preCommandAction
    /**
     * Called by a system to indicated that a command has been invoked on a particular displayable.
     * @param command the Command that was invoked
     * @param displayable the Displayable where the command was invoked
     */
    public void commandAction(Command command, Displayable displayable)  //GEN-END:|7-commandAction|0|7-preCommandAction
    {
        // write pre-action user code here
        if (displayable == form)  //GEN-BEGIN:|7-commandAction|1|19-preAction
        {
            if (command == exitCommand)  //GEN-END:|7-commandAction|1|19-preAction
            {
                // write pre-action user code here
                exitMIDlet();//GEN-LINE:|7-commandAction|2|19-postAction
                // write post-action user code here
            }//GEN-BEGIN:|7-commandAction|3|7-postCommandAction
        }//GEN-END:|7-commandAction|3|7-postCommandAction
        // write post-action user code here
    }//GEN-BEGIN:|7-commandAction|4|
    //</editor-fold>//GEN-END:|7-commandAction|4|

    //<editor-fold defaultstate="collapsed" desc=" Generated Getter: exitCommand ">//GEN-BEGIN:|18-getter|0|18-preInit
    /**
     * Returns an initiliazed instance of exitCommand component.
     * @return the initialized component instance
     */
    public Command getExitCommand()
    {
        if (exitCommand == null)  //GEN-END:|18-getter|0|18-preInit
        {
            // write pre-init user code here
            exitCommand = new Command("Exit", Command.EXIT, 0);//GEN-LINE:|18-getter|1|18-postInit
            // write post-init user code here
        }//GEN-BEGIN:|18-getter|2|
        return exitCommand;
    }
    //</editor-fold>//GEN-END:|18-getter|2|

    //<editor-fold defaultstate="collapsed" desc=" Generated Getter: form ">//GEN-BEGIN:|14-getter|0|14-preInit
    /**
     * Returns an initiliazed instance of form component.
     * @return the initialized component instance
     */
    public Form getForm()
    {
        if (form == null)  //GEN-END:|14-getter|0|14-preInit
        {
            // write pre-init user code here
            form = new Form("MobInfo Properties", new Item[] { });//GEN-BEGIN:|14-getter|1|14-postInit
            form.addCommand(getExitCommand());
            form.setCommandListener(this);//GEN-END:|14-getter|1|14-postInit
            // write post-init user code here
        }//GEN-BEGIN:|14-getter|2|
        return form;
    }
    //</editor-fold>//GEN-END:|14-getter|2|



    /**
     * Returns a display instance.
     * @return the display instance.
     */
    public Display getDisplay()
    {
        return Display.getDisplay(this);
    }

    /**
     * Exits MIDlet.
     */
    public void exitMIDlet()
    {
        switchDisplayable(null, null);
        destroyApp(true);
        notifyDestroyed();
    }

    /**
     * Called when MIDlet is started.
     * Checks whether the MIDlet have been already started and initialize/starts or resumes the MIDlet.
     */
    public void startApp()
    {
        if (midletPaused)
        {
            resumeMIDlet();
        }
        else
        {
            initialize();
            startMIDlet();
        }
        midletPaused = false;
        form.append("\n");
        testProperties();
    }

    /**
     * Called when MIDlet is paused.
     */
    public void pauseApp()
    {
        midletPaused = true;
    }

    /**
     * Called to signal the MIDlet to terminate.
     * @param unconditional if true, then the MIDlet has to be unconditionally terminated and all resources has to be released.
     */
    public void destroyApp(boolean unconditional)
    {
    }

    public void testProperties()
    {
        try
        {
            logResult("BATTERY_LEVEL: ",System.getProperty(BATTERY_LEVEL));
            logResult("COUNTRY_CODE: ",System.getProperty(COUNTRY_CODE));
            logResult("IMEI: ",System.getProperty(IMEI));
            logResult("IMSI: ",System.getProperty(IMSI));
            logResult("NETWORK_AVAILABILITY: ",System.getProperty(NETWORK_AVAILABILITY));
            logResult("NETWORK_ID: ",System.getProperty(NETWORK_ID));
            logResult("NETWORK_SIGNAL: ",System.getProperty(NETWORK_SIGNAL));
            logResult("CELLID: ",System.getProperty(CELLID));
            logResult("MSISDN: ",System.getProperty(MSISDN));
            logResult("DATEFORMAT: ",System.getProperty(DATEFORMAT));
            logResult("TIMEFORMAT: ",System.getProperty(TIMEFORMAT));
            logResult("NETWORKSTATUS: ",System.getProperty(NETWORKSTATUS));
        }
        catch (Exception e)
        {
            System.out.println("Test Properties Failed: "+e);
        }
    }

    private void logResult(String name, String msg)
    {
        form.append(name+"\n");
        form.append(msg+"\n");
        System.out.println(name+msg);
    }

}
