/*
 * Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
 * All rights reserved.
 * This component and the accompanying materials are made available
 * under the terms of "Eclipse Public License v1.0"
 * which accompanies this distribution, and is available
 * at the URL "http://www.eclipse.org/legal/epl-v10.html".
 *
 * Initial Contributors:
 * Nokia Corporation - initial contribution.
 *
 * Contributors:
 *
 * Description:
 *
 */

#ifndef MSG_UNIFIED_EDITOR_BODY_EDITOR_H
#define MSG_UNIFIED_EDITOR_BODY_EDITOR_H

// SYSTEM INCLUDES
#include <msgunieditorbasewidget.h>
#include <HbTextEdit>

// FORWARD DECLARATIONS
class HbPushButton;
class HbFrameItem;
class HbTextItem;
class UniEditorPluginLoader;
class UniEditorPluginInterface;
class UniEditorGenUtils;
class ConvergedMessage;

/**
 * Custom editor class
 */
class MsgEditor : public HbTextEdit
{
    Q_OBJECT
    
public:    
    /**
     * Constructor
     */
    MsgEditor(QGraphicsItem *parent = 0);
    
protected:
    /**
     * reimplemented from base class.
     */
    void inputMethodEvent(QInputMethodEvent *event);
};

/**
 * This class is a custom layout widget for Msg Editor.
 */

class MsgUnifiedEditorBodyEditor : public MsgUnifiedEditorBaseWidget
{
    Q_OBJECT

public:

    /**
     * Constructor
     */
    MsgUnifiedEditorBodyEditor(QGraphicsItem *parent = 0);

    /**
     * Destructor
     */
    virtual ~MsgUnifiedEditorBodyEditor();

public:
    /* Setter/Getter methods */

    /**
     * Returns the editor's contents.
     * @return Editor contents
     */
    QString content() const;

    /**
     * Set the editor's content.
     * @param contentText content text to set.
     */
    void setContent(const QString &contentText);

    /**
     * This function does initialisations needed for character counter
     */
    void setEncodingSettingsL();
    
    /**
     * Packs body editor data to ConvergedMessage object.
     * @param msg. ConvergedMessage object.(out parameter)
     */
    void packMessage(ConvergedMessage &msg);
    
    /**
     * Populate data into body editor from ConvergedMessage.
     * @param msg, ConvergedMessage object.
     */
    void populateContent(const ConvergedMessage& msg);
   
signals:

    /**
     * Emitted when send button is pressed.
     */
    void sendMessage();
    
public slots:

    /**
     * Enables/Disables send button based on message rediness for send.
     */
    void enableSendButton(bool enable);
    
private slots:

    /**
     * Called when editor content is chaged.
     */
    void onContentsChanged();
    
    /**
     * called when send button is pressed/released.
     */  
    void onPressed();
    void onReleased();

private:

    /**
     * Initialization function.
     */
    void init();
    
	 /**
	  * To update back ground.
	  */
    void updateButtonBackgroundAndColor(const QString& bg,const QString& iconColor);

private:

    /**
     * Instance of message edit.
     * Will be deleted automatically by parent.
     * Own.
     */
    MsgEditor *mMsgEditor;

    /**
     * Instance of push button.
     * Will be deleted automatically by parent.
     * Own.
     */
    HbPushButton *mSendButton;

    /**
     * Instance of HbTextItem
     * Will be deleted automatically by parent.
     * Own.
     */
    HbTextItem *mCharCounter;

    /**
     * Instance of HbFrameItem
     * Will be deleted automatically by parent.
     * Own.
     */
    HbFrameItem* mBackgroundItem;
    
    /**
     * Holds char type supported
     */
    int mCharSupportType;

    /**
     * Instance of UniEditorPluginInterface
     * Will be deleted automatically by parent.
     * Own.
     */
    UniEditorPluginInterface* mPluginInterface;

    /**
     * Instance of UniEditorPluginLoader
     * Will be deleted when UniEditorPluginInterface object is deleted
     * Not Own.
     */
    UniEditorPluginLoader* mPluginLoader;

    /**
     * Instance of UniEditorGenUtils
     * Own.
     */
    UniEditorGenUtils* mEditorUtils;

#ifdef UNIEDITOR_UNIT_TEST
    /**
     * Unit Testing
     */
    friend class TestMsgUnifiedEditorBodyEditor;
#endif
};

#endif // MSG_UNIFIED_EDITOR_BODY_EDITOR_H
// EOF
