/*
* Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
* All rights reserved.
* This component and the accompanying materials are made available
* under the terms of "Eclipse Public License v1.0"
* which accompanies this distribution, and is available
* at the URL "http://www.eclipse.org/legal/epl-v10.html".
*
* Initial Contributors:
* Nokia Corporation - initial contribution.
*
* Contributors:
*
* Description: Test class for MsgUnifiedEditorPixmapWidget
*
*/

#include "unittest_msgunieditorutils.h"    
#include <QtTest/QTest>
#include <QtTest/QSignalSpy>
#include "msguitest.h"
const QString IMAGE_JPEG_CIF_PATH = "c:\\data\\testUniEditor\\JPEG_CIF.JPG";
const QString IMAGE_MIMETYPE("image");
TestMsgUnifiedEditorUtils::TestMsgUnifiedEditorUtils()
    {
    
    }
TestMsgUnifiedEditorUtils::~TestMsgUnifiedEditorUtils()
    {
    
    }
void TestMsgUnifiedEditorUtils::initTestCase()
    {
        mMsgUnifiedEditorUtils = new MsgUnifiedEditorUtils();
        QVERIFY(mMsgUnifiedEditorUtils != NULL);
    }
           
void TestMsgUnifiedEditorUtils::test_Constructor()
    {
    /*nothing to check*/
    }


void TestMsgUnifiedEditorUtils::test_handleOk()
    {
        QSignalSpy signaleHandlerOK(mMsgUnifiedEditorUtils, SIGNAL(requestOk(const QVariant&)));
        QVariant lVariant;
        lVariant.setValue(QString("OK"));

        QCOMPARE( signaleHandlerOK.count(), 0 );
        mMsgUnifiedEditorUtils->handleOk(lVariant);
        QCOMPARE( signaleHandlerOK.count(), 1 );
    }

void TestMsgUnifiedEditorUtils::test_handleError()
    {
        QSignalSpy signaleHandlerError(mMsgUnifiedEditorUtils, SIGNAL(requestError(int, const QString&)));
        QString lString = "Not found";
        int errorcode = KErrNotFound;
        QCOMPARE( signaleHandlerError.count(), 0 );
        mMsgUnifiedEditorUtils->handleError(errorcode, lString);
        QCOMPARE( signaleHandlerError.count(), 1 );
    }

void TestMsgUnifiedEditorUtils::test_launchContentViewer()
    {
    mMsgUnifiedEditorUtils->launchContentViewer(IMAGE_MIMETYPE,IMAGE_JPEG_CIF_PATH);
    }

void TestMsgUnifiedEditorUtils::cleanupTestCase()
    {
        delete mMsgUnifiedEditorUtils;
    }

//entry point.
MSGUI_TEST_MAIN(TestMsgUnifiedEditorUtils)
