/*
 * Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
 * All rights reserved.
 * This component and the accompanying materials are made available
 * under the terms of "Eclipse Public License v1.0"
 * which accompanies this distribution, and is available
 * at the URL "http://www.eclipse.org/legal/epl-v10.html".
 *
 * Initial Contributors:
 * Nokia Corporation - initial contribution.
 *
 * Contributors:
 *
 * Description: Widget for BodyText.
 *
 */

#ifndef MSG_BODY_TEXT_EDIT_H
#define MSG_BODY_TEXT_EDIT_H

// SYSTEM INCLUDES
#include <HbTextEdit>

// FORWORD DECLARATIONS
class MsgConversationViewItem;


/**
 * @class MsgBodyTextEdit
 * @brief This class is a widget for Text Item in the conversation View.
 */
class MsgBodyTextEdit: public HbTextEdit
{
Q_OBJECT

public:

    /**
     * Constructor
     */
    MsgBodyTextEdit(MsgConversationViewItem* item, QGraphicsItem *parent =0);

    /**
     * Destructor
     */
    virtual ~MsgBodyTextEdit();

protected:
   
    /*
     * Handle Gestures
	 * @param event gesture event
     */
    void gestureEvent(QGestureEvent* event);
    
    
private:
    
    /*
     * Conversation View Item
     * Not Own
     */
    MsgConversationViewItem* mItem;
	
#ifdef MSGUI_UNIT_TEST
    /**
     * Unit Testing
     */
    friend class TestMsgBodyTextEdit;
#endif

};

#endif // MSG_BODY_TEXT_EDIT_H
// EOF
