/*
 * Copyright (c) 2009 Nokia Corporation and/or its subsidiary(-ies).
 * All rights reserved.
 * This component and the accompanying materials are made available
 * under the terms of "Eclipse Public License v1.0"
 * which accompanies this distribution, and is available
 * at the URL "http://www.eclipse.org/legal/epl-v10.html".
 *
 * Initial Contributors:
 * Nokia Corporation - initial contribution.
 *
 * Contributors:
 *
 * Description:
 *
 */

#include "msgbodytextedit.h"
#include "msgconversationviewitem.h"

// SYSTEM INCLUDES

//---------------------------------------------------------------
// MsgBodyTextEdit::MsgBodyTextEdit
// @see header
//---------------------------------------------------------------
MsgBodyTextEdit::MsgBodyTextEdit(MsgConversationViewItem* item, QGraphicsItem *parent): 
HbTextEdit(parent), mItem(item)
{
    //set textedit properties
    setCursorVisibility(Hb::TextCursorHidden);
    setFlag(QGraphicsItem::ItemIsFocusable,false);
    setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);
    setBackgroundItem(0);
    setSmileysEnabled(true);
    setReadOnly(true);
    setScrollable(false);

    // grab gestures
    grabGesture(Qt::TapGesture);
}

//---------------------------------------------------------------
// MsgBodyTextEdit::~MsgBodyTextEdit
// @see header
//---------------------------------------------------------------
MsgBodyTextEdit::~MsgBodyTextEdit()
{
    
}

//---------------------------------------------------------------
// MsgBodyTextEdit::gestureEvent
// @see header file
//---------------------------------------------------------------
void MsgBodyTextEdit::gestureEvent(QGestureEvent *event)
{
    mItem->gestureEvent(event);    
}

// EOF
